/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.grove.GroveClient;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ClusterStackHelper;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.CloudResources;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Instance;
import io.imply.cloud.model.InstanceHealth;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.InstanceHealthDataManager;
import io.imply.cloud.util.ClusterNodesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.joda.time.DateTime;

public class OnPremClusterStackHelper
implements ClusterStackHelper,
OnPremHelpers {
    private final AccountDataManager accountDataManager;
    protected final ClusterDataManager clusterDataManager;
    private final InstanceHealthDataManager instanceHealthDataManager;
    private final GroveClient groveClient;
    private final ApplicationConfig applicationConfig;
    private final ClusterNodesHelper clusterNodesHelper;

    @Inject
    public OnPremClusterStackHelper(AccountDataManager accountDataManager, ClusterDataManager clusterDataManager, InstanceHealthDataManager instanceHealthDataManager, GroveClient groveClient, ApplicationConfig applicationConfig, ClusterNodesHelper clusterNodesHelper) {
        this.accountDataManager = accountDataManager;
        this.clusterDataManager = clusterDataManager;
        this.instanceHealthDataManager = instanceHealthDataManager;
        this.groveClient = groveClient;
        this.applicationConfig = applicationConfig;
        this.clusterNodesHelper = clusterNodesHelper;
    }

    public CloudResources getClusterDetails(String clusterId, boolean throwExceptions, boolean skipHostAndLoadBalancerInfo, boolean forceRefresh) {
        return this.getClusterDetails(clusterId, throwExceptions, skipHostAndLoadBalancerInfo, forceRefresh, 120);
    }

    public CloudResources getClusterDetails(String clusterId, boolean throwExceptions, boolean skipHostAndLoadBalancerInfo, boolean forceRefresh, int refreshPeriodInSeconds) {
        OnPremCluster cluster = this.onprem(this.clusterDataManager.getOrNull(clusterId));
        if (cluster == null) {
            return null;
        }
        Account account = this.accountDataManager.get(cluster.getAccountId());
        Map<String, Node> groveNodes = this.groveClient.getGroveNodes(account.getGroveServer(), false).stream().collect(Collectors.toMap(Node::getAddress, x -> x));
        Map nodes = this.clusterNodesHelper.getNodesByImplyNodeType(clusterId);
        Map<ImplyNodeType, List> hosts = nodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> {
            ArrayList<Instance> instances = new ArrayList<Instance>();
            for (Map.Entry entry : ((Map)x.getValue()).entrySet()) {
                String address = this.applicationConfig.isUseLocalhostForHostList() ? "localhost" : (String)entry.getKey();
                boolean cattle = entry.getValue() != null && ((NodeConfiguration)entry.getValue()).isCattle() != null && ((NodeConfiguration)entry.getValue()).isCattle() != false;
                Node groveNode = (Node)groveNodes.get(entry.getKey());
                String state = "offline";
                String hostname = (String)entry.getKey();
                String implyVersion = null;
                Integer clusterVersion = null;
                List implyNodeTypes = null;
                if (groveNode != null) {
                    state = groveNode.isOnline() ? String.format("online (%s)", groveNode.isImplyRunning() ? "running" : "not running") : "offline";
                    hostname = groveNode.getHostname();
                    implyVersion = groveNode.getImplyVersion();
                    clusterVersion = groveNode.getManagerClusterVersion();
                    implyNodeTypes = groveNode.getImplyNodeTypes();
                }
                InstanceHealth health = this.instanceHealthDataManager.getOrNull(clusterId, hostname, (ImplyNodeType)x.getKey());
                instances.add(new Instance(hostname, "onprem", state, address, null, address, Boolean.valueOf(false), Boolean.valueOf(!cattle), Boolean.valueOf(groveNode != null && groveNode.isOnline()), Boolean.valueOf(groveNode != null && groveNode.isImplyRunning()), implyVersion, clusterVersion, implyNodeTypes, health != null ? health.simplifiedForDescribeCluster() : null, null, hostname));
            }
            return instances;
        }));
        return CloudResources.builder().withKey(clusterId).withHosts(hosts).withFetchTime(DateTime.now()).withLoadBalancers(this.getLoadBalancers(clusterId)).build();
    }

    protected Map<String, String> getLoadBalancers(String clusterId) {
        return null;
    }

    public Map<String, ImplyNodeType> getAutoScalingGroupsFromCfStack(CloudResources stackInfo) {
        throw new UnsupportedOperationException();
    }

    public List<Instance> describeInstances(Collection<String> instanceIds, Set<String> preferredAddresses, Account account, String requestId) {
        throw new UnsupportedOperationException();
    }

    public void refreshClusterDetails(String clusterId) {
        this.getClusterDetails(clusterId, false, false, true);
    }

    public Map<String, String> getStackParameters(String stackName, String requestId, Account account) {
        throw new UnsupportedOperationException();
    }

    public boolean stackExists(String stackName, String requestId, Account account) {
        throw new UnsupportedOperationException();
    }

    @Generated
    protected AccountDataManager getAccountDataManager() {
        return this.accountDataManager;
    }

    @Generated
    protected ClusterDataManager getClusterDataManager() {
        return this.clusterDataManager;
    }

    @Generated
    protected InstanceHealthDataManager getInstanceHealthDataManager() {
        return this.instanceHealthDataManager;
    }

    @Generated
    protected GroveClient getGroveClient() {
        return this.groveClient;
    }

    @Generated
    protected ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    @Generated
    protected ClusterNodesHelper getClusterNodesHelper() {
        return this.clusterNodesHelper;
    }
}

