/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.persistence.ClusterDataManager;
import java.util.function.Consumer;
import org.apache.commons.lang3.BooleanUtils;

public class OnPremClusterSecurityHelper
implements OnPremHelpers {
    private final ClusterDataManager clusterDataManager;
    private final ApplicationConfig applicationConfig;
    private final SecurityConfig securityConfig;

    @Inject
    public OnPremClusterSecurityHelper(ClusterDataManager clusterDataManager, ApplicationConfig applicationConfig, SecurityConfig securityConfig) {
        this.clusterDataManager = clusterDataManager;
        this.applicationConfig = applicationConfig;
        this.securityConfig = securityConfig;
    }

    public OnPremCluster maybeUpdateSecurity(OnPremCluster cluster, Consumer<String> addInfoNotification) {
        if (this.applicationConfig.isDevelopmentMode()) {
            return cluster;
        }
        Cluster.Builder updatedCluster = cluster.cloner();
        boolean updated = false;
        boolean useTls = BooleanUtils.isTrue((Boolean)cluster.isUseTls());
        boolean useAuthentication = BooleanUtils.isTrue((Boolean)cluster.isUseAuthentication());
        if (!this.applicationConfig.useTls() && useTls) {
            addInfoNotification.accept("Disabling cluster TLS");
            updatedCluster.withUseTls(Boolean.valueOf(false));
            updated = true;
        }
        if (!this.applicationConfig.useAuthentication() && useAuthentication) {
            addInfoNotification.accept("Disabling cluster authentication");
            updatedCluster.withUseAuthentication(Boolean.valueOf(false));
            updated = true;
        }
        if (this.applicationConfig.useAuthentication() && !useAuthentication) {
            addInfoNotification.accept("Enabling cluster authentication");
            updatedCluster.withUseAuthentication(Boolean.valueOf(true));
            updated = true;
        }
        if (this.applicationConfig.useTls() && !useTls) {
            addInfoNotification.accept("Enabling cluster TLS");
            updatedCluster.withUseTls(Boolean.valueOf(true));
            updated = true;
        }
        if (!this.securityConfig.hasSameCertificates(cluster.getSecurityConfiguration())) {
            addInfoNotification.accept("Updating cluster TLS");
            updatedCluster.withSecurityConfiguration(cluster.getSecurityConfiguration().cloner().withRootCertificate(null).withIntermediateCertificate(null).withIntermediatePrivateKey(null).withIntermediatePublicKey(null).build());
            updated = true;
        }
        if (updated) {
            return this.onprem(this.clusterDataManager.updateWithInfo(updatedCluster.build(), cluster.getInfoBuilder().withKey(cluster.key()).withEntityId(cluster.getClusterId()).withEntityType(EntityType.CLUSTER).withThreadLocalContext().build(), "SYSTEM_SECURITY", true, false, true, true, false).getCluster());
        }
        return cluster;
    }
}

