/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.caffeine.MetricsStatsCounter;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.configurator.ConfiguratorManager;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.onprem.config.OnPremKubernetesManagerConfig;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.YAML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class KubernetesManifestUtils {
    private static final String MANIFESTS_KEY = "manifests";
    public static final YAML YAML = new YAML();
    private final K8sUtilsProvider k8sUtilsProvider;
    private final ApplicationConfig applicationConfig;
    private final ConfiguratorManager configuratorManager;
    private final OnPremKubernetesManagerConfig onPremKubernetesManagerConfig;
    private Cache<String, List<HasMetadata>> manifestCache;

    @Inject
    public KubernetesManifestUtils(K8sUtilsProvider k8sUtilsProvider, ApplicationConfig applicationConfig, ConfiguratorManager configuratorManager, OnPremKubernetesManagerConfig onPremKubernetesManagerConfig, MetricRegistry metricRegistry) {
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.applicationConfig = applicationConfig;
        this.configuratorManager = configuratorManager;
        this.onPremKubernetesManagerConfig = onPremKubernetesManagerConfig;
        if (onPremKubernetesManagerConfig.isUseK8sManifestCache()) {
            this.manifestCache = Caffeine.newBuilder().recordStats(() -> new MetricsStatsCounter(metricRegistry, "cache.manifests")).maximumSize((long)onPremKubernetesManagerConfig.getMaxK8sManifestCacheSize().intValue()).build();
        }
    }

    public List<HasMetadata> generateManifests(Cluster cluster, Account account) {
        if (!this.onPremKubernetesManagerConfig.isUseK8sManifestCache()) {
            return this.parseManifests(cluster, account);
        }
        return (List)this.manifestCache.get((Object)this.keyFromCluster(cluster), k -> this.parseManifests(cluster, account));
    }

    public void invalidateManifests(Cluster cluster) {
        if (!this.onPremKubernetesManagerConfig.isUseK8sManifestCache()) {
            return;
        }
        this.manifestCache.invalidate((Object)this.keyFromCluster(cluster));
    }

    private String keyFromCluster(Cluster cluster) {
        return String.format("%s/%d", cluster.key(), cluster.getVersion());
    }

    private List<HasMetadata> parseManifests(Cluster cluster, Account account) {
        try {
            InputStream renderedTemplates = this.k8sUtilsProvider.getHelmUtils(cluster).templateHelmChart(HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig), HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig), this.configuratorManager.generateClusterHelmValueOverrides(cluster, account), this.onPremKubernetesManagerConfig.getHelmChartLocation());
            List items = this.k8sUtilsProvider.getKubernetesClient(cluster).load(renderedTemplates).items();
            ImmutableMap helmReleaseAnnotations = ImmutableMap.of((Object)"meta.helm.sh/release-name", (Object)HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig), (Object)"meta.helm.sh/release-namespace", (Object)HelmUtils.generateNamespaceForCluster(cluster, this.applicationConfig));
            ImmutableMap helmReleaseLabels = ImmutableMap.of((Object)"app.kubernetes.io/managed-by", (Object)"Helm");
            items.stream().forEach(arg_0 -> KubernetesManifestUtils.lambda$parseManifests$2((Map)helmReleaseAnnotations, (Map)helmReleaseLabels, arg_0));
            return items;
        }
        catch (IOException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public List<HasMetadata> filterManifestsByType(List<HasMetadata> manifests, ImplyNodeType implyNodeType, ServiceType serviceType) {
        Stream<HasMetadata> filtered = manifests.stream().filter(m -> Optional.ofNullable(m.getMetadata()).map(ObjectMeta::getLabels).map(l -> (String)l.get("imply.io/imply_node_type")).map(val -> val.equals(implyNodeType.camelCasedName())).orElseGet(() -> ImplyNodeType.UNKNOWN.equals((Object)implyNodeType)));
        if (serviceType != null) {
            filtered = filtered.filter(m -> Optional.ofNullable(m.getMetadata()).map(ObjectMeta::getLabels).map(l -> (String)l.get("imply.io/imply_service_type")).map(val -> val.equals(serviceType.getName())).orElseGet(() -> false));
        }
        return filtered.collect(Collectors.toList());
    }

    public String generateDataPlaneReleaseSecretName(Cluster cluster) {
        return String.format("data-plane.v%d", cluster.getVersion());
    }

    public Secret generateDeploymentSecret(List<HasMetadata> manifests, Cluster cluster, Account account) {
        return ((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(this.generateDataPlaneReleaseSecretName(cluster))).withLabels((Map)ImmutableMap.of((Object)"imply.io/version", (Object)cluster.getVersion().toString(), (Object)"imply.io/organizationId", (Object)account.getAccountId(), (Object)"app.kubernetes.io/managed-by", (Object)"imply-manager", (Object)"app.kubernetes.io/name", (Object)"data-plane"))).endMetadata()).addToData(MANIFESTS_KEY, this.compressManifests(manifests))).build();
    }

    public List<HasMetadata> generateRemovedManifests(Secret deploymentSecret, Cluster cluster, Account account, boolean shouldDeleteAll) {
        String b64encoded = Optional.ofNullable(deploymentSecret.getData()).map(d -> (String)d.get(MANIFESTS_KEY)).orElseThrow(() -> new ISE("Deployment secret %s does not contain %s key", new Object[]{deploymentSecret.getMetadata().getName(), MANIFESTS_KEY}));
        List<HasMetadata> oldManifests = this.decompressManifests(b64encoded, cluster);
        if (shouldDeleteAll) {
            return oldManifests;
        }
        List<HasMetadata> newManifests = this.generateManifests(cluster, account);
        return this.dedupeManifests(oldManifests, newManifests);
    }

    @VisibleForTesting
    List<HasMetadata> dedupeManifests(List<HasMetadata> oldManifests, List<HasMetadata> newManifests) {
        return oldManifests.stream().filter(om -> !newManifests.stream().filter(nm -> om.getKind().equals(nm.getKind()) && om.getMetadata().getName().equals(nm.getMetadata().getName())).findAny().isPresent()).collect(Collectors.toList());
    }

    private String compressManifests(List<HasMetadata> manifests) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            gzos.write(YAML.toYamlBytes(manifests));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    private List<HasMetadata> decompressManifests(String b64endoded, Cluster cluster) {
        List list;
        byte[] b64decoded = Base64.getDecoder().decode(b64endoded);
        ByteArrayInputStream bais = new ByteArrayInputStream(b64decoded);
        GZIPInputStream gzis = new GZIPInputStream(bais);
        try {
            list = (List)this.k8sUtilsProvider.getKubernetesClient(cluster).load((InputStream)gzis).get();
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        gzis.close();
        return list;
    }

    private static /* synthetic */ void lambda$parseManifests$2(Map helmReleaseAnnotations, Map helmReleaseLabels, HasMetadata m) {
        Optional<Map> annotations = Optional.ofNullable(m.getMetadata().getAnnotations());
        Optional<Map> labels = Optional.ofNullable(m.getMetadata().getLabels());
        if (annotations.isPresent()) {
            annotations.get().putAll(helmReleaseAnnotations);
        } else {
            m.getMetadata().setAnnotations(helmReleaseAnnotations);
        }
        if (labels.isPresent()) {
            labels.get().putAll(helmReleaseLabels);
        } else {
            m.getMetadata().setLabels(helmReleaseLabels);
        }
    }
}

