/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.config.OnPremKubernetesManagerConfig;
import io.imply.cloud.onprem.util.ExecUtils;
import io.imply.cloud.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class HelmUtils {
    @Generated
    private static final Logger log = Logger.from(HelmUtils.class);
    private final Optional<String> kubeContext;
    private final Optional<String> kubeConfigPath;
    private final OnPremKubernetesManagerConfig onPremKubernetesManagerConfig;

    public HelmUtils(OnPremKubernetesManagerConfig onPremKubernetesManagerConfig) {
        this.kubeContext = Optional.empty();
        this.kubeConfigPath = Optional.empty();
        this.onPremKubernetesManagerConfig = onPremKubernetesManagerConfig;
    }

    public HelmUtils(String kubeContext, String kubeConfigPath, OnPremKubernetesManagerConfig onPremKubernetesManagerConfig) {
        this.kubeContext = Optional.of(kubeContext);
        this.kubeConfigPath = Optional.of(kubeConfigPath);
        this.onPremKubernetesManagerConfig = onPremKubernetesManagerConfig;
    }

    private List<String> baseHelmArgs() {
        ArrayList args = Lists.newArrayList();
        this.kubeContext.ifPresent(ctx -> args.addAll(ImmutableList.of((Object)"--kube-context", (Object)ctx)));
        this.kubeConfigPath.ifPresent(path -> args.addAll(ImmutableList.of((Object)"--kubeconfig", (Object)path)));
        return args;
    }

    public void installHelmChart(String releaseName, String namespace, String overrideValues, String helmChartLocation) throws IOException, TimeoutException {
        ExecUtils.ExecResult execResultCheckReleaseExists = this.checkReleaseExists(releaseName, namespace);
        if (0 == execResultCheckReleaseExists.getExitValue()) {
            throw new RuntimeException(String.format("Failed to install helm chart release [%s] in namespace [%s]. Exit code: %d. Error: %s", releaseName, namespace, execResultCheckReleaseExists.getExitValue(), execResultCheckReleaseExists.getOutput()));
        }
        this.doHelmAction(releaseName, namespace, overrideValues, helmChartLocation, Action.INSTALL);
    }

    public void upgradeHelmChart(String releaseName, String namespace, String overrideValues, String helmChartLocation) throws IOException, TimeoutException {
        ExecUtils.ExecResult execResultCheckReleaseExists = this.checkReleaseExists(releaseName, namespace);
        if (0 != execResultCheckReleaseExists.getExitValue()) {
            throw new RuntimeException(String.format("Failed to upgrade helm chart release [%s] in namespace [%s]. Exit code: %d. Error: %s", releaseName, namespace, execResultCheckReleaseExists.getExitValue(), execResultCheckReleaseExists.getOutput()));
        }
        this.doHelmAction(releaseName, namespace, overrideValues, helmChartLocation, Action.UPGRADE);
    }

    public void installOrUpgradeHelmChart(String releaseName, String namespace, String overrideValues, String helmChartLocation) throws IOException, TimeoutException {
        this.doHelmAction(releaseName, namespace, overrideValues, helmChartLocation, Action.INSTALL_OR_UPGRADE);
    }

    public InputStream templateHelmChart(String releaseName, String namespace, String overrideValues, String helmChartLocation) throws IOException, TimeoutException {
        String operation = "template";
        List<String> helmArgs = this.baseHelmArgs();
        helmArgs.addAll(Lists.newArrayList((Object[])new String[]{operation, "--release-name", releaseName, helmChartLocation, "-n", namespace, "--validate"}));
        if (overrideValues != null) {
            File tempFile = File.createTempFile(releaseName + "-" + namespace, ".yaml");
            FileUtils.write((File)tempFile, (CharSequence)overrideValues, (Charset)StandardCharsets.UTF_8);
            helmArgs.add("--values");
            helmArgs.add(tempFile.getAbsolutePath());
        }
        File renderedFile = File.createTempFile("rendered-" + releaseName + "-" + namespace, ".yaml");
        ExecUtils.ExecResult execResult = ExecUtils.execute("helm", this.onPremKubernetesManagerConfig.getHelmTimeout(), renderedFile, helmArgs);
        if (execResult.getExitValue() != 0) {
            throw new RuntimeException(String.format("%s of helm chart release [%s] in namespace [%s] failed. Exit code: %d. Error: %s", StringUtils.capitalize((String)operation), releaseName, namespace, execResult.getExitValue(), execResult.getOutput()));
        }
        return new FileInputStream(renderedFile);
    }

    private void doHelmAction(String releaseName, String namespace, String overrideValues, String helmChartLocation, Action action) throws IOException, TimeoutException {
        ExecUtils.ExecResult execResult;
        ImmutableList.Builder helmArgs = ImmutableList.builder().addAll(this.baseHelmArgs()).addAll(action.getArgs()).add((Object[])new String[]{releaseName, helmChartLocation, "-n", namespace});
        if (overrideValues != null) {
            File tempFile = File.createTempFile(releaseName + "-" + namespace, ".yaml");
            FileUtils.write((File)tempFile, (CharSequence)overrideValues, (Charset)StandardCharsets.UTF_8);
            helmArgs.add((Object)"-f");
            helmArgs.add((Object)tempFile.getAbsolutePath());
        }
        if ((execResult = ExecUtils.execute("helm", this.onPremKubernetesManagerConfig.getHelmTimeout(), (List<String>)helmArgs.build())).getExitValue() != 0) {
            throw new RuntimeException(String.format("%s of helm chart release [%s] in namespace [%s] failed. Exit code: %d. Error: %s", action.getPrettyName(), releaseName, namespace, execResult.getExitValue(), execResult.getOutput()));
        }
        log.info("%s of helm chart release [%s] in namespace [%s] successful", new Object[]{action.getPrettyName(), releaseName, namespace});
    }

    public void deleteHelmChart(String releaseName, String namespace) throws IOException, TimeoutException {
        ExecUtils.ExecResult execResultCheckClusterExists = this.checkReleaseExists(releaseName, namespace);
        if (0 != execResultCheckClusterExists.getExitValue()) {
            log.debug("Attempted to delete a non-existent helm release [%s] in namespace [%s]", new Object[]{releaseName, namespace});
            return;
        }
        List<String> helmArgs = this.baseHelmArgs();
        helmArgs.addAll(Lists.newArrayList((Object[])new String[]{"uninstall", releaseName, "-n", namespace}));
        ExecUtils.ExecResult execResult = ExecUtils.execute("helm", this.onPremKubernetesManagerConfig.getHelmTimeout(), helmArgs);
        if (execResult.getExitValue() != 0) {
            throw new RuntimeException(String.format("Failed to delete helm chart release [%s] in namespace [%s]. Exit code: %d. Error: %s", releaseName, namespace, execResult.getExitValue(), execResult.getOutput()));
        }
        log.info("Successfully deleted helm chart release [%s] in namespace [%s]", new Object[]{releaseName, namespace});
    }

    public ExecUtils.ExecResult checkReleaseExists(String releaseName, String namespace) throws IOException, TimeoutException {
        List<String> helmArgs = this.baseHelmArgs();
        helmArgs.addAll(Lists.newArrayList((Object[])new String[]{"status", "-n", namespace, releaseName}));
        return ExecUtils.execute("helm", this.onPremKubernetesManagerConfig.getHelmTimeout(), helmArgs);
    }

    public static String generateNamespaceForCluster(Cluster cluster, ApplicationConfig applicationConfig) {
        if (applicationConfig.isSaaS() || applicationConfig.isIOW()) {
            return String.format("cluster-%s", cluster.getClusterId());
        }
        return "default";
    }

    public static String generateReleaseNameForCluster(Cluster cluster, ApplicationConfig applicationConfig) {
        if (applicationConfig.isSaaS() || applicationConfig.isIOW()) {
            return "data-plane";
        }
        return "c-" + cluster.getClusterId().substring(0, Math.min(cluster.getClusterId().length(), 13));
    }

    public static String generateNamespaceForAccount(String accountId) {
        return "account-" + accountId;
    }

    public static String generateReleaseNameForGrove() {
        return "grove";
    }

    private static enum Action {
        INSTALL((List<String>)ImmutableList.of((Object)"install")),
        UPGRADE((List<String>)ImmutableList.of((Object)"upgrade")),
        INSTALL_OR_UPGRADE((List<String>)ImmutableList.of((Object)"upgrade", (Object)"--install"));

        private final List<String> args;

        private Action(List<String> args) {
            this.args = args;
        }

        public String getPrettyName() {
            return WordUtils.capitalizeFully((String)StringUtils.replace((String)this.name(), (String)"_", (String)" "));
        }

        @Generated
        public List<String> getArgs() {
            return this.args;
        }
    }
}

