/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage.creation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.zookeeper.ExternalZooKeeper;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.util.ISE;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremCheckZooKeeperStage
extends BaseStage
implements OnPremHelpers {
    private static final int SESSION_TIMEOUT_MS = 30000;
    private static final int CONNECTION_TIMEOUT_MS = 10000;
    private static final int BASE_SLEEP_TIME_MS = 1000;
    private static final int MAX_SLEEP_TIME_MS = 30000;
    private static final int MAX_RETRIES = 3;

    @JsonCreator
    public OnPremCheckZooKeeperStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId) {
        super(toolbox, clusterId);
    }

    public boolean innerRun() throws InterruptedException {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        if (!(cluster.getZooKeeper() instanceof ExternalZooKeeper)) {
            throw new ISE("Expected cluster [%s] to be using an [ExternalZooKeeper] implementation, was [%s]", new Object[]{cluster.getClusterId(), cluster.getZooKeeper() != null ? cluster.getZooKeeper().getClass().getName() : "null"});
        }
        String connectString = ((ExternalZooKeeper)cluster.getZooKeeper()).getHosts();
        if (connectString == null || connectString.isEmpty()) {
            throw new ISE("Cluster [%s] has empty [zooKeeper.hosts]", new Object[]{cluster.getClusterId()});
        }
        try (CuratorFramework framework = CuratorFrameworkFactory.newClient((String)connectString, (int)30000, (int)10000, (RetryPolicy)new BoundedExponentialBackoffRetry(1000, 30000, 3));){
            framework.start();
            boolean bl = framework.blockUntilConnected(5, TimeUnit.SECONDS);
            return bl;
        }
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 3;
    }

    public Integer getMaxConsecutiveExceptions() {
        return 3;
    }

    @JsonProperty
    public String getDescription() {
        return "Checking that ZooKeeper is reachable";
    }
}

