/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.util.Logger;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremKubernetesAwaitPodTerminationStage
extends BaseStage
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesAwaitPodTerminationStage.class);
    private final String podId;
    private final K8sUtilsProvider k8sUtilsProvider;

    @JsonCreator
    public OnPremKubernetesAwaitPodTerminationStage(@JacksonInject ManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="podId") String podId) {
        super(toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.podId = podId;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        ApplicationConfig applicationConfig = this.toolbox.getApplicationConfig();
        String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, applicationConfig);
        try {
            return !this.k8sUtilsProvider.getKubernetesUtils(cluster).isPodTerminatingInNamespace(clusterNamespace, this.podId);
        }
        catch (KubernetesClientException e) {
            log.warn((Throwable)e, "Unable to evict pod [%s] in cluster [%s], operation will be retried", new Object[]{this.podId, this.getClusterId()});
            return false;
        }
    }

    @JsonProperty
    public String getPodId() {
        return this.podId;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Awaiting termination for pod %s", this.podId);
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 600;
    }
}

