/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodList;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class OnPremKubernetesAwaitPeonVersionStage
extends BaseStage
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesAwaitPeonVersionStage.class);
    private final K8sUtilsProvider k8sUtilsProvider;
    private final String workerVersion;

    @JsonCreator
    public OnPremKubernetesAwaitPeonVersionStage(@JacksonInject ManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="workerVersion") String workerVersion) {
        super(toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.workerVersion = workerVersion;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        ApplicationConfig applicationConfig = this.toolbox.getApplicationConfig();
        String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, applicationConfig);
        PodList peonPods = this.k8sUtilsProvider.getKubernetesUtils(cluster).getRunningDruidJobPods(clusterNamespace, this.workerVersion);
        List pods = peonPods.getItems().stream().filter(p -> !this.workerVersion.equals(p.getMetadata().getLabels().get("imply.io/worker_version"))).map(p -> p.getMetadata().getName()).collect(Collectors.toList());
        log.info("Peons not running latest worker version %s", new Object[]{pods});
        return pods.isEmpty();
    }

    @JsonProperty
    public String getWorkerVersion() {
        return this.workerVersion;
    }

    @JsonProperty
    public String getDescription() {
        return "Waiting for tasks to complete";
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 300;
    }
}

