/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.Toolbox;
import io.imply.cloud.grove.GroveAgentUtil;
import io.imply.cloud.onprem.stage.creation.OnPremFetchConfigBundleStage;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.Logger;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremFetchPeonBundleStage
extends OnPremFetchConfigBundleStage {
    @Generated
    private static final Logger log = Logger.from(OnPremFetchPeonBundleStage.class);

    @JsonCreator
    public OnPremFetchPeonBundleStage(@JacksonInject OnPremManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="groveServer") String groveServer, @JsonProperty(value="hosts") List<String> hosts) {
        super(toolbox, clusterId, groveServer, hosts);
    }

    @Override
    public boolean innerRun() {
        List onlineHosts = this.toolbox.getClusterNodesHelper().filterOnlineHosts(this.getClusterId(), this.getHosts());
        if (onlineHosts.isEmpty()) {
            log.info("No hosts from [%s] are online, skipping stage", new Object[]{String.join((CharSequence)",", this.getHosts())});
            return true;
        }
        String contents = GroveAgentUtil.getCurlRunStringForConfigFile((String)"/opt/imply/conf/peon.zip", (String)this.getUsernameAndPasswordOrPlaceholder(), (String)String.format("%s%s/%s", this.getManagerHostAndPortOrPlaceholder(), "/config/v1", "peon-configs"), (Toolbox)this.toolbox) + " && (cd /opt/imply/conf && unzip -o peon.zip && rm peon.zip)";
        this.toolbox.getGroveClient().simpleRun(this.getGroveServer(), onlineHosts, contents, 30, true);
        this.chownConfigs(onlineHosts);
        return true;
    }

    @Override
    @JsonProperty
    public String getDescription() {
        return String.format("Fetching peon bundle from config server for hosts %s", this.getHosts());
    }
}

