/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremAwaitPodsReadyStage
extends BaseStage {
    private final K8sUtilsProvider k8sUtilsProvider;
    private final ImplyNodeType implyNodeType;
    private final Integer desiredReplicaCount;
    private static final String RUNNING_PHASE = "Running";

    @JsonCreator
    public OnPremAwaitPodsReadyStage(@JacksonInject OnPremManagerToolbox toolbox, @JacksonInject K8sUtilsProvider k8sUtilsProvider, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="implyNodeType") ImplyNodeType implyNodeType, @JsonProperty(value="desiredReplicaCount") Integer desiredReplicaCount) {
        super((ManagerToolbox)toolbox, clusterId);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.implyNodeType = implyNodeType;
        this.desiredReplicaCount = desiredReplicaCount;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.getClusterId());
        String namespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        String releaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.toolbox.getApplicationConfig());
        KubernetesClient client = this.k8sUtilsProvider.getKubernetesClient(cluster);
        return ((PodList)((FilterWatchListDeletable)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withLabel("imply.io/imply_node_type", this.implyNodeType.camelCasedName())).withLabel("app.kubernetes.io/instance", releaseName)).list()).getItems().stream().filter(p -> RUNNING_PHASE.equalsIgnoreCase(p.getStatus().getPhase())).filter(p -> p.getStatus().getContainerStatuses().stream().allMatch(ContainerStatus::getReady)).count() == (long)this.desiredReplicaCount.intValue();
    }

    @JsonProperty
    public ImplyNodeType getImplyNodeType() {
        return this.implyNodeType;
    }

    @JsonProperty
    public Integer getDesiredReplicaCount() {
        return this.desiredReplicaCount;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for [%d] [%s] pods to be ready", this.desiredReplicaCount, this.implyNodeType.camelCasedName());
    }
}

