/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.grove.Node;
import io.imply.cloud.grove.ServiceEntry;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.AwaitMasterInstancesAvailableStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.util.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremAwaitMasterInstancesAvailableStage
extends AwaitMasterInstancesAvailableStage
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremAwaitMasterInstancesAvailableStage.class);
    private final Integer numInstances;

    @JsonCreator
    public OnPremAwaitMasterInstancesAvailableStage(@JacksonInject ManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="numInstances") Integer numInstances) {
        super(toolbox, clusterId, ImplyNodeType.MASTER);
        this.numInstances = numInstances;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().getOrNull(this.getClusterId());
        Account account = this.toolbox.getAccountDataManager().get(cluster != null ? cluster.getAccountId() : "onprem");
        List groveNodes = this.toolbox.getGroveClient().getGroveNodes(account.getGroveServer(), true);
        List hosts = groveNodes.stream().filter(Node::isImplyRunning).filter(x -> cluster.getClusterId().equals(x.getActiveClusterId())).filter(x -> x.getImplyNodeTypes().stream().anyMatch(arg_0 -> ((ImplyNodeType)ImplyNodeType.MASTER).equals(arg_0))).map(Node::getAddress).collect(Collectors.toList());
        int coordinatorOKCount = 0;
        int overlordOKCount = 0;
        HashSet<String> unresponsiveNodes = new HashSet<String>();
        for (String host : hosts) {
            if (this.toolbox.getDruidApiClient().isCoordinatorStatusOK(host, this.getClusterId())) {
                ++coordinatorOKCount;
            } else {
                unresponsiveNodes.add(host);
            }
            if (this.toolbox.getDruidApiClient().isOverlordStatusOK(host, this.getClusterId())) {
                ++overlordOKCount;
                continue;
            }
            unresponsiveNodes.add(host);
        }
        log.info("Waiting for at least [%d] master nodes available; found [%d] coordinator / [%d] overlord nodes (awaiting: %s)", new Object[]{this.numInstances, coordinatorOKCount, overlordOKCount, unresponsiveNodes});
        this.possiblyReloadNodes(cluster, groveNodes, unresponsiveNodes);
        return coordinatorOKCount >= this.numInstances && overlordOKCount >= this.numInstances;
    }

    private void possiblyReloadNodes(Cluster cluster, List<Node> groveNodes, Set<String> unresponsiveNodes) {
        int timeoutInSeconds = this.getCompletionTimeoutInMinutes() * 60 / 2;
        if (this.getState().getStageStartTime().plusSeconds(timeoutInSeconds).isAfterNow()) {
            return;
        }
        groveNodes.stream().filter(node -> unresponsiveNodes.contains(node.getAddress())).filter(node -> {
            Optional<ServiceEntry> entry = node.getServices().stream().filter(service -> "imply".equals(service.getName())).findFirst();
            if (entry.isPresent()) {
                return entry.get().getTimeInSeconds() > timeoutInSeconds;
            }
            return false;
        }).map(Node::getAddress).forEach(addr -> this.toolbox.getNodeHelper().restartNode(cluster, addr));
    }

    @JsonProperty
    public Integer getNumInstances() {
        return this.numInstances;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return 30;
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for [%d] master node%s to be available", this.numInstances, this.numInstances == 1 ? "" : "s");
    }
}

