/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.stage;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.AwaitDataInstancesAvailableStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremAwaitDataInstancesAvailableStage
extends AwaitDataInstancesAvailableStage
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremAwaitDataInstancesAvailableStage.class);
    private final Integer numInstances;
    private final OnPremManagerToolbox onPremManagerToolbox;

    @JsonCreator
    public OnPremAwaitDataInstancesAvailableStage(@JacksonInject OnPremManagerToolbox toolbox, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="numInstances") Integer numInstances) {
        super((ManagerToolbox)toolbox, clusterId, ImplyNodeType.DATA);
        this.onPremManagerToolbox = toolbox;
        this.numInstances = numInstances;
    }

    public boolean innerRun() {
        Cluster cluster = this.toolbox.getClusterDataManager().getOrNull(this.getClusterId());
        Account account = this.toolbox.getAccountDataManager().get(cluster != null ? cluster.getAccountId() : "onprem");
        List<Node> groveNodes = this.toolbox.getGroveClient().getGroveNodes(account.getGroveServer(), true).stream().filter(Node::isImplyRunning).filter(x -> cluster.getClusterId().equals(x.getActiveClusterId())).filter(x -> x.getImplyNodeTypes().stream().anyMatch(ImplyNodeType::isDataType)).collect(Collectors.toList());
        if (this.toolbox.getApplicationConfig().isSaaS() || this.toolbox.getApplicationConfig().isIOW()) {
            return this.isDataReadyWithoutMM(groveNodes);
        }
        return this.isDataReadyWithMM(groveNodes);
    }

    private boolean isDataReadyWithoutMM(List<Node> groveNodes) {
        int historicalOKCount = 0;
        HashSet<String> unresponsiveNodes = new HashSet<String>();
        for (Node node : groveNodes) {
            if (this.toolbox.getDruidApiClient().isHistoricalStatusOK(node.getAddress(), this.getClusterId())) {
                ++historicalOKCount;
                continue;
            }
            unresponsiveNodes.add(node.getAddress());
        }
        log.info("Waiting for at least [%d] data nodes available; found [%d] historical (awaiting: %s)", new Object[]{this.numInstances, historicalOKCount, unresponsiveNodes});
        return historicalOKCount >= this.numInstances;
    }

    private boolean isDataReadyWithMM(List<Node> groveNodes) {
        int historicalOKCount = 0;
        int middleManagerOKCount = 0;
        HashSet<String> unresponsiveNodes = new HashSet<String>();
        for (Node node : groveNodes) {
            if (this.toolbox.getDruidApiClient().isHistoricalStatusOK(node.getAddress(), this.getClusterId())) {
                ++historicalOKCount;
            } else {
                unresponsiveNodes.add(node.getAddress());
            }
            if (this.toolbox.getDruidApiClient().isMiddleManagerStatusOK(node.getAddress(), this.getClusterId())) {
                ++middleManagerOKCount;
                continue;
            }
            unresponsiveNodes.add(node.getAddress());
        }
        log.info("Waiting for at least [%d] data nodes available; found [%d] historical / [%d] middleManager nodes (awaiting: %s)", new Object[]{this.numInstances, historicalOKCount, middleManagerOKCount, unresponsiveNodes});
        return historicalOKCount >= this.numInstances && middleManagerOKCount >= this.numInstances;
    }

    @JsonProperty
    public Integer getNumInstances() {
        return this.numInstances;
    }

    public Integer getCompletionTimeoutInMinutes() {
        return this.onPremManagerToolbox.getOnPremManagerConfig().getDataInstanceAvailableTimeout().getMinutes();
    }

    @JsonProperty
    public String getDescription() {
        return String.format("Waiting for [%d] data node%s to be available", this.numInstances, this.numInstances == 1 ? "" : "s");
    }
}

