/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.ReloadNodeNotice;
import io.imply.cloud.manager.stage.BaseStage;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.Status;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.stage.creation.OnPremBecomeServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremFetchConfigBundleStage;
import io.imply.cloud.onprem.stage.creation.OnPremWriteConfigServerRequestPayloadStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OnPremReloadNodeNotice
extends ReloadNodeNotice
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremReloadNodeNotice.class);
    private static final Map<String, Integer> FAILURE_COOLDOWN_MAP = new HashMap<String, Integer>();
    private static final int FAILURE_COOLDOWN_CYCLES = 5;
    public static final String NODE_ADDRESS_KEY = "nodeAddress";
    public static final String USE_FAILURE_COOLDOWN_KEY = "useFailureCooldown";
    private final OnPremManagerToolbox onPremManagerToolbox;

    @Inject
    public OnPremReloadNodeNotice(OnPremManagerToolbox toolbox) {
        super((ManagerToolbox)toolbox);
        this.onPremManagerToolbox = toolbox;
    }

    public void innerHandle() {
        String host = (String)this.getCustomData(NODE_ADDRESS_KEY, String.class);
        Boolean useFailureCooldown = (Boolean)this.getCustomData(USE_FAILURE_COOLDOWN_KEY, Boolean.class);
        if (host == null) {
            throw new ISE("Could not fetch nodeAddress from customData", new Object[0]);
        }
        if (useFailureCooldown != null && useFailureCooldown.booleanValue() && FAILURE_COOLDOWN_MAP.get(host) != null && FAILURE_COOLDOWN_MAP.get(host) > 0) {
            log.info("Skipping processing of node [%s] which is in failure cooldown: %d", new Object[]{host, FAILURE_COOLDOWN_MAP.get(host)});
            FAILURE_COOLDOWN_MAP.compute(host, (k, v) -> v - 1);
            return;
        }
        OnPremCluster cluster = this.onprem(this.toolbox.getClusterDataManager().get(this.info.getEntityId()));
        String groveServer = this.onprem(this.toolbox.getAccountDataManager().get(cluster.getAccountId())).getGroveServer();
        ClusterNodes clusterNodes = this.toolbox.getClusterNodesDataManager().get(cluster.getClusterId());
        if (clusterNodes.getNodes() == null || clusterNodes.getNodes().get(host) == null) {
            log.error("Node [%s] was not part of expected cluster [%s]", new Object[]{host, cluster.getClusterId()});
            return;
        }
        Set nodeTypes = ((NodeConfiguration)clusterNodes.getNodes().get(host)).getNodeTypes();
        if (nodeTypes == null || nodeTypes.isEmpty()) {
            log.error("Node [%s] is not assigned an Imply node type", new Object[]{host});
            return;
        }
        ArrayList<BaseStage> reloadPlan = new ArrayList<BaseStage>();
        if (!this.toolbox.getApplicationConfig().isKubernetesMode()) {
            reloadPlan.add(new OnPremWriteConfigServerRequestPayloadStage(this.toolbox, cluster.getClusterId(), nodeTypes, groveServer, host, cluster.getConfigServerKey()));
        }
        reloadPlan.add(new OnPremFetchConfigBundleStage(this.onPremManagerToolbox, cluster.getClusterId(), groveServer, Collections.singletonList(host)));
        reloadPlan.add(new OnPremBecomeServicesStage(this.onPremManagerToolbox, cluster.getClusterId(), groveServer, Collections.singletonList(host)));
        if (!this.executeStagesImmediately(reloadPlan)) {
            FAILURE_COOLDOWN_MAP.put(host, 5);
        }
    }

    protected Status getFailureStatus() {
        return Status.WARNING;
    }
}

