/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.grove.Node;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.PlanRollingUpdateNotice;
import io.imply.cloud.manager.stage.AwaitMiddleManagerIdleStage;
import io.imply.cloud.manager.stage.AwaitMiddleManagerTaskStatusStage;
import io.imply.cloud.manager.stage.AwaitSegmentsAvailableStage;
import io.imply.cloud.manager.stage.DisableMiddleManagerStage;
import io.imply.cloud.manager.stage.EnableMiddleManagerStage;
import io.imply.cloud.manager.stage.ModifyCoordinatorDynamicConfigurationStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.DataTierInfo;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.PlanUpdateState;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.User;
import io.imply.cloud.onprem.stage.OnPremAwaitDataInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitMasterInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitQueryInstancesAvailableStage;
import io.imply.cloud.onprem.stage.creation.OnPremBecomeServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremCheckZooKeeperStage;
import io.imply.cloud.onprem.stage.creation.OnPremFetchConfigBundleStage;
import io.imply.cloud.onprem.stage.creation.OnPremMaybeCreateMetadataDatabaseStage;
import io.imply.cloud.onprem.stage.creation.OnPremStopServicesStage;
import io.imply.cloud.onprem.stage.creation.OnPremWriteConfigServerRequestPayloadStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.DiffResultHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.DiffResult;

public class OnPremPlanRollingUpdateNotice
extends PlanRollingUpdateNotice
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremPlanRollingUpdateNotice.class);
    private final OnPremManagerToolbox onPremManagerToolbox;
    private Set<String> previouslyModifiedHosts = new HashSet<String>();
    private Map<String, NodeConfiguration> startingNodes = new HashMap<String, NodeConfiguration>();
    private List<String> onlineNodes;

    @Inject
    public OnPremPlanRollingUpdateNotice(OnPremManagerToolbox toolbox) {
        super((ManagerToolbox)toolbox);
        this.onPremManagerToolbox = toolbox;
    }

    protected boolean populateInitialClusterState(PlanUpdateState planState) {
        planState.setHosts(null);
        this.onlineNodes = this.toolbox.getGroveClient().getGroveNodes(planState.getAccount().getGroveServer(), true).stream().map(Node::getAddress).collect(Collectors.toList());
        Map endingClusterNodes = planState.getFilteredEndingClusterNodes();
        Map startingClusterNodes = planState.getFilteredStartingClusterNodes();
        List endingHosts = ClusterNodesHelper.getSortedHosts((Map)endingClusterNodes);
        ArrayList offlineHosts = new ArrayList(endingHosts);
        offlineHosts.removeAll(this.onlineNodes);
        if (!offlineHosts.isEmpty()) {
            this.addInfoNotification("Waiting to update - the following nodes are offline: %s", new Object[]{offlineHosts});
            return false;
        }
        this.addInfoNotification("All nodes in proposed cluster are online", new Object[0]);
        HashSet allMasterHosts = new HashSet(ClusterNodesHelper.getSortedMasterHosts((Map)endingClusterNodes));
        allMasterHosts.addAll(ClusterNodesHelper.getSortedMasterHosts((Map)startingClusterNodes));
        planState.setMasterHostAddresses(allMasterHosts);
        if (planState.isPerformingRollback() && this.info.getUpdateState() != null) {
            for (Stage stage : this.info.getUpdateState().getCompletedRollingStages()) {
                if (stage instanceof OnPremWriteConfigServerRequestPayloadStage) {
                    this.previouslyModifiedHosts.add(((OnPremWriteConfigServerRequestPayloadStage)stage).getHost());
                }
                if (!(stage instanceof OnPremStopServicesStage)) continue;
                this.previouslyModifiedHosts.addAll(((OnPremStopServicesStage)stage).getHosts());
            }
            for (Map.Entry entry : endingClusterNodes.entrySet()) {
                if (!this.isHealthy((String)entry.getKey(), (NodeConfiguration)entry.getValue(), planState.getClusterId())) continue;
                this.startingNodes.put((String)entry.getKey(), (NodeConfiguration)entry.getValue());
            }
            for (Map.Entry entry : startingClusterNodes.entrySet()) {
                if (!this.isHealthy((String)entry.getKey(), (NodeConfiguration)entry.getValue(), planState.getClusterId())) continue;
                this.startingNodes.put((String)entry.getKey(), (NodeConfiguration)entry.getValue());
            }
        } else {
            this.startingNodes.putAll(startingClusterNodes);
        }
        return true;
    }

    protected void determineAffectedNodeTypes(PlanUpdateState planState) {
        super.determineAffectedNodeTypes(planState);
        if (DiffResultHelper.contains((DiffResult)planState.getClusterDiffs(), (String)"metadataStorage")) {
            planState.setFullMasterReplacement(true);
            planState.setFullQueryReplacement(true);
        }
    }

    protected void addPreUpdateStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
        if (!this.onPremManagerToolbox.getOnPremManagerConfig().isSkipClusterMetadataStoreCheck()) {
            updatePlan.add((Stage)new OnPremMaybeCreateMetadataDatabaseStage(this.toolbox, planState.getClusterId()));
        }
        if (!this.onPremManagerToolbox.getOnPremManagerConfig().isSkipClusterZkCheck()) {
            updatePlan.add((Stage)new OnPremCheckZooKeeperStage(this.toolbox, planState.getClusterId()));
        }
        if (planState.getDiffClusterNodes().isEmpty()) {
            super.addPreUpdateStages(planState, updatePlan);
            return;
        }
        List<String> addedNodes = planState.getFilteredEndingClusterNodes().keySet().stream().filter(x -> !this.startingNodes.containsKey(x) || this.startingNodes.get(x).getNodeTypes().isEmpty()).collect(Collectors.toList());
        List<String> removedNodes = this.startingNodes.keySet().stream().filter(x -> !planState.getFilteredEndingClusterNodes().containsKey(x)).collect(Collectors.toList());
        List<String> modifiedNodes = this.startingNodes.entrySet().stream().filter(x -> planState.getFilteredEndingClusterNodes().containsKey(x.getKey())).filter(x -> !((NodeConfiguration)x.getValue()).getNodeTypes().isEmpty() && !((NodeConfiguration)planState.getFilteredEndingClusterNodes().get(x.getKey())).getNodeTypes().equals(((NodeConfiguration)x.getValue()).getNodeTypes())).map(Map.Entry::getKey).collect(Collectors.toList());
        ArrayList<String> unchangedNodes = new ArrayList<String>(this.startingNodes.keySet());
        unchangedNodes.removeAll(addedNodes);
        unchangedNodes.removeAll(removedNodes);
        unchangedNodes.removeAll(modifiedNodes);
        if (planState.isPerformingRollback()) {
            List<String> removed = this.previouslyModifiedHosts.stream().filter(h -> !this.startingNodes.containsKey(h)).filter(h -> !planState.getFilteredEndingClusterNodes().containsKey(h)).collect(Collectors.toList());
            if (!removed.isEmpty()) {
                this.addStopServiceStages(removed, planState, updatePlan);
            }
            this.reenableMiddleManagers(this.getDataNodesFilteredByHost(this.startingNodes, unchangedNodes), planState, updatePlan);
        }
        if (!this.isRollingUpdate()) {
            this.addBecomeServiceStages((List<String>)ImmutableList.builder().addAll(addedNodes).addAll(modifiedNodes).build(), planState, updatePlan);
            this.addStopServiceStages(removedNodes, planState, updatePlan);
            super.addPreUpdateStages(planState, updatePlan);
            return;
        }
        HashMap<String, NodeConfiguration> currentView = new HashMap<String, NodeConfiguration>(this.startingNodes);
        List<String> removedDataNodes = this.getDataNodesFilteredByHost(this.startingNodes, removedNodes);
        if (!addedNodes.isEmpty()) {
            this.addBecomeServiceStages((List<String>)ImmutableList.copyOf(addedNodes), planState, updatePlan);
            addedNodes.forEach(node -> currentView.put((String)node, (NodeConfiguration)planState.getFilteredEndingClusterNodes().get(node)));
            this.addAwaitInstancesAvailableStage(planState, updatePlan, currentView);
        }
        unchangedNodes.stream().filter(this.previouslyModifiedHosts::contains).forEach(node -> {
            this.addBecomeServiceStages((List<String>)ImmutableList.of((Object)node), planState, updatePlan);
            currentView.put((String)node, (NodeConfiguration)planState.getFilteredEndingClusterNodes().get(node));
            this.addAwaitInstancesAvailableStage(planState, updatePlan, currentView);
        });
        this.maybeUpdateCoordinatorDynamicConfiguration(planState, updatePlan, modifiedNodes, removedNodes);
        this.recursivelyUpdateNodes(planState, updatePlan, modifiedNodes, currentView);
        ArrayList<String> onlineRemovedDataNodes = new ArrayList<String>(removedDataNodes);
        onlineRemovedDataNodes.retainAll(this.onlineNodes);
        this.addRollingStopDataNodesStages(onlineRemovedDataNodes, planState, updatePlan);
        removedNodes.removeAll(onlineRemovedDataNodes);
        this.addStopServiceStages(removedNodes, planState, updatePlan);
        super.addPreUpdateStages(planState, updatePlan);
    }

    private void recursivelyUpdateNodes(PlanUpdateState planState, Deque<Stage> updatePlan, List<String> hosts, Map<String, NodeConfiguration> currentView) {
        if (hosts.isEmpty()) {
            return;
        }
        ArrayList<String> hostsLeft = new ArrayList<String>(hosts);
        ArrayList<String> toModify = new ArrayList<String>();
        HashMap<String, NodeConfiguration> snapshot = new HashMap<String, NodeConfiguration>(currentView);
        HashMap<String, NodeConfiguration> updatedView = new HashMap<String, NodeConfiguration>(currentView);
        for (String host : hosts) {
            NodeConfiguration originalConfig = this.startingNodes.get(host);
            NodeConfiguration updatedConfig = (NodeConfiguration)planState.getFilteredEndingClusterNodes().get(host);
            if (ClusterNodesHelper.getSortedHosts(currentView, (Collection)originalConfig.getNodeTypes()).size() <= 1) continue;
            toModify.add(host);
            currentView.remove(host);
            updatedView.put(host, updatedConfig);
            hostsLeft.remove(host);
        }
        if (toModify.isEmpty()) {
            throw new ISE("Rolling update could not be planned, aborting", new Object[0]);
        }
        this.addRollingBecomeServiceStages(toModify, planState, updatePlan, this.startingNodes, snapshot);
        this.recursivelyUpdateNodes(planState, updatePlan, hostsLeft, updatedView);
    }

    private List<String> getNodesFilteredByHostAndType(Map<String, NodeConfiguration> nodes, Collection<String> hosts, Predicate<ImplyNodeType> p) {
        if (hosts == null) {
            return new ArrayList<String>();
        }
        return hosts.stream().filter(nodes::containsKey).filter(x -> ((NodeConfiguration)nodes.get(x)).getNodeTypes().stream().anyMatch(p)).collect(Collectors.toList());
    }

    private List<String> getDataNodesFilteredByHost(Map<String, NodeConfiguration> nodes, Collection<String> hosts) {
        return this.getNodesFilteredByHostAndType(nodes, hosts, ImplyNodeType::isDataType);
    }

    private void maybeUpdateCoordinatorDynamicConfiguration(PlanUpdateState planState, Deque<Stage> updatePlan, Collection<String> modifiedNodes, List<String> removedNodes) {
        if (this.getDataNodesFilteredByHost(this.startingNodes, modifiedNodes).isEmpty() && this.getDataNodesFilteredByHost(planState.getFilteredEndingClusterNodes(), modifiedNodes).isEmpty() && this.getDataNodesFilteredByHost(this.startingNodes, removedNodes).isEmpty()) {
            return;
        }
        String config = this.toolbox.getClusterUpdateHelper().generateModifiedCoordinatorDynamicConfiguration(planState.getCoordinatorDynamicConfiguration(), 200, 2000);
        if (config != null) {
            User principal = ThreadLocalContext.getPrincipal();
            updatePlan.add((Stage)new ModifyCoordinatorDynamicConfigurationStage(this.toolbox, planState.getClusterId(), null, planState.getMasterHostAddresses(), config, Boolean.valueOf(false), DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), String.format("Temporarily setting [maxSegmentsToMove=%d] and [replicationThrottleLimit=%d] for rolling update", 200, 2000)));
            planState.setCoordinatorDynamicConfigurationModified(true);
        }
    }

    private void addRollingBecomeServiceStages(List<String> hosts, PlanUpdateState planState, Deque<Stage> updatePlan, Map<String, NodeConfiguration> startingNodes, Map<String, NodeConfiguration> currentView) {
        List<String> wasData = this.getDataNodesFilteredByHost(startingNodes, hosts);
        List<String> wasQuery = this.getNodesFilteredByHostAndType(startingNodes, hosts, arg_0 -> ((ImplyNodeType)ImplyNodeType.QUERY).equals(arg_0));
        List<String> wasMaster = this.getNodesFilteredByHostAndType(startingNodes, hosts, arg_0 -> ((ImplyNodeType)ImplyNodeType.MASTER).equals(arg_0));
        List<String> toData = this.getDataNodesFilteredByHost(planState.getFilteredEndingClusterNodes(), hosts);
        List<String> toQuery = this.getNodesFilteredByHostAndType(planState.getFilteredEndingClusterNodes(), hosts, arg_0 -> ((ImplyNodeType)ImplyNodeType.QUERY).equals(arg_0));
        List<String> toMaster = this.getNodesFilteredByHostAndType(planState.getFilteredEndingClusterNodes(), hosts, arg_0 -> ((ImplyNodeType)ImplyNodeType.MASTER).equals(arg_0));
        hosts.forEach(host -> {
            AtomicInteger dataCount = new AtomicInteger(ClusterNodesHelper.getSortedDataHosts((Map)currentView).size());
            AtomicInteger queryCount = new AtomicInteger(ClusterNodesHelper.getSortedQueryHosts((Map)currentView).size());
            AtomicInteger masterCount = new AtomicInteger(ClusterNodesHelper.getSortedMasterHosts((Map)currentView).size());
            if (wasData.contains(host)) {
                this.addDisableAndDrain(Collections.singletonList(host), planState, updatePlan);
            }
            this.addBecomeServiceStages(Collections.singletonList(host), planState, updatePlan);
            if (toData.contains(host)) {
                updatePlan.add((Stage)new OnPremAwaitDataInstancesAvailableStage(this.onPremManagerToolbox, planState.getClusterId(), wasData.contains(host) ? dataCount.get() : dataCount.incrementAndGet()));
            }
            if (toQuery.contains(host)) {
                updatePlan.add((Stage)new OnPremAwaitQueryInstancesAvailableStage(this.toolbox, planState.getClusterId(), wasQuery.contains(host) ? queryCount.get() : queryCount.incrementAndGet()));
            }
            if (toMaster.contains(host)) {
                updatePlan.add((Stage)new OnPremAwaitMasterInstancesAvailableStage(this.toolbox, planState.getClusterId(), wasMaster.contains(host) ? masterCount.get() : masterCount.incrementAndGet()));
            }
            currentView.put((String)host, (NodeConfiguration)planState.getFilteredEndingClusterNodes().get(host));
        });
    }

    protected void reenableMiddleManagers(List<String> hosts, PlanUpdateState planState, Deque<Stage> updatePlan) {
        hosts.stream().filter(h -> !this.previouslyModifiedHosts.contains(h)).forEach(h -> updatePlan.add((Stage)new EnableMiddleManagerStage(this.toolbox, planState.getClusterId(), h)));
    }

    private void addDisableAndDrain(List<String> hosts, PlanUpdateState planState, Deque<Stage> updatePlan) {
        this.addDisableAndDrain(hosts, planState, updatePlan, host -> {});
    }

    protected void addDisableAndDrain(List<String> hosts, PlanUpdateState planState, Deque<Stage> updatePlan, Consumer<String> fn) {
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        String clusterId = planState.getClusterId();
        Set masterHosts = planState.getMasterHostAddresses();
        for (String host : hosts) {
            updatePlan.add((Stage)new DisableMiddleManagerStage(this.toolbox, clusterId, ImplyNodeType.DATA, host, masterHosts));
            updatePlan.add((Stage)new AwaitMiddleManagerIdleStage(this.toolbox, clusterId, ImplyNodeType.DATA, host, masterHosts));
            updatePlan.add((Stage)new AwaitMiddleManagerTaskStatusStage(this.toolbox, clusterId, ImplyNodeType.DATA, host));
            updatePlan.add((Stage)new AwaitSegmentsAvailableStage(this.toolbox, clusterId, ImplyNodeType.DATA, masterHosts, null));
            fn.accept(host);
        }
    }

    private void addRollingStopDataNodesStages(List<String> hosts, PlanUpdateState planState, Deque<Stage> updatePlan) {
        this.addDisableAndDrain(hosts, planState, updatePlan, host -> this.addStopServiceStages(Collections.singletonList(host), planState, updatePlan));
    }

    private void addBecomeServiceStages(List<String> hosts, PlanUpdateState planState, Deque<Stage> updatePlan) {
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        if (!this.toolbox.getApplicationConfig().isKubernetesMode()) {
            Map endingNodes = planState.getFilteredEndingClusterNodes();
            for (String host : hosts) {
                Set nodeTypes = ((NodeConfiguration)endingNodes.get(host)).getNodeTypes();
                updatePlan.add((Stage)new OnPremWriteConfigServerRequestPayloadStage(this.toolbox, planState.getClusterId(), nodeTypes, planState.getAccount().getGroveServer(), host, planState.getStartingCluster().getConfigServerKey()));
            }
        }
        List hostChunks = Lists.partition(hosts, (int)10);
        for (List hostChunk : hostChunks) {
            updatePlan.add((Stage)new OnPremFetchConfigBundleStage(this.onPremManagerToolbox, planState.getClusterId(), planState.getAccount().getGroveServer(), hostChunk));
            updatePlan.add((Stage)new OnPremBecomeServicesStage(this.onPremManagerToolbox, planState.getClusterId(), planState.getAccount().getGroveServer(), hostChunk));
        }
    }

    private void addStopServiceStages(List<String> hosts, PlanUpdateState planState, Deque<Stage> updatePlan) {
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        updatePlan.add((Stage)new OnPremStopServicesStage(this.toolbox, planState.getClusterId(), planState.getAccount().getGroveServer(), hosts));
    }

    private List<String> addToHostsAlreadyUpdatedAndReturnUnprocessed(PlanUpdateState planState, List<String> hosts) {
        if (hosts == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> mutableHosts = new ArrayList<String>(hosts);
        mutableHosts.removeAll(planState.getHostsAlreadyUpdated());
        planState.getHostsAlreadyUpdated().addAll(mutableHosts);
        return mutableHosts;
    }

    protected void addRollingMasterReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
        List<String> toUpdate;
        if (!planState.isFullMasterReplacement()) {
            return;
        }
        List hosts = ClusterNodesHelper.getSortedMasterHosts((Map)planState.getFilteredEndingClusterNodes());
        if (!this.previouslyModifiedHosts.isEmpty()) {
            hosts.retainAll(this.previouslyModifiedHosts);
        }
        if (!hosts.equals(toUpdate = this.addToHostsAlreadyUpdatedAndReturnUnprocessed(planState, hosts))) {
            throw new ISE("Multi-tenancy node found for rolling update, aborting", new Object[0]);
        }
        this.addRollingBecomeServiceStages(toUpdate, planState, updatePlan, planState.getFilteredStartingClusterNodes(), planState.getFilteredEndingClusterNodes());
    }

    protected void addNonRollingMasterReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
        if (!planState.isFullMasterReplacement()) {
            return;
        }
        List<String> masterHosts = this.addToHostsAlreadyUpdatedAndReturnUnprocessed(planState, ClusterNodesHelper.getSortedMasterHosts((Map)planState.getFilteredEndingClusterNodes()));
        if (masterHosts == null || masterHosts.isEmpty()) {
            log.info("No nodes in [MASTER] were found that need replacing, nothing to do!");
            return;
        }
        this.addBecomeServiceStages(masterHosts, planState, updatePlan);
    }

    protected void addRollingDataReplacementStages(PlanUpdateState planState, ImplyNodeType nodeType, Deque<Stage> updatePlan) {
        List<String> toUpdate;
        if (!((DataTierInfo)planState.getDataTierInfoMap().get(nodeType)).isFullReplacement()) {
            return;
        }
        List hosts = ClusterNodesHelper.getSortedHosts((Map)planState.getFilteredEndingClusterNodes(), Collections.singletonList(nodeType));
        if (!this.previouslyModifiedHosts.isEmpty()) {
            hosts.retainAll(this.previouslyModifiedHosts);
        }
        if (!hosts.equals(toUpdate = this.addToHostsAlreadyUpdatedAndReturnUnprocessed(planState, hosts))) {
            throw new ISE("Multi-tenancy node found for rolling update, aborting", new Object[0]);
        }
        this.maybeUpdateCoordinatorDynamicConfiguration(planState, updatePlan, toUpdate, (List<String>)ImmutableList.of());
        this.addRollingBecomeServiceStages(toUpdate, planState, updatePlan, planState.getFilteredStartingClusterNodes(), planState.getFilteredEndingClusterNodes());
    }

    protected void addNonRollingDataReplacementStages(PlanUpdateState planState, ImplyNodeType nodeType, Deque<Stage> updatePlan) {
        if (!((DataTierInfo)planState.getDataTierInfoMap().get(nodeType)).isFullReplacement()) {
            return;
        }
        List<String> dataHosts = this.addToHostsAlreadyUpdatedAndReturnUnprocessed(planState, ClusterNodesHelper.getSortedHosts((Map)planState.getFilteredEndingClusterNodes(), Collections.singletonList(nodeType)));
        if (dataHosts == null || dataHosts.isEmpty()) {
            log.info("No nodes in [%s] were found that need replacing, nothing to do!", new Object[]{nodeType});
            return;
        }
        this.addBecomeServiceStages(dataHosts, planState, updatePlan);
    }

    protected void addRollingQueryReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
        List<String> toUpdate;
        if (!planState.isFullQueryReplacement()) {
            return;
        }
        List hosts = ClusterNodesHelper.getSortedQueryHosts((Map)planState.getFilteredEndingClusterNodes());
        if (!this.previouslyModifiedHosts.isEmpty()) {
            hosts.retainAll(this.previouslyModifiedHosts);
        }
        if (!hosts.equals(toUpdate = this.addToHostsAlreadyUpdatedAndReturnUnprocessed(planState, hosts))) {
            throw new ISE("Multi-tenancy node found for rolling update, aborting", new Object[0]);
        }
        this.addRollingBecomeServiceStages(toUpdate, planState, updatePlan, planState.getFilteredStartingClusterNodes(), planState.getFilteredEndingClusterNodes());
    }

    protected void addNonRollingQueryReplacementStages(PlanUpdateState planState, Deque<Stage> updatePlan) {
        if (!planState.isFullQueryReplacement()) {
            return;
        }
        List<String> queryHosts = this.addToHostsAlreadyUpdatedAndReturnUnprocessed(planState, ClusterNodesHelper.getSortedQueryHosts((Map)planState.getFilteredEndingClusterNodes()));
        if (queryHosts == null || queryHosts.isEmpty()) {
            log.info("No nodes in [QUERY] were found that need replacing, nothing to do!");
            return;
        }
        this.addBecomeServiceStages(queryHosts, planState, updatePlan);
    }

    private void addAwaitInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan, Map<String, NodeConfiguration> nodes) {
        this.addAwaitMasterInstancesAvailableStage(planState, updatePlan, ClusterNodesHelper.getSortedMasterHosts(nodes));
        this.addAwaitQueryInstancesAvailableStage(planState, updatePlan, ClusterNodesHelper.getSortedQueryHosts(nodes));
        this.addAwaitDataInstancesAvailableStage(planState, updatePlan, ClusterNodesHelper.getSortedDataHosts(nodes));
    }

    private void addAwaitMasterInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan, List<String> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        updatePlan.add((Stage)new OnPremAwaitMasterInstancesAvailableStage(this.toolbox, planState.getClusterId(), hosts.size()));
    }

    protected void addAwaitMasterInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan) {
        this.addAwaitMasterInstancesAvailableStage(planState, updatePlan, ClusterNodesHelper.getSortedMasterHosts((Map)planState.getFilteredEndingClusterNodes()));
    }

    private void addAwaitQueryInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan, List<String> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        updatePlan.add((Stage)new OnPremAwaitQueryInstancesAvailableStage(this.toolbox, planState.getClusterId(), hosts.size()));
    }

    protected void addAwaitQueryInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan) {
        this.addAwaitQueryInstancesAvailableStage(planState, updatePlan, ClusterNodesHelper.getSortedQueryHosts((Map)planState.getFilteredEndingClusterNodes()));
    }

    private void addAwaitDataInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan, List<String> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        updatePlan.add((Stage)new OnPremAwaitDataInstancesAvailableStage(this.onPremManagerToolbox, planState.getClusterId(), hosts.size()));
    }

    protected void addAwaitDataInstancesAvailableStage(PlanUpdateState planState, Deque<Stage> updatePlan) {
        this.addAwaitDataInstancesAvailableStage(planState, updatePlan, ClusterNodesHelper.getSortedDataHosts((Map)planState.getFilteredEndingClusterNodes()));
    }

    private boolean isHealthy(String host, NodeConfiguration nodeConfiguration, String clusterId) {
        Set types = nodeConfiguration.getNodeTypes();
        if (types.stream().anyMatch(ImplyNodeType::isDataType) && !this.isDataHealthy(host, clusterId)) {
            return false;
        }
        if (types.stream().anyMatch(arg_0 -> ((ImplyNodeType)ImplyNodeType.QUERY).equals(arg_0)) && !this.isQueryHealthy(host, clusterId)) {
            return false;
        }
        return !types.stream().anyMatch(arg_0 -> ((ImplyNodeType)ImplyNodeType.MASTER).equals(arg_0)) || this.isMasterHealthy(host, clusterId);
    }

    private boolean isDataHealthy(String host, String clusterId) {
        return this.toolbox.getDruidApiClient().isHistoricalStatusOK(host, clusterId) && this.toolbox.getDruidApiClient().isMiddleManagerStatusOK(host, clusterId);
    }

    private boolean isQueryHealthy(String host, String clusterId) {
        return this.toolbox.getDruidApiClient().isBrokerStatusOK(host, clusterId) && this.toolbox.getDruidApiClient().isRouterStatusOK(host, clusterId) && this.toolbox.getDruidApiClient().isPivotHealthOK(host, clusterId);
    }

    private boolean isMasterHealthy(String host, String clusterId) {
        return this.toolbox.getDruidApiClient().isCoordinatorStatusOK(host, clusterId) && this.toolbox.getDruidApiClient().isOverlordStatusOK(host, clusterId);
    }

    protected Map<ImplyNodeType, DataTierInfo> constructDataTierInfoMap(Cluster startingCluster, Cluster endingCluster, ClusterNodes startingClusterNodes, ClusterNodes endingClusterNodes) {
        List dataTiers;
        HashSet allTiers = new HashSet();
        if (startingCluster.getDataInstanceTiers() != null) {
            allTiers.addAll(startingCluster.getDataInstanceTiers().keySet());
        }
        if (endingCluster.getDataInstanceTiers() != null) {
            allTiers.addAll(endingCluster.getDataInstanceTiers().keySet());
        }
        if (startingClusterNodes.getNodes() != null) {
            dataTiers = ClusterNodesHelper.getAllDataTiers((Map)startingClusterNodes.getNodes());
            allTiers.addAll(dataTiers.stream().map(ImplyNodeType::getTierNumber).collect(Collectors.toList()));
        }
        if (endingClusterNodes.getNodes() != null) {
            dataTiers = ClusterNodesHelper.getAllDataTiers((Map)endingClusterNodes.getNodes());
            allTiers.addAll(dataTiers.stream().map(ImplyNodeType::getTierNumber).collect(Collectors.toList()));
        }
        return allTiers.stream().map(ImplyNodeType::dataFromTierInteger).collect(Collectors.toMap(x -> x, DataTierInfo::new));
    }
}

