/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.PlanAgentUpdateNotice;
import io.imply.cloud.manager.stage.AwaitMiddleManagerIdleStage;
import io.imply.cloud.manager.stage.AwaitSegmentsAvailableStage;
import io.imply.cloud.manager.stage.DisableMiddleManagerStage;
import io.imply.cloud.manager.stage.ModifyCoordinatorDynamicConfigurationStage;
import io.imply.cloud.manager.stage.ModifyCoordinatorDynamicConfigurationWithDetectedMasterStage;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.User;
import io.imply.cloud.onprem.stage.OnPremAwaitAgentReplacementStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Retryable;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class OnPremPlanAgentUpdateNotice
extends PlanAgentUpdateNotice
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremPlanAgentUpdateNotice.class);
    private final ClusterDataManager clusterDataManager;
    private final OnPremManagerToolbox onPremManagerToolbox;

    @Inject
    public OnPremPlanAgentUpdateNotice(OnPremManagerToolbox toolbox) {
        super((ManagerToolbox)toolbox);
        this.clusterDataManager = toolbox.getClusterDataManager();
        this.onPremManagerToolbox = toolbox;
    }

    public void innerHandle() {
        this.addInfoNotification("Fetching initial cluster state", new Object[0]);
        User principal = ThreadLocalContext.getPrincipal();
        Cluster cluster = this.clusterDataManager.getVersionOrNull(this.info.getEntityId(), this.info.getDeployedClusterVersion().intValue());
        if (cluster == null) {
            throw new ISE("Could not get deployedCluster [%s] for cluster [%s], cannot continue.", new Object[]{this.info.getDeployedClusterVersion(), this.info.getEntityId()});
        }
        Account account = this.toolbox.getAccountDataManager().getOrNull(cluster.getAccountId());
        if (account == null) {
            throw new ISE("Could not get account [%s] for cluster [%s], cannot continue.", new Object[]{cluster.getAccountId(), this.info.getEntityId()});
        }
        ClusterNodes clusterNodes = this.toolbox.getClusterNodesDataManager().getVersionOrNull(cluster.getClusterId(), this.info.getDeployedClusterNodesVersion().intValue());
        if (clusterNodes == null) {
            throw new ISE("Could not get nodes [%s] for cluster [%s], cannot continue.", new Object[]{this.info.getDeployedClusterNodesVersion(), this.info.getEntityId()});
        }
        ArrayDeque stages = new ArrayDeque();
        Map nodes = clusterNodes.getNodes();
        ImmutableSet masterHosts = ImmutableSet.copyOf((Collection)ClusterNodesHelper.getSortedMasterHosts((Map)nodes));
        Object nodesToUpdate = ImmutableMap.copyOf((Map)nodes);
        if (CollectionUtils.isNotEmpty((Collection)this.info.getUpdateState().getHosts())) {
            nodesToUpdate = nodes.entrySet().stream().filter(x -> this.info.getUpdateState().getHosts().contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        Optional<Object> coordinatorDynamicConfiguration = Optional.empty();
        if (nodesToUpdate.isEmpty()) {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_AGENT_UPDATED).build());
            this.addInfoNotification("No changes to apply, cluster update complete", new Object[0]);
            return;
        }
        if (!ClusterNodesHelper.getSortedDataHosts((Map)nodesToUpdate).isEmpty()) {
            coordinatorDynamicConfiguration = this.getCoordinatorDynamicConfiguration((Set<String>)masterHosts);
            coordinatorDynamicConfiguration.ifPresent(arg_0 -> this.lambda$innerHandle$1(stages, (Set)masterHosts, principal, arg_0));
        }
        ArrayList modified = new ArrayList();
        ClusterNodesHelper.getSortedDataHosts((Map)nodesToUpdate).forEach(arg_0 -> this.lambda$innerHandle$2(stages, cluster, (Set)masterHosts, modified, arg_0));
        ClusterNodesHelper.getSortedQueryHosts((Map)nodesToUpdate).forEach(host -> {
            if (modified.contains(host)) {
                return;
            }
            stages.add(new OnPremAwaitAgentReplacementStage(this.onPremManagerToolbox, cluster.getClusterId(), (String)host));
            modified.add(host);
        });
        ClusterNodesHelper.getSortedMasterHosts((Map)nodesToUpdate).forEach(host -> {
            if (modified.contains(host)) {
                return;
            }
            stages.add(new OnPremAwaitAgentReplacementStage(this.onPremManagerToolbox, cluster.getClusterId(), (String)host));
            modified.add(host);
        });
        coordinatorDynamicConfiguration.ifPresent(config -> stages.add(new ModifyCoordinatorDynamicConfigurationWithDetectedMasterStage(this.toolbox, this.info.getEntityId(), null, config, Boolean.valueOf(true), DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), "Restoring [maxSegmentsToMove] and [replicationThrottleLimit] to original values after rolling update")));
        UpdateState updateState = UpdateState.builder((UpdateState)this.info.getUpdateState()).pendingRollingStages(this.toolbox.getStageHelper().tagWithStageNumbers(stages, 1)).completedRollingStages(new ArrayDeque()).currentState(State.CLUSTER_AGENT_UPDATE_IN_PROGRESS).clearTimerAndCounters().cancelAllowed(Boolean.valueOf(true)).coordinatorDynamicConfiguration((String)coordinatorDynamicConfiguration.orElse(null)).build();
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_AGENT_UPDATE_IN_PROGRESS).withUpdateState(updateState).build());
        log.info("Update plan: [%s]", new Object[]{updateState});
        this.addInfoNotification("Submitting plan for execution", new Object[0]);
        this.setQueueNextNotice();
    }

    private Optional<String> getCoordinatorDynamicConfiguration(Set<String> masterHosts) {
        try {
            return Optional.of((String)Retryable.of(() -> this.toolbox.getDruidApiClient().getCoordinatorDynamicConfiguration((Collection)masterHosts, this.info.getEntityId()), (int)3, (int)2, (boolean)true));
        }
        catch (Exception e) {
            log.info((Throwable)e, "Failed to fetch coordinator dynamic configuration for cluster [%s], continuing without adjusting maxSegmentsToMove", new Object[]{this.info.getEntityId()});
            return Optional.empty();
        }
    }

    private /* synthetic */ void lambda$innerHandle$2(Deque stages, Cluster cluster, Set masterHosts, List modified, String host) {
        stages.add(new DisableMiddleManagerStage(this.toolbox, cluster.getClusterId(), ImplyNodeType.DATA, host, masterHosts));
        stages.add(new AwaitMiddleManagerIdleStage(this.toolbox, cluster.getClusterId(), ImplyNodeType.DATA, host, masterHosts));
        stages.add(new AwaitSegmentsAvailableStage(this.toolbox, cluster.getClusterId(), ImplyNodeType.DATA, masterHosts, null));
        stages.add(new OnPremAwaitAgentReplacementStage(this.onPremManagerToolbox, cluster.getClusterId(), host));
        modified.add(host);
    }

    private /* synthetic */ void lambda$innerHandle$1(Deque stages, Set masterHosts, User principal, String config) {
        stages.add(new ModifyCoordinatorDynamicConfigurationStage(this.toolbox, this.info.getEntityId(), null, masterHosts, this.toolbox.getClusterUpdateHelper().generateModifiedCoordinatorDynamicConfiguration(config, 200, 2000), Boolean.valueOf(false), DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), String.format("Temporarily setting [maxSegmentsToMove=%d] and [replicationThrottleLimit=%d] for rolling update", 200, 2000)));
    }
}

