/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.UpdateClusterStackNotice;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.DiffResultHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import io.imply.cloud.util.Retryable;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.DiffResult;

public class OnPremKubernetesUpdateClusterStackNotice
extends UpdateClusterStackNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesUpdateClusterStackNotice.class);
    private final ClusterOperator clusterOperator;
    protected final K8sUtilsProvider k8sUtilsProvider;

    @Inject
    public OnPremKubernetesUpdateClusterStackNotice(OnPremManagerToolbox toolbox, ClusterOperator clusterOperator, K8sUtilsProvider k8sUtilsProvider) {
        super((ManagerToolbox)toolbox);
        this.clusterOperator = clusterOperator;
        this.k8sUtilsProvider = k8sUtilsProvider;
    }

    public void innerHandle() {
        ClusterOperationResult clusterOperationResult;
        DiffResult diffs;
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.info.getEntityId());
        Account account = this.toolbox.getAccountDataManager().get(cluster.getAccountId());
        Cluster deployedCluster = this.toolbox.getClusterDataManager().getVersionOrNull(cluster.getClusterId(), this.info.getDeployedClusterVersion() == null ? 0 : this.info.getDeployedClusterVersion());
        int configServerClusterVersion = deployedCluster != null ? (DiffResultHelper.contains((DiffResult)(diffs = deployedCluster.diff(cluster)), (String)"implyVersionFull") ? this.info.getDeployedClusterVersion() : cluster.getVersion()).intValue() : cluster.getVersion().intValue();
        this.entityStateDataManager.insert(this.info, Info.builder().withConfigServerClusterVersion(Integer.valueOf(configServerClusterVersion)).build());
        boolean hasVolumeCountChanged = deployedCluster != null && this.volumeCountChanged(cluster, deployedCluster);
        boolean isScaleDownOperation = deployedCluster != null && this.scaleDownOperation(cluster, deployedCluster);
        String clusterNamespace = HelmUtils.generateNamespaceForCluster(cluster, this.toolbox.getApplicationConfig());
        String clusterReleaseName = HelmUtils.generateReleaseNameForCluster(cluster, this.toolbox.getApplicationConfig());
        if (hasVolumeCountChanged) {
            try {
                log.info("Change requires orphaning pods and recreating StatefulSet for cluster %s", new Object[]{cluster.getClusterId()});
                this.k8sUtilsProvider.getKubernetesUtils(cluster).deleteStatefulSetWithOrphanForRelease(clusterNamespace, clusterReleaseName);
            }
            catch (KubernetesClientException e) {
                log.error((Throwable)e, "Exception while attempting to delete statefulset for cluster [%s]", new Object[]{cluster.getClusterId()});
                throw new RuntimeException(e);
            }
        }
        if (ClusterOperationResult.Status.FAILED.equals((Object)(clusterOperationResult = (ClusterOperationResult)Retryable.of(() -> {
            ClusterOperationResult result = this.applyClusterUpdate(cluster, account);
            if (hasVolumeCountChanged && ClusterOperationResult.Status.FAILED.equals((Object)result.getStatus())) {
                throw new ISE("Failed to update cluster [%s]. %s", new Object[]{cluster.getClusterId(), result.getMessage()});
            }
            return result;
        })).getStatus())) {
            log.warn("Failed to update cluster [%s]. %s", new Object[]{cluster.getClusterId(), clusterOperationResult.getMessage()});
            this.addCriticalNotification("Failed to update cluster. %s", new Object[]{clusterOperationResult.getMessage()});
            this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getExceptionState()).build());
        } else if (hasVolumeCountChanged && !isScaleDownOperation) {
            log.info("Change requires a managed rollout restart for pods of cluster  %s", new Object[]{cluster.getClusterId()});
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.PLAN_KUBERNETES_STATEFULSET_ROLLING_UPDATE).build());
        } else {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(State.UPDATING_CLUSTER_STACK).build());
        }
        this.setQueueNextNotice();
    }

    protected ClusterOperationResult applyClusterUpdate(Cluster cluster, Account account) {
        log.info("Submitting request to update cluster stack");
        this.addInfoNotification("Submitting request to update cluster stack", new Object[0]);
        return this.clusterOperator.updateCluster(cluster, account);
    }

    protected boolean volumeCountChanged(Cluster proposedCluster, Cluster deployedCluster) {
        return deployedCluster.getDataInstanceTiers().entrySet().stream().map(e -> this.toDiskPVCBaseSizePair(proposedCluster, (Map.Entry<Integer, InstanceTier>)e)).anyMatch(p -> {
            Integer deployedEBSVolumeCount;
            Integer proposedEBSVolumeCount = (int)Math.ceil((double)((Integer)((Pair)p.lhs).lhs).intValue() / (double)((Integer)((Pair)p.lhs).rhs).intValue());
            return !proposedEBSVolumeCount.equals(deployedEBSVolumeCount = Integer.valueOf((int)Math.ceil((double)((Integer)((Pair)p.rhs).lhs).intValue() / (double)((Integer)((Pair)p.rhs).rhs).intValue())));
        });
    }

    protected boolean scaleDownOperation(Cluster proposedCluster, Cluster deployedCluster) {
        return deployedCluster.getDataInstanceTiers().entrySet().stream().map(e -> this.toDiskPVCBaseSizePair(proposedCluster, (Map.Entry<Integer, InstanceTier>)e)).anyMatch(p -> (Integer)((Pair)p.lhs).lhs < (Integer)((Pair)p.rhs).lhs);
    }

    protected Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> toDiskPVCBaseSizePair(Cluster proposedCluster, Map.Entry<Integer, InstanceTier> e) {
        InstanceTier proposedTier = (InstanceTier)proposedCluster.getDataInstanceTiers().get(e.getKey());
        InstanceTier deployedTier = e.getValue();
        return Pair.of((Object)this.toolbox.getClusterUpdateHelper().getDiskBaseEBSSizePair(proposedTier), (Object)this.toolbox.getClusterUpdateHelper().getDiskBaseEBSSizePair(deployedTier));
    }

    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    protected Status getFailureStatus() {
        return Status.WARNING;
    }

    protected State getExceptionState() {
        return State.CLUSTER_UPDATE_FAILED_PROMPT_USER;
    }
}

