/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.PlanKubernetesStatefulSetRollingUpdate;
import io.imply.cloud.manager.stage.AwaitSegmentsAvailableWithDetectedMasterStage;
import io.imply.cloud.manager.stage.ModifyCoordinatorDynamicConfigurationStage;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.User;
import io.imply.cloud.onprem.stage.OnPremAwaitDataInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremKubernetesAwaitPodTerminationStage;
import io.imply.cloud.onprem.stage.OnPremKubernetesEvictPodStage;
import io.imply.cloud.onprem.util.K8sUtilsProvider;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Retryable;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class OnPremKubernetesPlanKubernetesStatefulSetRollingUpdate
extends PlanKubernetesStatefulSetRollingUpdate {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesPlanKubernetesStatefulSetRollingUpdate.class);
    private static final String STATEFULSET_NAME_FORMAT = "%s-%d";
    protected final K8sUtilsProvider k8sUtilsProvider;
    private final OnPremManagerToolbox onPremManagerToolbox;

    @Inject
    public OnPremKubernetesPlanKubernetesStatefulSetRollingUpdate(OnPremManagerToolbox toolbox, K8sUtilsProvider k8sUtilsProvider) {
        super((ManagerToolbox)toolbox);
        this.k8sUtilsProvider = k8sUtilsProvider;
        this.onPremManagerToolbox = toolbox;
    }

    public void innerHandle() {
        Cluster cluster = this.toolbox.getClusterDataManager().get(this.info.getEntityId());
        int deployedClusterVersion = this.info.getDeployedClusterVersion() == null ? 0 : this.info.getDeployedClusterVersion();
        Cluster deployedCluster = this.toolbox.getClusterDataManager().getVersionOrNull(cluster.getClusterId(), deployedClusterVersion);
        if (deployedCluster == null) {
            throw new ISE("Deployed cluster cannot be null", new Object[0]);
        }
        ArrayDeque<ModifyCoordinatorDynamicConfigurationStage> updatePlan = new ArrayDeque<ModifyCoordinatorDynamicConfigurationStage>();
        this.addInfoNotification("Generating plan for rolling updating kubernetes statefulset", new Object[0]);
        User principal = ThreadLocalContext.getPrincipal();
        Optional<String> coordinatorDynamicConfiguration = this.getCoordinatorDynamicConfiguration(cluster.getClusterId()).map(config -> this.toolbox.getClusterUpdateHelper().generateModifiedCoordinatorDynamicConfiguration(config, 200, 2000));
        if (coordinatorDynamicConfiguration.isPresent()) {
            updatePlan.add(new ModifyCoordinatorDynamicConfigurationStage(this.toolbox, cluster.getClusterId(), ImplyNodeType.MASTER, (Set)ImmutableSet.of(), coordinatorDynamicConfiguration.get(), Boolean.valueOf(false), DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), String.format("Temporarily setting [maxSegmentsToMove=%d] and [replicationThrottleLimit=%d] for kubernetes statefulset rolling update", 200, 2000)));
        }
        int totalDeployedInstancesForProposedTiers = deployedCluster.getDataInstanceTiers().entrySet().stream().filter(e -> Optional.ofNullable((InstanceTier)cluster.getDataInstanceTiers().get(e.getKey())).map(InstanceTier::getInstanceCount).orElse(0) > 0).map(e -> ((InstanceTier)e.getValue()).getInstanceCount()).reduce(0, Integer::sum);
        deployedCluster.getDataInstanceTiers().entrySet().stream().forEach(e -> {
            InstanceTier proposedTier = (InstanceTier)cluster.getDataInstanceTiers().get(e.getKey());
            if (proposedTier == null) {
                return;
            }
            Integer proposedInstanceCount = proposedTier.getInstanceCount();
            Integer deployedInstanceCount = ((InstanceTier)e.getValue()).getInstanceCount();
            this.generateStatefulSetUpdateStages(cluster.getClusterId(), this.toolbox.getClusterUpdateHelper().getStatefulsetNameFromTier((Integer)e.getKey(), cluster), deployedInstanceCount, totalDeployedInstancesForProposedTiers, ImplyNodeType.DATA, this.shouldForceDelete(proposedInstanceCount, deployedInstanceCount), updatePlan);
        });
        if (coordinatorDynamicConfiguration.isPresent()) {
            updatePlan.add(new ModifyCoordinatorDynamicConfigurationStage(this.toolbox, cluster.getClusterId(), ImplyNodeType.MASTER, (Set)ImmutableSet.of(), coordinatorDynamicConfiguration.get(), Boolean.valueOf(true), DruidApiClient.generateAuditAuthor((String)(principal == null ? null : principal.getDetailedUserId())), "Restoring [maxSegmentsToMove] and [replicationThrottleLimit] to original values after kubernetes statefulset rolling update"));
        }
        UpdateState updateState = UpdateState.builder((UpdateState)this.info.getUpdateState()).pendingRollingStages(updatePlan).completedRollingStages(new ArrayDeque()).currentState(State.KUBERNETES_STATEFULSET_ROLLING_UPDATE).clearTimerAndCounters().build();
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.KUBERNETES_STATEFULSET_ROLLING_UPDATE).withUpdateState(updateState).withConfigServerClusterVersion(cluster.getVersion()).build());
    }

    protected void generateStatefulSetUpdateStages(String clusterId, String statefulSetName, Integer stsDeployedInstanceCount, Integer totalDeployedInstanceCount, ImplyNodeType nodeType, Boolean forceDeletion, Deque<Stage> updatePlan) {
        for (int i = 0; i < stsDeployedInstanceCount; ++i) {
            updatePlan.add((Stage)new OnPremKubernetesEvictPodStage(this.toolbox, this.k8sUtilsProvider, clusterId, String.format(STATEFULSET_NAME_FORMAT, statefulSetName, i), forceDeletion));
            updatePlan.add((Stage)new OnPremKubernetesAwaitPodTerminationStage(this.toolbox, this.k8sUtilsProvider, clusterId, String.format(STATEFULSET_NAME_FORMAT, statefulSetName, i)));
            updatePlan.add((Stage)new OnPremAwaitDataInstancesAvailableStage(this.onPremManagerToolbox, clusterId, totalDeployedInstanceCount));
            updatePlan.add((Stage)new AwaitSegmentsAvailableWithDetectedMasterStage(this.toolbox, clusterId, nodeType, null));
        }
    }

    protected Optional<String> getCoordinatorDynamicConfiguration(String clusterId) {
        try {
            String coordinatorDynamicConfiguration = (String)Retryable.of(() -> this.toolbox.getDruidApiClient().getCoordinatorDynamicConfiguration((Collection)this.toolbox.getClusterNodesHelper().getSortedMasterHosts(clusterId), clusterId), (int)3, (int)2, (boolean)true);
            return Optional.of(coordinatorDynamicConfiguration);
        }
        catch (Exception e) {
            log.info((Throwable)e, "Failed to fetch coordinator dynamic configuration for cluster [%s], continuing kubernetes statefulset rolling update without adjusting maxSegmentsToMove", new Object[]{clusterId});
            return Optional.empty();
        }
    }

    protected boolean shouldForceDelete(int proposedInstanceCount, int deployedInstanceCount) {
        return true;
    }
}

