/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.PlanClusterCreationNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.stage.OnPremAwaitDataInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitMasterInstancesAvailableStage;
import io.imply.cloud.onprem.stage.OnPremAwaitQueryInstancesAvailableStage;
import io.imply.cloud.onprem.stage.creation.OnPremCheckZooKeeperStage;
import io.imply.cloud.onprem.stage.creation.OnPremMaybeCreateMetadataDatabaseStage;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.ClusterDataManager;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Inject;
import org.apache.commons.lang3.BooleanUtils;

public class OnPremKubernetesPlanClusterCreationNotice
extends PlanClusterCreationNotice
implements OnPremHelpers {
    private final OnPremManagerToolbox toolbox;
    private final ClusterDataManager clusterDataManager;

    @Inject
    public OnPremKubernetesPlanClusterCreationNotice(OnPremManagerToolbox toolbox) {
        super((ManagerToolbox)toolbox);
        this.toolbox = toolbox;
        this.clusterDataManager = toolbox.getClusterDataManager();
    }

    public void innerHandle() {
        OnPremCluster cluster = this.onprem(this.clusterDataManager.get(this.info.getEntityId()));
        this.addInfoNotification("Planning cluster creation", new Object[0]);
        this.entityStateDataManager.insert(this.info, Info.builder().withState(State.CLUSTER_STAGED_CREATION_IN_PROGRESS).withUpdateState(this.generateCreationStages(cluster)).withConfigServerClusterVersion(cluster.getVersion()).build());
        this.addInfoNotification("Submitting cluster creation plan for execution", new Object[0]);
        this.setQueueNextNotice();
    }

    protected UpdateState generateCreationStages(OnPremCluster cluster) {
        ArrayDeque<Stage> creationPlan = new ArrayDeque<Stage>();
        if (!this.toolbox.getOnPremManagerConfig().isSkipClusterMetadataStoreCheck()) {
            creationPlan.add((Stage)new OnPremMaybeCreateMetadataDatabaseStage(this.toolbox, cluster.getClusterId()));
        }
        if (!this.toolbox.getOnPremManagerConfig().isSkipClusterZkCheck()) {
            creationPlan.add((Stage)new OnPremCheckZooKeeperStage(this.toolbox, cluster.getClusterId()));
        }
        this.generateClusterReadyValidationStages(cluster, creationPlan);
        UpdateState.Builder updateStateBuilder = UpdateState.builder((UpdateState)this.info.getUpdateState()).pendingRollingStages(creationPlan).completedRollingStages(new ArrayDeque()).currentState(State.CLUSTER_STAGED_CREATION_IN_PROGRESS).clearTimerAndCounters();
        return updateStateBuilder.build();
    }

    protected void generateClusterReadyValidationStages(Cluster cluster, Deque<Stage> creationPlan) {
        if (BooleanUtils.isTrue((Boolean)this.toolbox.getManagerConfig().isSkipClusterReadyValidation())) {
            return;
        }
        creationPlan.add((Stage)new OnPremAwaitMasterInstancesAvailableStage(this.toolbox, cluster.getClusterId(), cluster.getMasterInstanceCount()));
        creationPlan.add((Stage)new OnPremAwaitDataInstancesAvailableStage(this.toolbox, cluster.getClusterId(), cluster.getDataInstanceTiers().entrySet().stream().mapToInt(tier -> ((InstanceTier)tier.getValue()).getInstanceCount()).sum()));
        creationPlan.add((Stage)new OnPremAwaitQueryInstancesAvailableStage(this.toolbox, cluster.getClusterId(), cluster.getQueryInstanceCount()));
    }

    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    protected State getExceptionState() {
        return State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION;
    }

    protected Status getFailureStatus() {
        return Status.WARNING;
    }
}

