/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.imply.cloud.Toolbox;
import io.imply.cloud.manager.ClusterOperationResult;
import io.imply.cloud.manager.ClusterOperator;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.CreateClusterStackNotice;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.Logger;
import lombok.Generated;

public class OnPremKubernetesCreateClusterStackNotice
extends CreateClusterStackNotice
implements OnPremHelpers {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesCreateClusterStackNotice.class);
    private final ClusterOperator clusterOperator;
    private final ClusterDataManager clusterDataManager;
    private final AccountDataManager accountDataManager;

    @Inject
    public OnPremKubernetesCreateClusterStackNotice(OnPremManagerToolbox toolbox, ClusterOperator clusterOperator) {
        super((ManagerToolbox)toolbox);
        this.clusterDataManager = toolbox.getClusterDataManager();
        this.accountDataManager = toolbox.getAccountDataManager();
        this.clusterOperator = clusterOperator;
    }

    public void innerHandle() {
        Cluster cluster = this.clusterDataManager.get(this.info.getEntityId());
        Account account = this.accountDataManager.get(cluster.getAccountId());
        cluster = this.onprem((Toolbox)this.toolbox).getOnPremClusterSecurityHelper().maybeUpdateSecurity(this.onprem(cluster), x$0 -> this.addInfoNotification((String)x$0, new Object[0]));
        log.info("Submitting request to create cluster stack");
        this.addInfoNotification("Submitting request to create cluster stack", new Object[0]);
        ClusterOperationResult clusterOperationResult = this.clusterOperator.createCluster(cluster, account);
        if (ClusterOperationResult.Status.FAILED.equals((Object)clusterOperationResult.getStatus())) {
            log.warn("Failed to create cluster [%s]. %s", new Object[]{cluster.getClusterId(), clusterOperationResult.getMessage()});
            this.addCriticalNotification("Failed to create cluster. %s", new Object[]{clusterOperationResult.getMessage()});
            this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getExceptionState()).build());
        } else {
            this.entityStateDataManager.insert(this.info, Info.builder().withState(this.getNextState()).build());
        }
        this.setQueueNextNotice();
    }

    protected State getNextState() {
        return State.CREATING_CLUSTER_STACK;
    }

    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    protected Status getFailureStatus() {
        return Status.CRITICAL;
    }

    protected State getExceptionState() {
        return State.CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION;
    }
}

