/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.notice.cluster;

import com.google.inject.Inject;
import io.imply.cloud.Toolbox;
import io.imply.cloud.exception.GroveAgentException;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.notice.cluster.DeleteClusterStackNotice;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.Status;
import io.imply.cloud.onprem.model.OnPremAccount;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.onprem.model.OnPremInfo;
import io.imply.cloud.onprem.util.OnPremHelpers;
import io.imply.cloud.onprem.util.OnPremManagerToolbox;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;

public class OnPremDeleteClusterStackNotice
extends DeleteClusterStackNotice
implements OnPremHelpers {
    private static final Logger log = new Logger(OnPremDeleteClusterStackNotice.class);
    private final AccountDataManager accountDataManager;
    private final ClusterDataManager clusterDataManager;

    @Inject
    public OnPremDeleteClusterStackNotice(OnPremManagerToolbox toolbox) {
        super((ManagerToolbox)toolbox);
        this.accountDataManager = toolbox.getAccountDataManager();
        this.clusterDataManager = toolbox.getClusterDataManager();
    }

    public void innerHandle() {
        OnPremCluster cluster = this.onprem(this.clusterDataManager.get(this.info.getEntityId()));
        OnPremAccount account = this.onprem(this.accountDataManager.get(cluster.getAccountId()));
        HashSet usedHosts = new HashSet();
        for (Cluster aCluster : this.toolbox.getClusterDataManager().getAll()) {
            Info info;
            if (aCluster.getClusterId().equals(cluster.getClusterId()) || (info = this.toolbox.getEntityStateDataManager().getOrNull(aCluster)) == null || info.getState() == null || info.getState().isStoppedTerminatedOrFailed()) continue;
            if (!(aCluster instanceof OnPremCluster)) {
                throw new ISE("Expecting object type [OnPremCluster] but found [%s]", new Object[]{aCluster.getClass().getName()});
            }
            usedHosts.addAll(this.onprem((Toolbox)this.toolbox).getClusterNodesHelper().getSortedHosts(aCluster.getClusterId()));
        }
        ArrayList hostsToStop = new ArrayList(this.onprem((Toolbox)this.toolbox).getClusterNodesHelper().getSortedHosts(cluster.getClusterId()));
        hostsToStop.removeAll(usedHosts);
        if (!hostsToStop.isEmpty()) {
            try {
                this.toolbox.getGroveClient().retryableSimpleRun(account.getGroveServer(), hostsToStop, "grove-stop", 90, false);
            }
            catch (GroveAgentException e) {
                log.info("One or more agents did not return a success response, continuing with stop: %s", new Object[]{e.getMessage()});
                this.addWarningNotification("One or more agents did not stop cleanly: %s", new Object[]{e.getMessage()});
            }
        }
        this.entityStateDataManager.insert(this.info, (Info)((OnPremInfo.Builder)OnPremInfo.builder().withState(State.CLUSTER_STACK_DELETED)).build());
        this.setQueueNextNotice();
    }

    protected State getTimeoutState() {
        return this.getExceptionState();
    }

    protected Status getFailureStatus() {
        return Status.WARNING;
    }

    protected State getExceptionState() {
        return State.CLUSTER_DELETE_FAILED;
    }
}

