/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.Toolbox;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.Mapbox;
import io.imply.cloud.model.OtelCollector;
import io.imply.cloud.model.Pivot;
import io.imply.cloud.model.SecurityConfiguration;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.zookeeper.ExternalZooKeeper;
import io.imply.cloud.model.zookeeper.ManagedZooKeeper;
import io.imply.cloud.model.zookeeper.ZooKeeper;
import io.imply.cloud.onprem.model.OnPremInfo;
import io.imply.cloud.util.ClusterValidationHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OnPremCluster
extends Cluster {
    @VisibleForTesting
    OnPremCluster() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @JsonCreator
    @VisibleForTesting
    protected OnPremCluster(@JsonProperty(value="accountId") String accountId, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="name") String name, @JsonProperty(value="implyVersion") String implyVersion, @JsonProperty(value="masterInstanceType") String masterInstanceType, @JsonProperty(value="queryInstanceType") String queryInstanceType, @JsonProperty(value="dataInstanceType") String dataInstanceType, @JsonProperty(value="masterInstanceCount") Integer masterInstanceCount, @JsonProperty(value="queryInstanceCount") Integer queryInstanceCount, @JsonProperty(value="dataInstanceCount") Integer dataInstanceCount, @JsonProperty(value="version") Integer version, @JsonProperty(value="metadataStorage") MetadataStorage metadataStorage, @JsonProperty(value="customDruidProperties") Map<String, String> customDruidProperties, @JsonProperty(value="clusterNumber") Integer clusterNumber, @JsonProperty(value="created") DateTime created, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="userId") String userId, @JsonProperty(value="createdBy") String createdBy, @JsonProperty(value="modifiedBy") String modifiedBy, @JsonProperty(value="comments") String comments, @JsonProperty(value="configServerKey") String configServerKey, @JsonProperty(value="implyBundleId") String implyBundleId, @JsonProperty(value="implyVersionFull") ImplyVersion implyVersionFull, @JsonProperty(value="userExtensions") Map<String, String> userExtensions, @JsonProperty(value="extensionLoadList") List<String> extensionLoadList, @JsonProperty(value="security") SecurityConfiguration securityConfiguration, @JsonProperty(value="customFiles") List<UserFile> customFiles, @JsonProperty(value="deepStorage") DeepStorage deepStorage, @JsonProperty(value="dataInstanceTiers") Map<Integer, InstanceTier> dataInstanceTiers, @JsonProperty(value="featureFlags") List<String> featureFlags, @JsonProperty(value="userTags") Map<String, String> userTags, @JsonProperty(value="zooKeeper") ZooKeeper zooKeeper, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="useTls") Boolean useTls, @JsonProperty(value="useAuthentication") Boolean useAuthentication, @JsonProperty(value="pivot") Pivot pivot, @JsonProperty(value="deletionProtection") Boolean deletionProtection, @JsonProperty(value="stopProtection") Boolean stopProtection, @JsonProperty(value="mapbox") Mapbox mapbox, @JsonProperty(value="otelCollector") OtelCollector otelCollector) {
        this(accountId, clusterId, name, implyVersion, masterInstanceType, queryInstanceType, dataInstanceType, masterInstanceCount, queryInstanceCount, dataInstanceCount, version, null, metadataStorage, null, customDruidProperties, clusterNumber, created, lastModified, userId, createdBy, modifiedBy, comments, configServerKey, implyBundleId, implyVersionFull, userExtensions, extensionLoadList, securityConfiguration, null, customFiles, null, deepStorage, null, dataInstanceTiers, featureFlags, userTags, zooKeeper, metadata, useTls, useAuthentication, pivot, deletionProtection, stopProtection, mapbox, otelCollector);
    }

    OnPremCluster(String accountId, String clusterId, String name, String implyVersion, String masterInstanceType, String queryInstanceType, String dataInstanceType, Integer masterInstanceCount, Integer queryInstanceCount, Integer dataInstanceCount, Integer version, Integer logRetentionDays, MetadataStorage metadataStorage, Map<String, Object> extraDruidProperties, Map<String, String> customDruidProperties, Integer clusterNumber, DateTime created, DateTime lastModified, String userId, String createdBy, String modifiedBy, String comments, String configServerKey, String implyBundleId, ImplyVersion implyVersionFull, Map<String, String> userExtensions, List<String> extensionLoadList, SecurityConfiguration securityConfiguration, List<String> userFiles, List<UserFile> customFiles, String s3Location, DeepStorage deepStorage, Boolean encryptDataVolumes, Map<Integer, InstanceTier> dataInstanceTiers, List<String> featureFlags, Map<String, String> userTags, ZooKeeper zooKeeper, Map<String, Object> metadata, Boolean useTls, Boolean useAuthentication, Pivot pivot, Boolean deletionProtection, Boolean stopProtection, Mapbox mapbox, OtelCollector otelCollector) {
        super(accountId, clusterId, name, implyVersion, masterInstanceType, queryInstanceType, dataInstanceType, masterInstanceCount, queryInstanceCount, dataInstanceCount, version, logRetentionDays, metadataStorage, extraDruidProperties, customDruidProperties, clusterNumber, created, lastModified, userId, createdBy, modifiedBy, comments, configServerKey, implyBundleId, implyVersionFull, userExtensions, extensionLoadList, securityConfiguration, userFiles, customFiles, s3Location, deepStorage, encryptDataVolumes, dataInstanceTiers, featureFlags, userTags, zooKeeper, metadata, useTls, useAuthentication, pivot, deletionProtection, stopProtection, mapbox, otelCollector);
    }

    @JsonProperty(value="isSecure")
    public Boolean isSecure() {
        if (this.getClusterId() == null || this.getImplyVersion() == null) {
            return null;
        }
        return this.isUseTls() != null && this.isUseTls() != false;
    }

    public boolean isLogviewSupported() {
        return true;
    }

    protected void validateInternal(List<ImplyConstraintViolation> results, Account account, Toolbox toolbox, boolean skipClusterId) {
        ApplicationConfig applicationConfig;
        super.validateInternal(results, account, toolbox, skipClusterId);
        if (this.getZooKeeper() == null) {
            results.add(ImplyConstraintViolation.error((String)"zooKeeper", (String)"[zooKeeper] required", (Object[])new Object[0]));
        }
        if (!(applicationConfig = toolbox.getApplicationConfig()).isKubernetesMode()) {
            results.addAll(ClusterValidationHelper.validateCustomDruidProperties((Map)this.getCustomDruidProperties()));
        }
    }

    protected Set<String> getSupportedCustomSchemes() {
        return ImmutableSet.of((Object)String.format("%s:///", "manager"), (Object)"http://", (Object)"https://");
    }

    public Info.Builder getInfoBuilder() {
        return OnPremInfo.builder();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accountId", (Object)this.getAccountId()).append("clusterId", (Object)this.getClusterId()).append("name", (Object)this.getName()).append("implyVersion", (Object)this.getImplyVersion()).append("masterInstanceType", (Object)this.getMasterInstanceType()).append("queryInstanceType", (Object)this.getQueryInstanceType()).append("masterInstanceCount", (Object)this.getMasterInstanceCount()).append("queryInstanceCount", (Object)this.getQueryInstanceCount()).append("version", (Object)this.getVersion()).append("logRetentionDays", (Object)this.getLogRetentionDays()).append("metadataStorage", (Object)this.getMetadataStorage()).append("customDruidProperties", (Object)OnPremCluster.maskSensitiveProperties((Map)this.getCustomDruidProperties())).append("clusterNumber", (Object)this.getClusterNumber()).append("created", (Object)this.getCreated()).append("lastModified", (Object)this.getLastModified()).append("createdBy", (Object)this.getCreatedBy()).append("modifiedBy", (Object)this.getModifiedBy()).append("comments", (Object)this.getComments()).append("configServerKey", (Object)this.getConfigServerKey()).append("implyVersionFull", (Object)this.getImplyVersionFull()).append("userExtensions", (Object)this.getUserExtensions()).append("extensionLoadList", (Object)this.getExtensionLoadList()).append("securityConfiguration", (Object)this.getSecurityConfiguration()).append("customFiles", (Object)this.getCustomFiles()).append("deepStorage", (Object)this.getDeepStorage()).append("encryptDataVolumes", (Object)this.isEncryptDataVolumes()).append("dataInstanceTiers", (Object)this.getDataInstanceTiers()).append("featureFlags", (Object)this.getFeatureFlags()).append("userTags", (Object)this.getUserTags()).append("zooKeeper", (Object)this.getZooKeeper()).append("metadata", (Object)this.getMetadata()).append("useTls", (Object)this.isUseTls()).append("useAuthentication", (Object)this.isUseAuthentication()).toString();
    }

    public Builder<?, ?> cloner() {
        return (Builder)OnPremCluster.builder().withCluster(this);
    }

    public Cluster mergeDiff(Cluster other, boolean defaultValues) {
        Builder<?, ?> builder = OnPremCluster.builder();
        super.mergeDiff(builder, other, defaultValues);
        return builder.build();
    }

    public Cluster filterNonNullFields(Cluster filter) {
        Builder<?, ?> builder = OnPremCluster.builder();
        super.filterNonNullFields(builder, filter);
        return builder.build();
    }

    public Cluster simplifiedForBilling() {
        Builder<?, ?> builder = OnPremCluster.builder();
        super.simplifiedForBilling(builder);
        return builder.build();
    }

    public String getZkServerHosts() {
        ZooKeeper zooKeeper = this.getZooKeeper();
        if (zooKeeper == null || zooKeeper instanceof ManagedZooKeeper) {
            throw new UnsupportedOperationException();
        }
        if (zooKeeper instanceof ExternalZooKeeper) {
            return ((ExternalZooKeeper)zooKeeper).getHosts();
        }
        throw new ISE("Unsupported ZooKeeper configuration [%s]", new Object[]{zooKeeper.getClass().getSimpleName()});
    }

    public boolean isEmpty() {
        return super.isEmpty();
    }

    public static Builder<?, ?> builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B, C>, C extends OnPremCluster>
    extends Cluster.Builder<B, C> {
        protected Builder() {
        }

        public B withCluster(Cluster cluster, boolean merge) {
            super.withCluster(cluster, merge);
            return (B)((Object)((Builder)this.getSubclass()));
        }

        public B withoutNonUpdatableFields() {
            super.withoutNonUpdatableFields();
            return (B)((Object)((Builder)this.getSubclass()));
        }

        public B withDefaultsForUnset(ApplicationConfig applicationConfig, boolean setCreationOnlyDefaults, InstanceTypeHelper instanceTypeHelper) {
            if (setCreationOnlyDefaults) {
                if (this.useTls == null) {
                    this.useTls = applicationConfig.useTls();
                }
                if (this.useAuthentication == null) {
                    this.useAuthentication = applicationConfig.useAuthentication();
                }
                if (this.pivot == null && applicationConfig.isKubernetesMode()) {
                    this.pivot = new Pivot(Pivot.Type.PROXIED, null, null, null);
                }
            }
            super.withDefaultsForUnset(applicationConfig, setCreationOnlyDefaults, instanceTypeHelper);
            return (B)((Object)((Builder)this.getSubclass()));
        }

        public C build() {
            return (C)((Object)new OnPremCluster(this.accountId, this.clusterId, this.name, this.implyVersion, this.masterInstanceType, this.queryInstanceType, null, this.masterInstanceCount, this.queryInstanceCount, null, this.version, this.logRetentionDays, this.metadataStorage, null, this.customDruidProperties, this.clusterNumber, this.created, this.lastModified, null, this.createdBy, this.modifiedBy, this.comments, this.configServerKey, this.implyBundleId, this.implyVersionFull, this.userExtensions, this.extensionLoadList, this.securityConfiguration, null, this.customFiles, null, this.deepStorage, this.encryptDataVolumes, this.dataInstanceTiers, this.featureFlags, this.userTags, this.zooKeeper, this.metadata, this.useTls, this.useAuthentication, this.pivot, this.deletionProtection, this.stopProtection, this.mapbox, this.otelCollector));
        }
    }
}

