/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.config.CreationAgentConfig;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.manager.InfoRouteManager;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.DefaultsAndSupportedValues;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.ServiceTier;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.model.druid.AzureDeepStorage;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.model.druid.GCSDeepStorage;
import io.imply.cloud.model.druid.HdfsDeepStorage;
import io.imply.cloud.model.druid.LocalDeepStorage;
import io.imply.cloud.model.druid.S3DeepStorage;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.metadatastorage.MySqlMetadataStorage;
import io.imply.cloud.model.metadatastorage.PostgreSqlMetadataStorage;
import io.imply.cloud.model.zookeeper.ExternalZooKeeper;
import io.imply.cloud.model.zookeeper.ZooKeeper;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.ImplyVersionHelper;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class OnPremInfoRouteManager
extends InfoRouteManager {
    private final DefaultsConfig defaultsConfig;
    private final ObjectMapper objectMapper;
    private final ConfigServerConfig configServerConfig;

    @Inject
    public OnPremInfoRouteManager(ClusterDataManager clusterDataManager, CreationAgentConfig creationAgentConfig, DefaultsConfig defaultsConfig, ApplicationConfig applicationConfig, ObjectMapper objectMapper, ConfigServerConfig configServerConfig, ImplyVersionHelper implyVersionHelper, AccountDataManager accountDataManager, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) {
        super(clusterDataManager, creationAgentConfig, applicationConfig, implyVersionHelper, accountDataManager, refreshableConstants, instanceTypeHelper, null);
        this.defaultsConfig = defaultsConfig;
        this.objectMapper = objectMapper;
        this.configServerConfig = configServerConfig;
    }

    public DefaultsAndSupportedValues getDefaultsAndSupportedValues(String accountId) {
        String clusterId = UUID.randomUUID().toString();
        return new DefaultsAndSupportedValues(this.getDefaultClusterSpec(clusterId, String.format("druid_%s", clusterId.substring(0, 8))), null, null, null, null, this.implyVersionHelper.getSupportedImplyVersionsIncludingAccountVersions(accountId, this.clusterDataManager), this.refreshableConstants.getDruidExtensions(), Constants.SUPPORTED_TARBALL_EXTENSIONS, null);
    }

    public Cluster getDefaultClusterSpec(String clusterId, String shortClusterId) {
        ImplyVersion implyVersion = this.defaultsConfig.getImplyVersionFull();
        if (implyVersion == null) {
            String versionString = this.defaultsConfig.getImplyVersion();
            if (Strings.isNullOrEmpty((String)versionString)) {
                List supportedImplyVersions = this.implyVersionHelper.getSupportedImplyVersionsIncludingAccountVersions(null, this.clusterDataManager);
                implyVersion = ImplyVersionHelper.getDefaultVersion((List)supportedImplyVersions);
                if (implyVersion == null) {
                    throw new ISE("No Imply versions have been registered", new Object[0]);
                }
            } else {
                implyVersion = this.refreshableConstants.lookupImplyVersion(versionString);
                if (implyVersion == null) {
                    throw new IAE("The Imply version [%s] specified via configuration is not a known version", new Object[]{versionString});
                }
            }
        }
        if (!implyVersion.isValid()) {
            throw new IAE("The Imply version specified via configuration does not contain all necessary fields", new Object[0]);
        }
        MySqlMetadataStorage metadataStorage = null;
        if ("mysql".equalsIgnoreCase(this.defaultsConfig.getMetadataStorageType())) {
            metadataStorage = new MySqlMetadataStorage(this.defaultsConfig.getMetadataStorageHost(), this.defaultsConfig.getMetadataStoragePort(), this.defaultsConfig.getMetadataStorageSchema() != null ? this.defaultsConfig.getMetadataStorageSchema() : shortClusterId, this.defaultsConfig.getMetadataStorageUser(), this.defaultsConfig.getMetadataStoragePassword() != null ? "{secret}" : null, this.defaultsConfig.getMetadataStorageTlsCert(), this.defaultsConfig.getMetadataStorageClientCert(), this.defaultsConfig.getMetadataStorageClientKey(), this.configServerConfig);
        } else if ("postgresql".equalsIgnoreCase(this.defaultsConfig.getMetadataStorageType())) {
            metadataStorage = new PostgreSqlMetadataStorage(this.defaultsConfig.getMetadataStorageHost(), this.defaultsConfig.getMetadataStoragePort(), this.defaultsConfig.getMetadataStorageSchema() != null ? this.defaultsConfig.getMetadataStorageSchema() : shortClusterId, this.defaultsConfig.getMetadataStorageUser(), this.defaultsConfig.getMetadataStoragePassword() != null ? "{secret}" : null, this.defaultsConfig.getMetadataStorageTlsCert(), this.defaultsConfig.getMetadataStorageClientCert(), this.defaultsConfig.getMetadataStorageClientKey(), this.configServerConfig);
        }
        ExternalZooKeeper zk = new ExternalZooKeeper(this.defaultsConfig.getZkHosts(), this.defaultsConfig.getZkBasePath() != null ? String.format("%s/%s", this.defaultsConfig.getZkBasePath(), shortClusterId) : shortClusterId);
        HdfsDeepStorage deepStorage = null;
        if ("s3".equalsIgnoreCase(this.defaultsConfig.getDeepStorageType())) {
            String s3Location = this.defaultsConfig.getDeepStoragePath() == null ? null : String.format("%s/%s", StringUtils.stripTrailingSlashes((String)this.defaultsConfig.getDeepStoragePath()), shortClusterId);
            deepStorage = new S3DeepStorage(s3Location, null, this.defaultsConfig.getDeepStorageUser(), this.defaultsConfig.getDeepStoragePassword() != null ? "{secret}" : null);
        } else if ("hdfs".equalsIgnoreCase(this.defaultsConfig.getDeepStorageType())) {
            deepStorage = new HdfsDeepStorage(this.defaultsConfig.getDeepStoragePath() == null ? null : String.format("%s/%s", StringUtils.stripTrailingSlashes((String)this.defaultsConfig.getDeepStoragePath()), shortClusterId));
        } else if ("local".equalsIgnoreCase(this.defaultsConfig.getDeepStorageType())) {
            deepStorage = new LocalDeepStorage(this.defaultsConfig.getDeepStoragePath() == null ? null : String.format("%s/%s", StringUtils.stripTrailingSlashes((String)this.defaultsConfig.getDeepStoragePath()), shortClusterId));
        } else if ("google".equalsIgnoreCase(this.defaultsConfig.getDeepStorageType())) {
            deepStorage = new GCSDeepStorage(this.defaultsConfig.getDeepStoragePath() == null ? null : String.format("%s/%s", StringUtils.stripTrailingSlashes((String)this.defaultsConfig.getDeepStoragePath()), shortClusterId), this.defaultsConfig.getDeepStoragePassword());
        } else if ("azure".equalsIgnoreCase(this.defaultsConfig.getDeepStorageType())) {
            deepStorage = new AzureDeepStorage(this.defaultsConfig.getDeepStorageUser(), this.defaultsConfig.getDeepStoragePassword(), this.defaultsConfig.getDeepStoragePath() == null ? null : String.format("azure://%s/%s", StringUtils.stripTrailingSlashes((String)this.defaultsConfig.getDeepStoragePath()), shortClusterId), this.defaultsConfig.getDeepStorageUseAzureCredentialsChain(), null);
        }
        return this.getDefaultCluster(clusterId, implyVersion, (MetadataStorage)metadataStorage, (ZooKeeper)zk, (DeepStorage)deepStorage, FeatureFlag.getEnabledByDefaultForImplyVersionStringList((ImplyVersion)implyVersion, (ApplicationConfig)this.applicationConfig, (RefreshableConstants)this.refreshableConstants), this.defaultsConfig.getUserExtensions(), this.defaultsConfig.getCustomFiles());
    }

    protected OnPremCluster getDefaultCluster(String clusterId, ImplyVersion implyVersion, MetadataStorage metadataStorage, ZooKeeper zk, DeepStorage deepStorage, List<String> featureFlags, Map<String, String> userExtensions, List<UserFile> customFiles) {
        return ((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)((OnPremCluster.Builder)OnPremCluster.builder().withClusterId(clusterId)).withImplyVersion(implyVersion.getVersion())).withImplyVersionFull(implyVersion)).withMetadataStorage(metadataStorage)).withZooKeeper(zk)).withDeepStorage(deepStorage)).withFeatureFlags(featureFlags)).withCustomDruidProperties(this.getDefaultCustomDruidProperties())).withUserExtensions(userExtensions)).withCustomFiles(customFiles)).withDefaultsForUnset(this.applicationConfig, true, this.instanceTypeHelper).withSensitiveFieldsMasked()).build();
    }

    private Map<String, String> getDefaultCustomDruidProperties() {
        ArrayList<String> coordinator = new ArrayList<String>();
        coordinator.add(String.format("jvm.config.xms=-Xms%dm", this.defaultsConfig.getCoordinatorJvmHeapMb()));
        coordinator.add(String.format("jvm.config.xmx=-Xmx%dm", this.defaultsConfig.getCoordinatorJvmHeapMb()));
        ArrayList<String> overlord = new ArrayList<String>();
        overlord.add(String.format("jvm.config.xms=-Xms%dm", this.defaultsConfig.getOverlordJvmHeapMb()));
        overlord.add(String.format("jvm.config.xmx=-Xmx%dm", this.defaultsConfig.getOverlordJvmHeapMb()));
        ArrayList<String> broker = new ArrayList<String>();
        broker.add(String.format("jvm.config.xms=-Xms%dm", this.defaultsConfig.getBrokerJvmHeapMb()));
        broker.add(String.format("jvm.config.xmx=-Xmx%dm", this.defaultsConfig.getBrokerJvmHeapMb()));
        broker.add(String.format("druid.processing.buffer.sizeBytes=%d", this.defaultsConfig.getProcessingBufferBytes()));
        broker.add(String.format("druid.processing.numThreads=%d", this.defaultsConfig.getProcessingThreads()));
        ArrayList<String> router = new ArrayList<String>();
        router.add(String.format("jvm.config.xms=-Xms%dm", this.defaultsConfig.getRouterJvmHeapMb()));
        router.add(String.format("jvm.config.xmx=-Xmx%dm", this.defaultsConfig.getRouterJvmHeapMb()));
        ArrayList<String> historical = new ArrayList<String>();
        historical.add(String.format("jvm.config.xms=-Xms%dm", this.defaultsConfig.getHistoricalJvmHeapMb()));
        historical.add(String.format("jvm.config.xmx=-Xmx%dm", this.defaultsConfig.getHistoricalJvmHeapMb()));
        historical.add(String.format("druid.processing.buffer.sizeBytes=%d", this.defaultsConfig.getProcessingBufferBytes()));
        historical.add(String.format("druid.processing.numThreads=%d", this.defaultsConfig.getProcessingThreads()));
        historical.add(String.format("druid.segmentCache.locations=%s", this.defaultsConfig.getSegmentCacheLocations()));
        historical.add(String.format("druid.server.maxSize=%d", this.defaultsConfig.getSegmentCacheSizeBytes()));
        historical.add("druid.historical.cache.useCache=true");
        historical.add("druid.historical.cache.populateCache=true");
        historical.add(String.format("druid.cache.sizeInBytes=%d", this.defaultsConfig.getCacheSizeBytes()));
        ArrayList<String> middleManager = new ArrayList<String>();
        middleManager.add(String.format("jvm.config.xms=-Xms%dm", this.defaultsConfig.getMiddleManagerJvmHeapMb()));
        middleManager.add(String.format("jvm.config.xmx=-Xmx%dm", this.defaultsConfig.getMiddleManagerJvmHeapMb()));
        middleManager.add(String.format("druid.worker.capacity=%d", this.defaultsConfig.getWorkerCapacity()));
        middleManager.add("druid.indexer.runner.javaOpts=-server -Xmx2g -Duser.timezone=UTC -Dfile.encoding=UTF-8 -XX:+IgnoreUnrecognizedVMOptions -XX:MaxDirectMemorySize=3g -XX:+PrintGC -XX:+PrintGCDateStamps -XX:+ExitOnOutOfMemoryError -XX:+HeapDumpOnOutOfMemoryError -Djava.util.logging.manager=org.apache.logging.log4j.jul.LogManager -Daws.region=us-east-1");
        middleManager.add(String.format("druid.processing.buffer.sizeBytes=%d", this.defaultsConfig.getProcessingBufferBytes()));
        middleManager.add(String.format("druid.processing.numThreads=%d", this.defaultsConfig.getProcessingThreads()));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(ServiceType.COORDINATOR.getName(), Joiner.on((char)'\n').join(coordinator));
        properties.put(ServiceType.OVERLORD.getName(), Joiner.on((char)'\n').join(overlord));
        properties.put(ServiceType.BROKER.getName(), Joiner.on((char)'\n').join(broker));
        properties.put(ServiceType.ROUTER.getName(), Joiner.on((char)'\n').join(router));
        properties.put(ServiceType.HISTORICAL.getName(), Joiner.on((char)'\n').join(historical));
        properties.put(ServiceType.MIDDLE_MANAGER.getName(), Joiner.on((char)'\n').join(middleManager));
        if (this.defaultsConfig.getCommonCustomDruidProperties() != null) {
            properties.put(ServiceType.COMMON.getName(), this.defaultsConfig.getCommonCustomDruidProperties());
        }
        if (this.defaultsConfig.getCoordinatorCustomDruidProperties() != null) {
            properties.put(ServiceType.COORDINATOR.getName(), this.defaultsConfig.getCoordinatorCustomDruidProperties());
        }
        if (this.defaultsConfig.getOverlordCustomDruidProperties() != null) {
            properties.put(ServiceType.OVERLORD.getName(), this.defaultsConfig.getOverlordCustomDruidProperties());
        }
        if (this.defaultsConfig.getHistoricalCustomDruidProperties() != null) {
            properties.put(ServiceType.HISTORICAL.getName(), this.defaultsConfig.getHistoricalCustomDruidProperties());
        }
        if (this.defaultsConfig.getHistoricalTier1CustomDruidProperties() != null) {
            properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.HISTORICAL, (ServiceTier)ServiceTier.TIER_1), this.defaultsConfig.getHistoricalTier1CustomDruidProperties());
        }
        if (this.defaultsConfig.getHistoricalTier2CustomDruidProperties() != null) {
            properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.HISTORICAL, (ServiceTier)ServiceTier.TIER_2), this.defaultsConfig.getHistoricalTier2CustomDruidProperties());
        }
        if (this.defaultsConfig.getHistoricalTier3CustomDruidProperties() != null) {
            properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.HISTORICAL, (ServiceTier)ServiceTier.TIER_3), this.defaultsConfig.getHistoricalTier3CustomDruidProperties());
        }
        if (this.defaultsConfig.getAdditionalDataTierHistoricalRuntimeProperties() != null) {
            this.defaultsConfig.getAdditionalDataTierHistoricalRuntimeProperties().entrySet().forEach(entry -> properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.HISTORICAL, (ServiceTier)ServiceTier.fromInteger((int)Integer.parseInt((String)entry.getKey()))), (String)entry.getValue()));
        }
        if (this.defaultsConfig.getMiddleManagerCustomDruidProperties() != null) {
            properties.put(ServiceType.MIDDLE_MANAGER.getName(), this.defaultsConfig.getMiddleManagerCustomDruidProperties());
        }
        if (this.defaultsConfig.getMiddleManagerTier1CustomDruidProperties() != null) {
            properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER, (ServiceTier)ServiceTier.TIER_1), this.defaultsConfig.getMiddleManagerTier1CustomDruidProperties());
        }
        if (this.defaultsConfig.getMiddleManagerTier2CustomDruidProperties() != null) {
            properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER, (ServiceTier)ServiceTier.TIER_2), this.defaultsConfig.getMiddleManagerTier2CustomDruidProperties());
        }
        if (this.defaultsConfig.getMiddleManagerTier3CustomDruidProperties() != null) {
            properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER, (ServiceTier)ServiceTier.TIER_3), this.defaultsConfig.getMiddleManagerTier3CustomDruidProperties());
        }
        if (this.defaultsConfig.getAdditionalDataTierMiddleManagerRuntimeProperties() != null) {
            this.defaultsConfig.getAdditionalDataTierMiddleManagerRuntimeProperties().entrySet().forEach(entry -> properties.put(DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)ServiceType.MIDDLE_MANAGER, (ServiceTier)ServiceTier.fromInteger((int)Integer.parseInt((String)entry.getKey()))), (String)entry.getValue()));
        }
        if (this.defaultsConfig.getBrokerCustomDruidProperties() != null) {
            properties.put(ServiceType.BROKER.getName(), this.defaultsConfig.getBrokerCustomDruidProperties());
        }
        if (this.defaultsConfig.getRouterCustomDruidProperties() != null) {
            properties.put(ServiceType.ROUTER.getName(), this.defaultsConfig.getRouterCustomDruidProperties());
        }
        if (this.defaultsConfig.getPivotCustomDruidProperties() != null) {
            properties.put(ServiceType.PIVOT.getName(), this.defaultsConfig.getPivotCustomDruidProperties());
        }
        return properties;
    }

    @Generated
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

