/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.manager;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.imply.cloud.concurrent.ScheduledExecutorFactory;
import io.imply.cloud.concurrent.ScheduledExecutors;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.guice.annotations.Self;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.ManagerRunnable;
import io.imply.cloud.manager.NoticeManager;
import io.imply.cloud.onprem.manager.KubernetesLeaderElectorWrapper;
import io.imply.cloud.server.ApplicationNode;
import io.imply.cloud.server.kubernetes.KubernetesLeaderConfig;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import io.imply.telemetry.Event;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.joda.time.Duration;

@ManageLifecycle
public class KubernetesManagerLeader
implements ManagerLeader {
    @Generated
    private static final Logger log = Logger.from(KubernetesManagerLeader.class);
    private final ApplicationNode self;
    private final ManagerConfig config;
    private final NoticeManager noticeManager;
    private final MetricRegistry metricRegistry;
    private final ScheduledExecutorService exec;
    private final AtomicReference<KubernetesLeaderElectorWrapper> leaderElector;
    private final KubernetesLeaderConfig kubernetesLeaderConfig;
    private volatile boolean leader = false;
    private AtomicInteger leaderCounter = new AtomicInteger();
    private boolean started = false;

    @Inject
    public KubernetesManagerLeader(ScheduledExecutorFactory scheduledExecutorFactory, @Self ApplicationNode self, ManagerConfig config, NoticeManager noticeManager, MetricRegistry metricRegistry, KubernetesLeaderConfig kubernetesLeaderConfig) {
        this.self = self;
        this.config = config;
        this.noticeManager = noticeManager;
        this.metricRegistry = metricRegistry;
        this.kubernetesLeaderConfig = kubernetesLeaderConfig;
        this.exec = scheduledExecutorFactory.create(1, "KubernetesManagerLeader-Exec-%d");
        this.leaderElector = new AtomicReference<Object>(null);
    }

    @LifecycleStart
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.createNewLeaderElector();
        try {
            this.leaderElector.get().run();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.metricRegistry.register(Event.name((String)MetricRegistry.name(KubernetesManagerLeader.class, (String[])new String[]{"leader"}), (String[])new String[0]), (Metric)((Gauge)() -> this.isLeader() ? 1 : 0));
    }

    @LifecycleStop
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.leaderElector.get().close();
        this.started = false;
        this.exec.shutdownNow();
    }

    public boolean isLeader() {
        return this.leader;
    }

    public String getCurrentLeader() {
        return this.leaderElector.get().getCurrentLeader();
    }

    private synchronized void becomeLeader() {
        if (!this.started) {
            return;
        }
        if (this.isLeader()) {
            log.warn("I'm being asked to become leader. But I am already the leader. Ignored event.");
            return;
        }
        log.info("I am the leader of the managers, all must bow!");
        log.info("Starting management in [%s]", new Object[]{this.config.getStartupDelay().toStandardDuration()});
        try {
            this.leader = true;
            final int startingLeaderCounter = this.leaderCounter.incrementAndGet();
            ArrayList managerRunnables = Lists.newArrayList();
            managerRunnables.add(Pair.of((Object)((Object)new KubernetesManagerLeaderRunnable(startingLeaderCounter)), (Object)this.config.getManagementPeriod().toStandardDuration()));
            for (final Pair managerRunnable : managerRunnables) {
                ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getStartupDelay().toStandardDuration(), (Duration)((Duration)managerRunnable.rhs), (Callable)new Callable<ScheduledExecutors.Signal>(){
                    private final KubernetesManagerLeaderRunnable theRunnable;
                    {
                        this.theRunnable = (KubernetesManagerLeaderRunnable)((Object)managerRunnable.lhs);
                    }

                    @Override
                    public ScheduledExecutors.Signal call() {
                        if (KubernetesManagerLeader.this.isLeader() && startingLeaderCounter == KubernetesManagerLeader.this.leaderCounter.get()) {
                            this.theRunnable.run();
                        }
                        if (KubernetesManagerLeader.this.isLeader() && startingLeaderCounter == KubernetesManagerLeader.this.leaderCounter.get()) {
                            return ScheduledExecutors.Signal.REPEAT;
                        }
                        return ScheduledExecutors.Signal.STOP;
                    }
                });
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to become leader");
            KubernetesLeaderElectorWrapper oldLeaderElector = this.createNewLeaderElector();
            oldLeaderElector.close();
            try {
                this.leaderElector.get().run();
            }
            catch (Exception e1) {
                log.error((Throwable)e1, "Unable to become leader again");
            }
        }
    }

    private synchronized void stopBeingLeader() {
        if (!this.isLeader()) {
            log.warn("I'm being asked give up leadership. But I am NOT the leader. Ignored event.");
            return;
        }
        this.leaderCounter.incrementAndGet();
        this.leader = false;
        log.info("I am no longer the leader...");
    }

    private void onLeaderChange(String newLeaderName) {
        log.info("Leader changed to [%s]", new Object[]{newLeaderName});
    }

    private KubernetesLeaderElectorWrapper createNewLeaderElector() {
        KubernetesLeaderElectorWrapper newLeaderElector = new KubernetesLeaderElectorWrapper(this.self.getHostAndPort(), this.kubernetesLeaderConfig, this::becomeLeader, this::stopBeingLeader, this::onLeaderChange);
        return this.leaderElector.getAndSet(newLeaderElector);
    }

    public class KubernetesManagerLeaderRunnable
    extends ManagerRunnable {
        private final int startingLeaderCounter;

        protected KubernetesManagerLeaderRunnable(int startingLeaderCounter) {
            super(KubernetesManagerLeader.this.noticeManager);
            this.startingLeaderCounter = startingLeaderCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                KubernetesManagerLeader kubernetesManagerLeader = KubernetesManagerLeader.this;
                synchronized (kubernetesManagerLeader) {
                    KubernetesLeaderElectorWrapper elector = KubernetesManagerLeader.this.leaderElector.get();
                    if (elector == null || !KubernetesManagerLeader.this.isLeader()) {
                        log.info("LEGGO MY EGGO. [%s] is leader.", new Object[]{elector == null ? null : KubernetesManagerLeader.this.getCurrentLeader()});
                        KubernetesManagerLeader.this.stopBeingLeader();
                        return;
                    }
                }
                if (KubernetesManagerLeader.this.isLeader() && this.startingLeaderCounter == KubernetesManagerLeader.this.leaderCounter.get()) {
                    super.run();
                }
            }
            catch (Throwable e) {
                log.error(e, "Caught exception, ignoring so that schedule keeps going.");
            }
        }
    }
}

