/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.manager;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.manager.stage.AwaitMiddleManagerIdleStage;
import io.imply.cloud.manager.stage.AwaitSegmentsAvailableStage;
import io.imply.cloud.manager.stage.DisableMiddleManagerStage;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.UpdateType;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import lombok.Generated;

@Path(value="/druid/v1/{clusterId}")
public class DruidResource {
    private final ManagerToolbox toolbox;

    @POST
    @Path(value="worker/{host}/disable")
    @Produces(value={"application/json"})
    public StatusResponse disableMiddleManager(@PathParam(value="clusterId") String clusterId, @PathParam(value="host") String host) {
        if (!this.isClusterRunning(clusterId)) {
            return StatusResponse.NOT_RUNNING;
        }
        if (this.isClusterHardUpdating(clusterId)) {
            return StatusResponse.HARD_UPDATE;
        }
        new DisableMiddleManagerStage(this.toolbox, clusterId, null, host, this.getMasterHosts(clusterId)).innerRun();
        return StatusResponse.COMPLETED;
    }

    @GET
    @Path(value="worker/{host}/tasks")
    @Produces(value={"application/json"})
    public StatusResponse getMiddleManagerTasks(@PathParam(value="clusterId") String clusterId, @PathParam(value="host") String host) {
        if (!this.isClusterRunning(clusterId)) {
            return StatusResponse.NOT_RUNNING;
        }
        if (this.isClusterHardUpdating(clusterId)) {
            return StatusResponse.HARD_UPDATE;
        }
        boolean value = new AwaitMiddleManagerIdleStage(this.toolbox, clusterId, null, host, this.getMasterHosts(clusterId)).innerRun();
        return StatusResponse.fromStageReturn(value);
    }

    @GET
    @Path(value="coordinator/loadstatus")
    @Produces(value={"application/json"})
    public StatusResponse getFullLoadStatus(@PathParam(value="clusterId") String clusterId, @QueryParam(value="startTime") Long startTime) {
        if (!this.isClusterRunning(clusterId)) {
            return StatusResponse.NOT_RUNNING;
        }
        if (this.isClusterHardUpdating(clusterId)) {
            return StatusResponse.HARD_UPDATE;
        }
        AwaitSegmentsAvailableStage stage = new AwaitSegmentsAvailableStage(this.toolbox, clusterId, null, this.getMasterHosts(clusterId), null);
        stage.setComputeUsingClusterView(Boolean.valueOf(false));
        if (startTime != null) {
            stage.setExecutionCount(Integer.valueOf((int)TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - startTime)));
        }
        return StatusResponse.fromStageReturn(stage.innerRun());
    }

    private boolean isClusterRunning(String clusterId) {
        Info info = this.toolbox.getEntityStateDataManager().get(this.toolbox.getClusterDataManager().get(clusterId));
        return info.getState().isRunning();
    }

    private boolean isClusterHardUpdating(String clusterId) {
        Info info = this.toolbox.getEntityStateDataManager().get(this.toolbox.getClusterDataManager().get(clusterId));
        return UpdateType.HARD.equals((Object)info.getUpdateType());
    }

    private Set<String> getMasterHosts(String clusterId) {
        return ImmutableSet.copyOf((Collection)this.toolbox.getClusterNodesHelper().getSortedMasterHosts(clusterId));
    }

    @Inject
    @Generated
    public DruidResource(ManagerToolbox toolbox) {
        this.toolbox = toolbox;
    }

    public static class StatusResponse {
        private static final StatusResponse NOT_RUNNING = new StatusResponse(Status.NOT_RUNNING);
        private static final StatusResponse HARD_UPDATE = new StatusResponse(Status.HARD_UPDATE);
        private static final StatusResponse PENDING = new StatusResponse(Status.PENDING);
        private static final StatusResponse COMPLETED = new StatusResponse(Status.COMPLETED);
        @JsonProperty
        private final Status status;

        public static StatusResponse fromStageReturn(boolean val) {
            return val ? COMPLETED : PENDING;
        }

        @Generated
        public StatusResponse(Status status) {
            this.status = status;
        }

        @Generated
        public Status getStatus() {
            return this.status;
        }
    }

    public static enum Status {
        NOT_RUNNING,
        HARD_UPDATE,
        PENDING,
        COMPLETED;

    }
}

