/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.configurator;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.FeatureFlags;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.configurator.CertificateCache;
import io.imply.cloud.configurator.authenticator.ClusterAuthConfigurator;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.model.DruidInstanceTypeConfig;
import io.imply.cloud.model.DruidInstanceTypeConfigItem;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.Pivot;
import io.imply.cloud.model.ServiceTier;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.onprem.config.OnPremKubernetesManagerConfig;
import io.imply.cloud.onprem.config.OnPremManagerConfig;
import io.imply.cloud.onprem.configurator.OnPremConfiguratorManager;
import io.imply.cloud.onprem.util.HelmUtils;
import io.imply.cloud.onprem.util.OnPremKubernetesConfigRequestBodyHelper;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.PropertiesHelper;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.ws.rs.core.StreamingOutput;
import lombok.Generated;
import org.apache.commons.codec.digest.MurmurHash3;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OnPremKubernetesConfiguratorManager
extends OnPremConfiguratorManager {
    @Generated
    private static final Logger log = Logger.from(OnPremKubernetesConfiguratorManager.class);
    private static final String CLUSTER_VALUES_YAML = "kubernetes-mode-values.yaml";
    private static final String LINKHOSTNAME_PROXIED_PIVOT_FORMAT = "https://%s/p/%s";
    private static final String DATA_TIER_VALUES_YAML = "data-tier-base-values.yaml";
    private static final List<ImplyNodeType> ALL_NODE_TYPES = ImmutableList.builder().addAll((Iterable)ImplyNodeType.USER_SELECTABLE_NODE_TYPES).add((Object)ImplyNodeType.PEON).build();
    private final JsonNode baseClusterConfig;
    private final JsonNode dataTierValuesConfig;
    protected final OnPremKubernetesManagerConfig onPremKubernetesManagerConfig;
    private final OnPremKubernetesConfigRequestBodyHelper onPremKubernetesConfigRequestBodyHelper;

    @Inject
    public OnPremKubernetesConfiguratorManager(RefreshableConstantsUpdater refreshableConstantsUpdater, RefreshableConstantsConfig refreshableConstantsConfig, AccountDataManager accountDataManager, ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ConfigServerConfig config, CertificateCache certificateCache, SecurityConfig securityConfig, ApplicationConfig applicationConfig, ClusterAuthConfigurator clusterAuthConfigurator, OnPremManagerConfig managerConfig, ClusterNodesHelper clusterNodesHelper, OnPremKubernetesManagerConfig onPremKubernetesManagerConfig, OnPremKubernetesConfigRequestBodyHelper onPremKubernetesConfigRequestBodyHelper, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) throws IOException {
        super(refreshableConstantsUpdater, refreshableConstantsConfig, accountDataManager, clusterDataManager, entityStateDataManager, config, certificateCache, securityConfig, applicationConfig, clusterAuthConfigurator, managerConfig, clusterNodesHelper, refreshableConstants, instanceTypeHelper);
        this.onPremKubernetesManagerConfig = onPremKubernetesManagerConfig;
        this.onPremKubernetesConfigRequestBodyHelper = onPremKubernetesConfigRequestBodyHelper;
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CLUSTER_VALUES_YAML);){
            this.baseClusterConfig = YAML_MAPPER.readTree(in);
        }
        in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(DATA_TIER_VALUES_YAML);
        try {
            this.dataTierValuesConfig = YAML_MAPPER.readTree(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public StreamingOutput generateDruidConfigBundle(ConfigRequestBody configRequestBody) {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(configRequestBody, this.entityStateDataManager);
        return super.generateDruidConfigBundle(this.applicationConfig.isOnPrem() && BooleanUtils.isTrue((Boolean)cluster.isUseTls()) ? this.onPremKubernetesConfigRequestBodyHelper.withPrivateLoadBalancerIp(configRequestBody) : configRequestBody);
    }

    @Override
    protected Map<String, String> getPlatformSpecificDruidProperties(String instanceType, ServiceType serviceType, ComparableVersion comparableVersion, ConfigRequestBody configRequestBody) {
        ImmutableMap.Builder propBuilder = ImmutableMap.builder();
        if (ServiceType.HISTORICAL.equals((Object)serviceType)) {
            propBuilder.put((Object)"druid.historical.cache.useCache", (Object)"true");
            propBuilder.put((Object)"druid.historical.cache.populateCache", (Object)"true");
            propBuilder.put((Object)"druid.cache.type", (Object)"caffeine");
        }
        DruidInstanceTypeConfig configSet = DruidInstanceTypeConfig.getForComparableImplyVersion((ComparableVersion)comparableVersion, (RefreshableConstants)this.getRefreshableConstants());
        DruidInstanceTypeConfigItem typeSpecificConfigs = configSet.getConfigSet().stream().filter(x -> instanceType.equalsIgnoreCase(x.getInstanceType()) && DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)serviceType) != null && DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)serviceType).equalsIgnoreCase(x.getServiceType())).findFirst().orElse(null);
        this.validateTypeSpecificConfigs(typeSpecificConfigs, serviceType, instanceType, comparableVersion, configRequestBody);
        if (typeSpecificConfigs != null && typeSpecificConfigs.getProperties() != null) {
            propBuilder.putAll(typeSpecificConfigs.getProperties());
        }
        return propBuilder.build();
    }

    protected void validateTypeSpecificConfigs(DruidInstanceTypeConfigItem typeSpecificConfigs, ServiceType serviceType, String instanceType, ComparableVersion comparableVersion, ConfigRequestBody configRequestBody) {
    }

    @Override
    protected String appendPlatformSpecificJvmConfig(Cluster cluster, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        return this.appendInstanceSpecificJvmConfig(cluster, instanceType, configFile, configRequestBody).concat("-Daws.region=us-east-1\n");
    }

    public String generateClusterHelmValueOverrides(Cluster cluster, Account account) {
        ObjectNode rootNode = (ObjectNode)this.baseClusterConfig.deepCopy();
        if (this.onPremKubernetesManagerConfig.getIngressHost() != null) {
            this.generateHelmOverridesForIngresses(rootNode, cluster);
        }
        this.maybeGenerateHelmOverridesForTls(rootNode);
        this.generateHelmOverridesForZooKeeper(rootNode, cluster);
        this.generateHelmOverridesForMasterNodes((ObjectNode)rootNode.get("master"), cluster);
        this.generateHelmOverridesForAdditionalDataNodes(rootNode, cluster);
        if (this.applicationConfig.isDevelopmentMode()) {
            rootNode.withObject("/query/lifecycle/preStop/exec").withArray("command").add("echo").add("exiting");
        }
        try {
            return YAML_MAPPER.writeValueAsString((Object)this.applyCommonOverrides(this.generateClusterHelmValueOverridesInternal(rootNode, rootNode, cluster, account), cluster));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectNode applyCommonOverrides(ObjectNode rootNode, Cluster cluster) throws JsonProcessingException {
        Map<String, String> overrides = this.getResourceOverrideMap("common", cluster);
        if (MapUtils.isEmpty(overrides)) {
            return rootNode;
        }
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            if (!entry.getKey().startsWith("helm.")) continue;
            this.addNestedKey(rootNode, entry.getKey().substring("helm.".length()), entry.getValue());
        }
        return rootNode;
    }

    private void addNestedKey(ObjectNode rootNode, String key, String value) throws JsonProcessingException {
        String[] parts = StringUtils.split((String)key, (char)'.');
        JsonPointer pointer = JsonPointer.compile((String)("/" + String.join((CharSequence)"/", Arrays.copyOfRange(parts, 0, parts.length - 1))));
        ObjectNode currentNode = rootNode.withObject(pointer);
        JsonNode parsedValue = (JsonNode)YAML_MAPPER.readValue(value, JsonNode.class);
        currentNode.set(parts[parts.length - 1], parsedValue);
    }

    private void maybeGenerateHelmOverridesForTls(ObjectNode rootNode) {
        if (StringUtils.isBlank((CharSequence)this.onPremKubernetesManagerConfig.getTlsSecretName())) {
            return;
        }
        ObjectNode securityNode = rootNode.withObject("/security");
        securityNode.put("enableLegacyTls", false);
        securityNode.withObject("/tls").put("secretName", this.onPremKubernetesManagerConfig.getTlsSecretName());
        rootNode.withObject("/query/service").put("routerPort", 9088);
        rootNode.withObject("/query/ingress/router/annotations").put("nginx.ingress.kubernetes.io/backend-protocol", "HTTPS");
    }

    @Override
    protected void addPlatformSpecificPivotConfiguration(Map<String, Object> configMap, Cluster cluster, Account account) {
        super.addPlatformSpecificPivotConfiguration(configMap, cluster, account);
        if (StringUtils.isNotBlank((CharSequence)this.onPremKubernetesManagerConfig.getIngressHost()) && (cluster.getPivot() == null || cluster.getPivot().getType() == Pivot.Type.PROXIED)) {
            String linkHostName = String.format(LINKHOSTNAME_PROXIED_PIVOT_FORMAT, this.onPremKubernetesManagerConfig.getIngressHost(), cluster.getClusterId());
            configMap.put("linkHostName", linkHostName);
        }
    }

    @Override
    protected void addPlatformSpecificRuntimeProperties(Properties props, Cluster cluster, Account account, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        super.addPlatformSpecificRuntimeProperties(props, cluster, account, instanceType, configFile, configRequestBody);
        if (this.isImmutableEnabled(cluster) && ServiceType.COMMON.equals((Object)configFile.getServiceType())) {
            props.setProperty("druid.host", "${env:druid_common_runtime_druid_host}");
        }
    }

    protected List<ImplyNodeType> getImplyNodeTypesForCluster(Cluster cluster) {
        ArrayList<ImplyNodeType> nodeTypes = new ArrayList<ImplyNodeType>(ALL_NODE_TYPES);
        cluster.getDataInstanceTiers().keySet().stream().filter(key -> key > 3).map(ImplyNodeType::dataFromTierInteger).forEach(nodeTypes::add);
        return nodeTypes;
    }

    protected ObjectNode generateClusterHelmValueOverridesInternal(ObjectNode rootNode, ObjectNode implyRootNode, Cluster cluster, Account account) {
        ObjectNode agentsNode = YAML_MAPPER.createObjectNode();
        agentsNode.put("clusterName", cluster.getClusterId());
        agentsNode.put("managerHost", this.onPremKubernetesManagerConfig.getManagerServiceName());
        implyRootNode.set("agents", (JsonNode)agentsNode);
        List<ImplyNodeType> nodeTypes = this.getImplyNodeTypesForCluster(cluster);
        nodeTypes.forEach(nodeType -> this.generateHelmOverridesForNodeType(implyRootNode, (ImplyNodeType)nodeType, cluster, account));
        this.generateAgentImageOverride(implyRootNode, cluster);
        return rootNode;
    }

    protected void generateAgentImageOverride(ObjectNode implyRootNode, Cluster cluster) {
        ObjectNode agentImageNode = YAML_MAPPER.createObjectNode();
        if (CollectionUtils.emptyIfNull((Collection)cluster.getFeatureFlags()).contains("useJava17")) {
            agentImageNode.put("tag", "v42-java17");
        }
        if (this.onPremKubernetesManagerConfig.getImplyAgentRegistry() != null) {
            agentImageNode.put("repository", this.onPremKubernetesManagerConfig.getImplyAgentRegistry());
        }
        if (this.onPremKubernetesManagerConfig.getImplyAgentTag() != null) {
            agentImageNode.put("tag", this.onPremKubernetesManagerConfig.getImplyAgentTag());
        }
        if (!agentImageNode.isEmpty()) {
            implyRootNode.set("images", implyRootNode.withObject("images").set("agent", (JsonNode)agentImageNode));
        }
        if (StringUtils.isNotBlank((CharSequence)this.onPremKubernetesManagerConfig.getImagePullSecretsName())) {
            implyRootNode.set("images", implyRootNode.withObject("images").set("imagePullSecrets", (JsonNode)YAML_MAPPER.createArrayNode().add((JsonNode)YAML_MAPPER.createObjectNode().put("name", this.onPremKubernetesManagerConfig.getImagePullSecretsName()))));
        }
    }

    protected void generateHelmOverridesForNodeType(ObjectNode rootNode, ImplyNodeType implyNodeType, Cluster cluster, Account account) {
        int instancePool;
        InstanceType instanceType;
        ObjectNode implyNodeTypeNode = this.getImplyNodeTypeNode(rootNode, implyNodeType);
        switch (implyNodeType.getNodeServiceType()) {
            case MASTER: {
                instanceType = this.getInstanceTypeHelper().lookupInstanceType(implyNodeType, cluster.getMasterInstanceType());
                instancePool = Constants.DRUID_INSTANCE_POOL_DEFAULT;
                break;
            }
            case QUERY: {
                instanceType = this.getInstanceTypeHelper().lookupInstanceType(implyNodeType, cluster.getQueryInstanceType());
                instancePool = Constants.DRUID_INSTANCE_POOL_DEFAULT;
                break;
            }
            case DATA: {
                InstanceTier tier = (InstanceTier)cluster.getDataInstanceTiers().get(implyNodeType.getTierNumber());
                if (tier == null || tier.getInstanceCount() < 0) {
                    return;
                }
                instanceType = this.getInstanceTypeHelper().lookupInstanceType(implyNodeType, tier.getInstanceType());
                instancePool = tier.getInstancePool() == null ? Constants.DRUID_INSTANCE_POOL_DEFAULT : tier.getInstancePool();
                break;
            }
            case PEON: {
                InstanceType instanceType2 = this.getInstanceTypeHelper().lookupInstanceType(ImplyNodeType.MASTER, cluster.getMasterInstanceType());
                this.generateHelmOverridesForPeonTemplates(implyNodeTypeNode, ImplyNodeType.MASTER, instanceType2.getInstanceType(), cluster, account);
                return;
            }
            default: {
                throw new ISE("Invalid nodeType", new Object[0]);
            }
        }
        if (instanceType == null) {
            throw new ISE("Did not find instance type '%s' in list of supported instance types for imply node type '%s'", new Object[]{instanceType, implyNodeType});
        }
        implyNodeTypeNode.put("replicaCount", this.getReplicaCountForNodeType(cluster, implyNodeType));
        ObjectNode nodeSelectorNode = (ObjectNode)YAML_MAPPER.valueToTree((Object)ImmutableMap.of((Object)this.onPremKubernetesManagerConfig.getInstanceTypeNodeSelectorLabel(), (Object)this.generateNodeSelectorValue(instanceType.getInstanceType(), instancePool)));
        implyNodeTypeNode.set("nodeSelector", (JsonNode)nodeSelectorNode);
        if (this.onPremKubernetesManagerConfig.getNodeTolerationKey() != null) {
            ArrayNode tolerationNode = YAML_MAPPER.createArrayNode();
            tolerationNode.add(YAML_MAPPER.valueToTree((Object)ImmutableMap.of((Object)"key", (Object)this.onPremKubernetesManagerConfig.getNodeTolerationKey(), (Object)"operator", (Object)"Exists", (Object)"effect", (Object)"NoExecute")));
            implyNodeTypeNode.set("tolerations", (JsonNode)tolerationNode);
        }
        this.generateHelmOverridesForNode(implyNodeTypeNode, cluster, account, implyNodeType, instanceType.getInstanceType());
        if (implyNodeType.isDataType()) {
            this.generateHelmOverridesForDataNodes(implyNodeTypeNode, implyNodeType, instanceType, cluster);
        }
        this.generateHelmOverridesForServiceType(implyNodeTypeNode, cluster, implyNodeType, instanceType.getInstanceType());
        if (this.onPremKubernetesManagerConfig.getTerminationGracePeriodOverride() != null) {
            implyNodeTypeNode.put("terminationGracePeriodSeconds", this.onPremKubernetesManagerConfig.getTerminationGracePeriodOverride());
        }
    }

    protected void generateHelmOverridesForServiceType(ObjectNode implyNodeTypeNode, Cluster cluster, ImplyNodeType implyNodeType, String instanceType) {
        switch (implyNodeType.getNodeServiceType()) {
            case MASTER: {
                this.generateHelmOverridesForService(implyNodeTypeNode, cluster, implyNodeType, ServiceType.COORDINATOR, instanceType);
                this.generateHelmOverridesForService(implyNodeTypeNode, cluster, implyNodeType, ServiceType.OVERLORD, instanceType);
                break;
            }
            case DATA: {
                this.generateHelmOverridesForService(implyNodeTypeNode, cluster, implyNodeType, ServiceType.HISTORICAL, instanceType);
                this.generateHelmOverridesForService(implyNodeTypeNode, cluster, implyNodeType, ServiceType.MIDDLE_MANAGER, instanceType);
                break;
            }
            case QUERY: {
                this.generateHelmOverridesForService(implyNodeTypeNode, cluster, implyNodeType, ServiceType.BROKER, instanceType);
                this.generateHelmOverridesForService(implyNodeTypeNode, cluster, implyNodeType, ServiceType.ROUTER, instanceType);
                this.generateHelmOverridesForService(implyNodeTypeNode, cluster, implyNodeType, ServiceType.PIVOT, instanceType);
                break;
            }
        }
    }

    private int getReplicaCountForNodeType(Cluster cluster, ImplyNodeType implyNodeType) {
        switch (implyNodeType.getNodeServiceType()) {
            case MASTER: {
                return cluster.getMasterInstanceCount();
            }
            case QUERY: {
                return cluster.getQueryInstanceCount();
            }
            case DATA: {
                InstanceTier tier = (InstanceTier)cluster.getDataInstanceTiers().get(implyNodeType.getTierNumber());
                return tier == null || tier.getInstanceCount() < 0 ? 0 : tier.getInstanceCount();
            }
        }
        throw new ISE("Invalid nodeType", new Object[0]);
    }

    protected void generateHelmOverridesForService(ObjectNode implyNodeTypeNode, Cluster cluster, ImplyNodeType implyNodeType, ServiceType serviceType, String instanceType) {
        if (!this.isImmutableEnabled(cluster)) {
            return;
        }
        ArrayNode druidProcesses = implyNodeTypeNode.withArray("druidProcesses");
        druidProcesses.add(serviceType.getName());
        ObjectNode serviceTypeNode = implyNodeTypeNode.withObject(serviceType.getName());
        if (this.isSingleServicePodsEnabled(cluster, implyNodeType)) {
            serviceTypeNode.put("replicaCount", this.getReplicaCountForNodeType(cluster, implyNodeType));
            serviceTypeNode.withObject("labels").put("imply.io/imply_service_type", serviceType.getName());
        }
        this.addContainerCommandForService(serviceTypeNode, serviceType);
        this.addContainerResources(serviceTypeNode, cluster, implyNodeType, instanceType, serviceType);
    }

    protected void addContainerResources(ObjectNode serviceTypeNode, Cluster cluster, ImplyNodeType implyNodeType, String instanceType, ServiceType serviceType) {
        DruidInstanceTypeConfigItem serviceConfig = DruidInstanceTypeConfig.getForServiceType((String)instanceType, (ServiceType)serviceType, (ComparableVersion)cluster.getImplyVersionFull().getComparableVersion(), (RefreshableConstants)this.getRefreshableConstants());
        String cpuRequest = null;
        String cpuLimit = null;
        String memoryRequest = null;
        String memoryLimit = null;
        if (serviceConfig != null && serviceConfig.getContainerResources() != null) {
            Integer cpuRequestInt = serviceConfig.getContainerResources().getCpuRequest();
            Integer cpuLimitInt = serviceConfig.getContainerResources().getCpuLimit();
            Integer memoryLimitInt = serviceConfig.getContainerResources().getMemoryLimit();
            if (FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.SURGE_MASTER_QUERY_PODS, (RefreshableConstants)this.getRefreshableConstants()) && ImmutableList.of((Object)ImplyNodeType.ImplyNodeServiceType.MASTER, (Object)ImplyNodeType.ImplyNodeServiceType.QUERY).contains((Object)implyNodeType.getNodeServiceType()) && Objects.equals(cpuRequestInt, cpuLimitInt) && cpuLimitInt != null) {
                cpuRequestInt = cpuRequestInt / 2;
                cpuLimitInt = cpuLimitInt * 2;
            }
            cpuRequest = String.format("%dm", cpuRequestInt);
            if (cpuLimitInt != null) {
                cpuLimit = String.format("%dm", cpuLimitInt);
            }
            memoryRequest = String.format("%dM", serviceConfig.getContainerResources().getMemoryRequest());
            if (memoryLimitInt != null) {
                memoryLimit = String.format("%dM", memoryLimitInt);
            }
        }
        cpuRequest = (String)ObjectUtils.defaultIfNull((Object)this.getResourceOverride("container.resources.requests.cpu", cluster, implyNodeType, serviceType), cpuRequest);
        cpuLimit = (String)ObjectUtils.defaultIfNull((Object)this.getResourceOverride("container.resources.limits.cpu", cluster, implyNodeType, serviceType), cpuLimit);
        memoryRequest = (String)ObjectUtils.defaultIfNull((Object)this.getResourceOverride("container.resources.requests.memory", cluster, implyNodeType, serviceType), memoryRequest);
        memoryLimit = (String)ObjectUtils.defaultIfNull((Object)this.getResourceOverride("container.resources.limits.memory", cluster, implyNodeType, serviceType), memoryLimit);
        if (StringUtils.isBlank((CharSequence)cpuRequest) || StringUtils.isBlank((CharSequence)memoryRequest)) {
            return;
        }
        serviceTypeNode.withObject("resources").withObject("requests").put("cpu", cpuRequest);
        if (!StringUtils.isBlank((CharSequence)cpuLimit)) {
            serviceTypeNode.withObject("resources").withObject("limits").put("cpu", cpuLimit);
        }
        serviceTypeNode.withObject("resources").withObject("requests").put("memory", memoryRequest);
        if (!StringUtils.isBlank((CharSequence)memoryLimit)) {
            serviceTypeNode.withObject("resources").withObject("limits").put("memory", memoryLimit);
        }
    }

    private String getResourceOverride(String key, Cluster cluster, ImplyNodeType implyNodeType, ServiceType serviceType) {
        String serviceTierKey = DruidConfigFile.getCustomDruidPropertiesKey((ServiceType)serviceType, implyNodeType.isDataType() ? ServiceTier.fromInteger((int)implyNodeType.getTierNumber()) : null);
        return this.getResourceOverrideMap(serviceTierKey, cluster).getOrDefault(key, null);
    }

    private Map<String, String> getResourceOverrideMap(String key, Cluster cluster) {
        String overrides = (String)MapUtils.emptyIfNull((Map)cluster.getCustomDruidProperties()).get(key);
        if (StringUtils.isBlank((CharSequence)overrides)) {
            return ImmutableMap.of();
        }
        return PropertiesHelper.convertPropertiesFileToMap((String)overrides);
    }

    protected void addContainerCommandForService(ObjectNode serviceTypeNode, ServiceType serviceType) {
        ArrayNode command = serviceTypeNode.withArray("command");
        if (ServiceType.PIVOT.equals((Object)serviceType)) {
            command.add("/run-pivot");
            command.add("/opt/imply/conf");
        } else {
            command.add("/run-druid");
            command.add("-i");
            command.add(serviceType.getName());
            command.add("/opt/imply/conf");
        }
    }

    protected ObjectNode getImplyNodeTypeNode(ObjectNode rootNode, ImplyNodeType implyNodeType) {
        if (ALL_NODE_TYPES.contains(implyNodeType)) {
            return (ObjectNode)rootNode.get(implyNodeType.camelCasedName());
        }
        ArrayNode additionalDataTiers = (ArrayNode)rootNode.get("additionalDataTiers");
        return (ObjectNode)additionalDataTiers.get(implyNodeType.getTierNumber() - 4);
    }

    protected String generateNodeSelectorValue(String instanceType, Integer instancePool) {
        if (instancePool == null || instancePool.equals(Constants.DRUID_INSTANCE_POOL_DEFAULT)) {
            return instanceType;
        }
        return String.format("%s-pool-%s", instanceType, instancePool);
    }

    protected void generateHelmOverridesForNode(ObjectNode implyNodeTypeNode, Cluster cluster, Account account, ImplyNodeType implyNodeType, String instanceType) {
        ArrayNode extraEnv = implyNodeTypeNode.withArray("extraEnv");
        ObjectNode instanceTypeNode = YAML_MAPPER.createObjectNode();
        instanceTypeNode.put("name", "IMPLY_MANAGER_AGENT_INSTANCE_TYPE");
        instanceTypeNode.put("value", instanceType);
        ObjectNode groveKeyNode = YAML_MAPPER.createObjectNode();
        groveKeyNode.put("name", "IMPLY_CONFIG_SERVER_KEY");
        groveKeyNode.put("value", cluster.getConfigServerKey());
        ObjectNode userInitPathNode = YAML_MAPPER.createObjectNode();
        userInitPathNode.put("name", "IMPLY_AGENT_SETUP_SERVICE_COMMAND");
        userInitPathNode.put("value", "/root/become-druid");
        if (StringUtils.isNotBlank((CharSequence)this.onPremKubernetesManagerConfig.getTlsSecretName())) {
            extraEnv.add((JsonNode)YAML_MAPPER.createObjectNode().put("name", "IMPLY_BECOME_DRUID_HTTPS").put("value", "true"));
        }
        extraEnv.add((JsonNode)instanceTypeNode);
        extraEnv.add((JsonNode)groveKeyNode);
        extraEnv.add((JsonNode)userInitPathNode);
        if (this.isImmutableEnabled(cluster)) {
            implyNodeTypeNode.withObject("labels").put("imply.io/imply_node_type", implyNodeType.camelCasedName());
            ObjectNode immutableContainer = YAML_MAPPER.createObjectNode();
            immutableContainer.put("name", "IMPLY_IMMUTABLE_CONTAINER");
            immutableContainer.put("value", "true");
            extraEnv.add((JsonNode)immutableContainer);
            try {
                if (this.isSingleServicePodsEnabled(cluster, implyNodeType)) {
                    implyNodeTypeNode.put("singleServicePods", true);
                    this.generateConfigRequestBodyConfigsForServiceType(implyNodeTypeNode, cluster, account, implyNodeType, instanceType);
                } else {
                    this.generateConfigRequestBodyConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to generate config request body configs for %s", implyNodeType));
            }
        }
    }

    protected void generateConfigRequestBodyConfigsForServiceType(ObjectNode implyNodeTypeNode, Cluster cluster, Account account, ImplyNodeType implyNodeType, String instanceType) throws IOException {
        switch (implyNodeType.getNodeServiceType()) {
            case MASTER: {
                this.generateConfigRequestBodyConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType, ServiceType.COORDINATOR);
                this.generateConfigRequestBodyConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType, ServiceType.OVERLORD);
                break;
            }
            case DATA: {
                this.generateConfigRequestBodyConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType);
                break;
            }
            case QUERY: {
                this.generateConfigRequestBodyConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType, ServiceType.BROKER);
                this.generateConfigRequestBodyConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType, ServiceType.ROUTER);
                break;
            }
        }
    }

    protected void generateHelmOverridesForDataNodeVolumesPDs(ObjectNode implyNodeTypeNode, InstanceType instanceType) {
        int numPDVolumes = instanceType.getDiskInGb() / instanceType.getBaseEBSVolumeSizeInGB();
        ArrayNode extraVolumeClaimTemplates = implyNodeTypeNode.withArray("extraVolumeClaimTemplates");
        ArrayNode extraVolumeMounts = implyNodeTypeNode.withArray("extraVolumeMounts");
        for (int i = 0; i < numPDVolumes; ++i) {
            this.generateK8sVolumeClaimTemplatesAndMounts(i, instanceType.getBaseEBSVolumeSizeInGB(), null, extraVolumeClaimTemplates, extraVolumeMounts);
        }
        implyNodeTypeNode.put("tmpVolumeName", "var");
        implyNodeTypeNode.put("tmpVolumeSubpath", "tmp");
    }

    protected void generateHelmOverridesForDataNodeVolumesLocal(ObjectNode implyNodeTypeNode, InstanceType instanceType, ArrayNode extraVolumes) {
        ObjectNode volume = YAML_MAPPER.createObjectNode();
        volume.put("name", "var");
        ObjectNode path = YAML_MAPPER.createObjectNode();
        path.put("path", "/mnt/disks/ssd0");
        path.put("type", "DirectoryOrCreate");
        volume.set("hostPath", (JsonNode)path);
        extraVolumes.add((JsonNode)volume);
        if (instanceType.getNumLocalSSD() != null && instanceType.getNumLocalSSD() > 1) {
            ArrayNode extraVolumeMounts = (ArrayNode)implyNodeTypeNode.path("extraVolumeMounts");
            for (int i = 1; i < instanceType.getNumLocalSSD(); ++i) {
                volume = YAML_MAPPER.createObjectNode();
                volume.put("name", "var" + i);
                path = YAML_MAPPER.createObjectNode();
                path.put("path", "/mnt/disks/ssd" + i);
                path.put("type", "Directory");
                volume.set("hostPath", (JsonNode)path);
                extraVolumes.add((JsonNode)volume);
                ObjectNode mount = YAML_MAPPER.createObjectNode();
                mount.put("mountPath", "/mnt/var" + i);
                mount.put("name", "var" + i);
                extraVolumeMounts.add((JsonNode)mount);
            }
            implyNodeTypeNode.set("extraVolumeMounts", (JsonNode)extraVolumeMounts);
        }
        ObjectNode tmpVolume = YAML_MAPPER.createObjectNode();
        tmpVolume.put("name", "tmp");
        ObjectNode tmpPath = YAML_MAPPER.createObjectNode();
        tmpPath.put("path", "/mnt/disks/ssd0/tmp");
        tmpPath.put("type", "DirectoryOrCreate");
        tmpVolume.set("hostPath", (JsonNode)tmpPath);
        extraVolumes.add((JsonNode)tmpVolume);
    }

    protected void generateHelmOverridesForDataNodes(ObjectNode implyNodeTypeNode, ImplyNodeType implyNodeType, InstanceType instanceType, Cluster cluster) {
        ArrayNode extraVolumes = (ArrayNode)implyNodeTypeNode.path("extraVolumes");
        if (instanceType.getInstanceType().endsWith("-pd")) {
            this.generateHelmOverridesForDataNodeVolumesPDs(implyNodeTypeNode, instanceType);
        } else {
            this.generateHelmOverridesForDataNodeVolumesLocal(implyNodeTypeNode, instanceType, extraVolumes);
        }
        if (!this.onPremKubernetesManagerConfig.isSysctlInitContainerEnabled()) {
            implyNodeTypeNode.withObject("sysctlInitContainer").put("enabled", false);
        }
        if (this.applicationConfig.isDevelopmentMode()) {
            implyNodeTypeNode.withArray("extraEnv").addObject().put("name", "IMPLY_STAGE_WAIT").put("value", "0");
        }
        implyNodeTypeNode.set("extraVolumes", (JsonNode)extraVolumes);
    }

    protected void generateHelmOverridesForAdditionalDataNodes(ObjectNode rootNode, Cluster cluster) {
        ArrayNode additionalDataTiers = (ArrayNode)rootNode.path("additionalDataTiers");
        cluster.getDataInstanceTiers().keySet().stream().filter(key -> key > 3).forEach(additionalDataTier -> additionalDataTiers.add(this.dataTierValuesConfig.deepCopy()));
    }

    protected void generateHelmOverridesForPeons(ObjectNode implyRootNode, Cluster cluster, Account account) {
    }

    protected void generateHelmOverridesForPeonTemplates(ObjectNode implyNodeTypeNode, ImplyNodeType implyNodeType, String instanceType, Cluster cluster, Account account) {
    }

    private void generateHelmOverridesForMasterNodes(ObjectNode implyNodeTypeNode, Cluster cluster) {
        ArrayNode expressions = (ArrayNode)implyNodeTypeNode.path("affinity").path("podAffinity").path("requiredDuringSchedulingIgnoredDuringExecution").get(0).path("labelSelector").path("matchExpressions");
        expressions.add(YAML_MAPPER.valueToTree((Object)ImmutableMap.of((Object)"key", (Object)"release", (Object)"operator", (Object)"In", (Object)"values", (Object)ImmutableList.of((Object)HelmUtils.generateReleaseNameForCluster(cluster, this.applicationConfig)))));
    }

    private void generateHelmOverridesForIngresses(ObjectNode rootNode, Cluster cluster) {
        ObjectNode ingressNode = (ObjectNode)rootNode.path(ImplyNodeType.QUERY.camelCasedName()).path("ingress");
        ObjectNode routerIngressNode = (ObjectNode)ingressNode.path("router");
        ObjectNode routerIngressAnnotations = (ObjectNode)routerIngressNode.path("annotations");
        routerIngressAnnotations.put("nginx.ingress.kubernetes.io/proxy-redirect-to", String.format("/%s/unified-console.html", cluster.getClusterId()));
        routerIngressNode.put("enabled", true).put("host", this.onPremKubernetesManagerConfig.getIngressHost()).putArray("paths").add(String.format("/%s(/|$)(.*)", cluster.getClusterId()));
        if (cluster.getPivot() != null && cluster.getPivot().getType() != Pivot.Type.PROXIED && StringUtils.isNotBlank((CharSequence)cluster.getPivot().getUrl())) {
            try {
                URL url = new URL(cluster.getPivot().getUrl());
                ingressNode.withObject("pivot").put("enabled", true).put("host", url.getHost()).putArray("paths").add("/" + StringUtils.strip((String)url.getPath(), (String)"/"));
            }
            catch (MalformedURLException e) {
                log.warn((Throwable)e, "Could not parse url [%s], not configuring ingress", new Object[]{cluster.getPivot().getUrl()});
            }
        }
    }

    private void generateHelmOverridesForZooKeeper(ObjectNode rootNode, Cluster cluster) {
        InstanceType instanceType = this.getInstanceTypeHelper().lookupInstanceType(ImplyNodeType.MASTER, cluster.getMasterInstanceType());
        if (instanceType == null) {
            throw new ISE("Did not find instance type '%s' in list of supported instance types for imply node type '%s'", new Object[]{instanceType, ImplyNodeType.MASTER});
        }
        ObjectNode zooKeeperNode = (ObjectNode)rootNode.path("zookeeper");
        zooKeeperNode.put("replicaCount", cluster.getMasterInstanceCount());
        zooKeeperNode.withObject("nodeSelector").put(this.onPremKubernetesManagerConfig.getInstanceTypeNodeSelectorLabel(), instanceType.getInstanceType());
        ObjectNode zkEnv = (ObjectNode)zooKeeperNode.path("env");
        zkEnv.put("ZK_HEAP_SIZE", String.format("%sM", this.getInstanceTypeHelper().getZookeeperHeapSize(instanceType)));
        if (this.onPremKubernetesManagerConfig.getNodeTolerationKey() != null) {
            ArrayNode tolerationNode = YAML_MAPPER.createArrayNode();
            tolerationNode.add(YAML_MAPPER.valueToTree((Object)ImmutableMap.of((Object)"key", (Object)this.onPremKubernetesManagerConfig.getNodeTolerationKey(), (Object)"operator", (Object)"Exists", (Object)"effect", (Object)"NoExecute")));
            zooKeeperNode.set("tolerations", (JsonNode)tolerationNode);
        }
    }

    protected void generateK8sVolumeClaimTemplatesAndMounts(Integer volumeIndex, Integer baseVolumeSize, String storageClassName, ArrayNode volumeClaimTemplates, ArrayNode volumeMounts) {
        String volumeName = volumeIndex == 0 ? "var" : String.format("var%d", volumeIndex);
        ObjectNode volumeClaimTemplate = volumeClaimTemplates.addObject();
        volumeClaimTemplate.withObject("metadata").put("name", volumeName);
        ObjectNode volumeClaimSpec = volumeClaimTemplate.withObject("spec");
        volumeClaimSpec.withArray("accessModes").add("ReadWriteOnce");
        volumeClaimSpec.withObject("resources").withObject("requests").put("storage", String.format("%dGi", baseVolumeSize));
        if (storageClassName != null) {
            volumeClaimSpec.put("storageClassName", storageClassName);
        }
        if (volumeIndex > 0) {
            volumeMounts.addObject().put("name", volumeName).put("mountPath", String.format("/mnt/%s", volumeName));
        }
    }

    protected String getEnvNameFromDruidProperty(String propName) {
        return propName.replace('.', '_');
    }

    protected boolean shouldSkipFile(DruidConfigFile configFile, ImplyNodeType implyNodeType, ServiceType serviceType) {
        if (this.shouldSkipFile(configFile) || configFile.getFileType().equals((Object)DruidConfigFile.FileType.SCRIPT)) {
            return true;
        }
        if (implyNodeType.equals((Object)ImplyNodeType.MASTER) && configFile.getFileType().equals((Object)DruidConfigFile.FileType.PEON_POD_TEMPLATE)) {
            return true;
        }
        if (configFile.getFileType().equals((Object)DruidConfigFile.FileType.SUPERVISE)) {
            return !ImmutableSet.of((Object)String.format("supervise/%s.conf", implyNodeType.getServiceType()), (Object)"supervise/druid.conf").contains((Object)configFile.getFilePath());
        }
        if (configFile.getServiceType().equals((Object)ServiceType.COMMON) || configFile.getServiceType().equals((Object)ServiceType.NONE)) {
            return false;
        }
        if (serviceType != null) {
            return !configFile.getServiceType().equals((Object)serviceType);
        }
        switch (implyNodeType.getNodeServiceType()) {
            case MASTER: {
                return !configFile.getServiceType().equals((Object)ServiceType.COORDINATOR) && !configFile.getServiceType().equals((Object)ServiceType.OVERLORD);
            }
            case COLD_TIER_DATA: {
                return !configFile.getServiceType().equals((Object)ServiceType.COLD_HISTORICAL);
            }
            case DATA: {
                return !configFile.getServiceType().equals((Object)ServiceType.HISTORICAL) && !configFile.getServiceType().equals((Object)ServiceType.MIDDLE_MANAGER);
            }
            case COLD_TIER_QUERY: {
                return !configFile.getServiceType().equals((Object)ServiceType.COLD_BROKER);
            }
            case QUERY: {
                return !configFile.getServiceType().equals((Object)ServiceType.BROKER) && !configFile.getServiceType().equals((Object)ServiceType.ROUTER) && !configFile.getServiceType().equals((Object)ServiceType.PIVOT);
            }
            case INGEST: {
                return !configFile.getServiceType().equals((Object)ServiceType.MIDDLE_MANAGER);
            }
            case PEON: {
                return !configFile.getServiceType().equals((Object)ServiceType.PEON);
            }
        }
        return false;
    }

    private boolean isSecretConfigFile(DruidConfigFile configFile) {
        ImmutableSet secretFileTypes = ImmutableSet.of((Object)DruidConfigFile.FileType.GOOGLE_KEY_JSON, (Object)DruidConfigFile.FileType.KEYSTORE, (Object)DruidConfigFile.FileType.TRUSTSTORE, (Object)DruidConfigFile.FileType.PIVOT_LICENSE, (Object)DruidConfigFile.FileType.PIVOT_CONFIG, (Object)DruidConfigFile.FileType.METADATA_CLIENT_KEY, (Object[])new DruidConfigFile.FileType[]{DruidConfigFile.FileType.METADATA_TLS_CERT, DruidConfigFile.FileType.METADATA_CLIENT_CERT});
        return secretFileTypes.contains(configFile.getFileType());
    }

    private boolean isSecretRuntimeProperty(String prop) {
        ImmutableSet secretProps = ImmutableSet.of((Object)"druid.metadata.storage.connector.password", (Object)"druid.escalator.keycloak.credentials", (Object)"druid.auth.authenticator.basic.initialAdminPassword", (Object)"druid.emitter.clarity.basicAuthentication");
        return secretProps.contains(prop);
    }

    protected boolean isRuntimePropExcludedFromHash(String prop) {
        return false;
    }

    protected void addAdditionalHashValues(Cluster cluster, Account account, MurmurHash3.IncrementalHash32x86 hash) {
    }

    private void generateRuntimePropertiesConfigs(ObjectNode implyNodeTypeNode, Cluster cluster, Account account, ImplyNodeType implyNodeType, String instanceType, ConfigRequestBody configRequestBody, DruidConfigFile configFile, MurmurHash3.IncrementalHash32x86 hash) throws IOException {
        String fileName = String.format("%s/%s", this.getConfigBundleBasePath(cluster, implyNodeType), configFile.getFilePath());
        Properties props = this.generateCustomRuntimeProperties(cluster, account, instanceType, configFile, configRequestBody);
        if (props.size() == 0) {
            return;
        }
        Properties redactedProperties = new Properties();
        ObjectNode files = implyNodeTypeNode.withObject("configFiles");
        ObjectNode secrets = implyNodeTypeNode.withObject("secrets");
        props.stringPropertyNames().stream().sorted().forEach(key -> {
            String val = props.getProperty((String)key).toString();
            String propVal = String.format("%s=%s", key, val);
            if (!this.isRuntimePropExcludedFromHash((String)key)) {
                hash.add(propVal.getBytes(StandardCharsets.UTF_8), 0, propVal.length());
            }
            if (!this.isSecretRuntimeProperty((String)key)) {
                redactedProperties.put(key, val);
                return;
            }
            String envName = this.getEnvNameFromDruidProperty((String)key);
            redactedProperties.put(key, String.format("${env:%s}", envName));
            secrets.put(envName, Base64.getEncoder().encodeToString(val.getBytes(StandardCharsets.UTF_8)));
        });
        files.put(fileName, PropertiesHelper.convertPropertiesToSortedPropertiesFileString((Properties)redactedProperties));
    }

    private void generateConfigBundleConfigs(ObjectNode implyNodeTypeNode, Cluster cluster, Account account, ImplyNodeType implyNodeType, String instanceType, ConfigRequestBody configRequestBody, ServiceType serviceType, MurmurHash3.IncrementalHash32x86 hash) {
        try {
            for (DruidConfigFile configFile : this.getConfigFiles(cluster)) {
                String fileName = String.format("%s/%s", this.getConfigBundleBasePath(cluster, implyNodeType), configFile.getFilePath());
                if (this.shouldSkipFile(configFile, implyNodeType, serviceType)) continue;
                if (configFile.getFileType().equals((Object)DruidConfigFile.FileType.RUNTIME_PROPERTIES)) {
                    this.generateRuntimePropertiesConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType, configRequestBody, configFile, hash);
                    continue;
                }
                ObjectNode files = implyNodeTypeNode.withObject(this.isSecretConfigFile(configFile) ? "secretConfigFiles" : "configFiles");
                byte[] contents = this.generateCustomConfigFile(cluster, account, configRequestBody, configFile);
                if (contents == null) continue;
                hash.add(contents, 0, contents.length);
                String stringContent = this.isSecretConfigFile(configFile) ? Base64.getEncoder().encodeToString(contents) : new String(contents, StandardCharsets.UTF_8);
                files.put(fileName, stringContent);
            }
        }
        catch (IOException e) {
            throw new ISE("Unable to generate runtime properties.", new Object[0]);
        }
    }

    protected void generateConfigRequestBodyConfigs(ObjectNode implyNodeTypeNode, Cluster cluster, Account account, ImplyNodeType implyNodeType, String instanceType) throws IOException {
        this.generateConfigRequestBodyConfigs(implyNodeTypeNode, cluster, account, implyNodeType, instanceType, null);
    }

    protected void generateConfigRequestBodyConfigs(ObjectNode implyNodeTypeNode, Cluster cluster, Account account, ImplyNodeType implyNodeType, String instanceType, ServiceType serviceType) throws IOException {
        ObjectNode configNode = implyNodeTypeNode;
        if (serviceType != null) {
            configNode = implyNodeTypeNode.withObject(serviceType.getName());
        }
        ConfigRequestBody configRequestBody = ConfigRequestBody.builder().clusterId(cluster.getClusterId()).instanceType(instanceType).instanceTier(Integer.valueOf(implyNodeType.getTierNumber())).serviceTypes((List)ImmutableList.of((Object)implyNodeType.getServiceType())).configVersion(cluster.getVersion()).build();
        MurmurHash3.IncrementalHash32x86 hash = new MurmurHash3.IncrementalHash32x86();
        hash.start(0);
        this.generateConfigBundleConfigs(configNode, cluster, account, implyNodeType, instanceType, configRequestBody, serviceType, hash);
        ObjectNode files = configNode.withObject("configFiles");
        String bundleId = cluster.getImplyVersionFull().getBundleId();
        hash.add(bundleId.getBytes(StandardCharsets.UTF_8), 0, bundleId.length());
        String userFilePaths = this.generateExtendedUserFilePaths(cluster, account, configRequestBody);
        if (!Strings.isNullOrEmpty((String)userFilePaths)) {
            files.put(String.format("%s/%s", this.getConfigBundleBasePath(cluster, implyNodeType), "userFilePaths"), userFilePaths);
            hash.add(userFilePaths.getBytes(StandardCharsets.UTF_8), 0, userFilePaths.length());
        }
        this.addAdditionalHashValues(cluster, account, hash);
        configNode.withObject("annotations").put("imply.io/configHash", String.format("%d", hash.end()));
    }

    private String getConfigFileMountPath(Cluster cluster, ImplyNodeType implyNodeType) {
        if (implyNodeType.getNodeServiceType().equals((Object)ImplyNodeType.ImplyNodeServiceType.PEON) || this.isImmutableEnabled(cluster)) {
            return "opt/imply";
        }
        return "opt/staged";
    }

    protected String getConfigBundleBasePath(Cluster cluster, ImplyNodeType implyNodeType) {
        return String.format("%s/conf", this.getConfigFileMountPath(cluster, implyNodeType));
    }

    protected byte[] generateCustomLog4jFile(Cluster cluster, Account account, String instanceType, DruidConfigFile druidConfigFile, ConfigRequestBody configRequestBody) throws IOException {
        if (this.isImmutableEnabled(cluster)) {
            InputStream stream = ClassLoader.getSystemResourceAsStream("druid/_common/log4j2-immutable.xml");
            return stream != null ? IOUtils.toByteArray((InputStream)stream) : super.generateCustomLog4jFile(cluster, account, instanceType, druidConfigFile, configRequestBody);
        }
        return super.generateCustomLog4jFile(cluster, account, instanceType, druidConfigFile, configRequestBody);
    }

    @Override
    protected List<UserFile> rewritePaths(Cluster cluster, List<UserFile> original, String accountId, Boolean isTLSEnabled, String instanceType) {
        if (this.isImmutableEnabled(cluster)) {
            return original;
        }
        return super.rewritePaths(cluster, original, accountId, isTLSEnabled, instanceType);
    }

    protected boolean isImmutableEnabled(Cluster cluster) {
        return FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.IMMUTABLE_CONTAINERS, (RefreshableConstants)this.getRefreshableConstants());
    }

    protected boolean isSingleServicePodsEnabled(Cluster cluster, ImplyNodeType implyNodeType) {
        return this.isImmutableEnabled(cluster) && (FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.SINGLE_SERVICE_MASTER_PODS, (RefreshableConstants)this.getRefreshableConstants()) && ImplyNodeType.MASTER.equals((Object)implyNodeType) || FeatureFlag.enabledForCluster((Cluster)cluster, (FeatureFlags)FeatureFlags.SINGLE_SERVICE_QUERY_PODS, (RefreshableConstants)this.getRefreshableConstants()) && ImplyNodeType.QUERY.equals((Object)implyNodeType));
    }
}

