/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.configurator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.configurator.CertificateCache;
import io.imply.cloud.configurator.ConfiguratorManager;
import io.imply.cloud.configurator.authenticator.ClusterAuthConfigurator;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.model.druid.GCSDeepStorage;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.model.metadatastorage.MySqlMetadataStorage;
import io.imply.cloud.model.metadatastorage.PostgreSqlMetadataStorage;
import io.imply.cloud.model.zookeeper.ExternalZooKeeper;
import io.imply.cloud.onprem.config.OnPremManagerConfig;
import io.imply.cloud.onprem.model.OnPremCluster;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.tls.TLSUtils;
import io.imply.cloud.util.ClusterNodesHelper;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import io.imply.cloud.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

public class OnPremConfiguratorManager
extends ConfiguratorManager {
    private final OnPremManagerConfig managerConfig;
    private final ClusterNodesHelper clusterNodesHelper;

    @Inject
    public OnPremConfiguratorManager(RefreshableConstantsUpdater refreshableConstantsUpdater, RefreshableConstantsConfig refreshableConstantsConfig, AccountDataManager accountDataManager, ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ConfigServerConfig config, CertificateCache certificateCache, SecurityConfig securityConfig, ApplicationConfig applicationConfig, ClusterAuthConfigurator clusterAuthConfigurator, OnPremManagerConfig managerConfig, ClusterNodesHelper clusterNodesHelper, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) throws IOException {
        super(refreshableConstantsUpdater, refreshableConstantsConfig, accountDataManager, clusterDataManager, entityStateDataManager, config, certificateCache, securityConfig, applicationConfig, clusterAuthConfigurator, refreshableConstants, instanceTypeHelper);
        this.managerConfig = managerConfig;
        this.clusterNodesHelper = clusterNodesHelper;
    }

    public String generateGroveInit(Cluster cluster, ConfigRequestBody configRequestBody) {
        GCSDeepStorage deepStorage;
        if (!(cluster instanceof OnPremCluster)) {
            throw new ISE("Expecting object type [OnPremCluster] but found [%s]", new Object[]{cluster.getClass().getName()});
        }
        String implyBundleId = cluster.getImplyVersionFull().getBundleId();
        boolean runZK = false;
        HashMap<String, Object> groveInit = new HashMap<String, Object>();
        groveInit.put("name", configRequestBody.getServiceTypes().stream().map(x -> ImplyNodeType.fromServiceTypeAndTier((String)x, (Integer)configRequestBody.getInstanceTier()).camelCasedName()).collect(Collectors.joining("/")));
        ArrayList<String> packages = new ArrayList<String>();
        packages.add(implyBundleId);
        if (runZK) {
            packages.add("zk-3.7.1-fc402757");
        }
        if (this.config.getAdditionalGroveDeploys() != null) {
            packages.addAll(this.config.getAdditionalGroveDeploys());
        }
        groveInit.put("deploy", packages);
        HashMap<String, String> env = new HashMap<String, String>();
        if (runZK) {
            List sortedZkHosts = this.clusterNodesHelper.getSortedMasterHosts(cluster.getClusterId());
            int zkId = -1;
            StringBuilder zkEnsemble = new StringBuilder();
            for (int i = 0; i < sortedZkHosts.size(); ++i) {
                if (((String)sortedZkHosts.get(i)).equals(configRequestBody.getMyPrivateIpAddress())) {
                    zkId = i + 1;
                }
                zkEnsemble.append(i + 1).append(':').append((String)sortedZkHosts.get(i)).append(":2888:3888");
                if (i + 1 >= sortedZkHosts.size()) continue;
                zkEnsemble.append(',');
            }
            env.put("IMPLY_ZK_JAVAOPTS", "-server -Xms512m -Xmx512m -XX:+ExitOnOutOfMemoryError -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/mnt/tmp/zk.hprof");
            env.put("IMPLY_ZK_DATADIR", "/mnt/var/zk/data");
            env.put("IMPLY_ZK_CONFDIR", "/mnt/var/zk/conf");
            env.put("IMPLY_ZK_DISTDIR", "apache-zookeeper-3.7.1-bin");
            env.put("IMPLY_ZK_ENSEMBLE", zkEnsemble.toString());
            env.put("IMPLY_ZK_MYID", Integer.toString(zkId));
        }
        if (cluster.getDeepStorage() instanceof GCSDeepStorage && !Strings.isNullOrEmpty((String)(deepStorage = (GCSDeepStorage)cluster.getDeepStorage()).getJsonKey())) {
            env.put("GOOGLE_APPLICATION_CREDENTIALS", "/opt/imply/conf/google/key.json");
        }
        if (this.config.getAdditionalGroveEnv() != null) {
            env.putAll(this.config.getAdditionalGroveEnv());
        }
        if (cluster.isLogviewSupported()) {
            env.put("LOGVIEW_CONFIG", String.format("%s/%s", this.managerConfig.getAgentEtcDirectory(), "logview.yaml"));
        }
        groveInit.put("env", env);
        HashMap<String, ImmutableMap> services = new HashMap<String, ImmutableMap>();
        List<String> implyRun = this.generateImplyRunCommand(cluster);
        List<HashMap<String, String>> druidHealthProbes = this.generateDruidHealthProbes(configRequestBody, cluster);
        services.put("imply", ImmutableMap.of((Object)"healthProbe", (Object)ImmutableMap.of((Object)"http", druidHealthProbes), (Object)"run", implyRun));
        if (cluster.isLogviewSupported()) {
            services.put("logview", ImmutableMap.of((Object)"run", (Object)ImmutableList.of((Object)"--", (Object)"logview")));
        }
        if (runZK) {
            services.put("zk-server", ImmutableMap.of((Object)"run", (Object)ImmutableList.of((Object)"bin/zk-server")));
        }
        if (this.config.getAdditionalGroveServiceRunArgs() != null) {
            for (Map.Entry entry : this.config.getAdditionalGroveServiceRunArgs().entrySet()) {
                services.put((String)entry.getKey(), ImmutableMap.of((Object)"run", entry.getValue()));
            }
        }
        groveInit.put("services", services);
        groveInit.put("user", this.managerConfig.getGroveServiceUser());
        groveInit.put("group", this.managerConfig.getGroveServiceGroup());
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("implyNodeTypes", configRequestBody.getServiceTypes().stream().map(x -> ImplyNodeType.fromServiceTypeAndTier((String)x, (Integer)configRequestBody.getInstanceTier()).camelCasedName()).collect(Collectors.toList()));
        metadata.put("implyBundleId", implyBundleId);
        metadata.put("implyVersion", cluster.getImplyVersionFull().getVersion());
        metadata.put("clusterId", cluster.getClusterId());
        metadata.put("clusterVersion", cluster.getVersion());
        groveInit.put("metadata", metadata);
        try {
            return YAML_MAPPER.writeValueAsString(groveInit);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> generateImplyRunCommand(Cluster cluster) {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)"--").add((Object)String.format("%s/bin/supervise", cluster.getImplyVersionFull().getBundleId())).add((Object)"-c").add((Object)"/opt/imply/conf/supervise/druid.conf").add((Object)"-d").add((Object)"/mnt/var").add((Object)"-t").add((Object)"40");
        if (this.managerConfig.isSyslogEnabled()) {
            builder.add((Object)"--svlogd-conf").add((Object)"/opt/imply/conf/logging/logging-config");
        } else {
            builder.add((Object)"--svlogd");
        }
        return builder.build();
    }

    protected void addPlatformSpecificRuntimeProperties(Properties props, Cluster cluster, Account account, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        if (!(cluster instanceof OnPremCluster)) {
            throw new ISE("Expecting object type [OnPremCluster] but found [%s]", new Object[]{cluster.getClass().getName()});
        }
        OnPremCluster onPremCluster = (OnPremCluster)cluster;
        ServiceType serviceType = configFile.getServiceType();
        Map<String, String> druidPropertiesForInstanceAndServiceType = this.getPlatformSpecificDruidProperties(instanceType, serviceType, cluster.getImplyVersionFull().getComparableVersion(), configRequestBody);
        props.putAll(druidPropertiesForInstanceAndServiceType);
        if (ServiceType.COMMON.equals((Object)serviceType)) {
            props.setProperty("druid.zk.service.host", onPremCluster.getZkServerHosts());
            if (onPremCluster.getZooKeeper() instanceof ExternalZooKeeper && ((ExternalZooKeeper)onPremCluster.getZooKeeper()).getBasePath() != null) {
                String basePath = ((ExternalZooKeeper)onPremCluster.getZooKeeper()).getBasePath();
                props.setProperty("druid.zk.paths.base", String.format("/%s", StringUtils.stripLeadingAndTrailingSlashes((String)basePath)));
                props.setProperty("druid.discovery.curator.path", String.format("/%s/discovery", StringUtils.stripLeadingAndTrailingSlashes((String)basePath)));
            }
            this.addMetadataStorageProperties(props, onPremCluster.getMetadataStorage());
        }
    }

    protected void addPlatformSpecificServiceToSupervise(StringBuilder contents, ImplyNodeType nodeType, Cluster cluster) {
        if (ImplyNodeType.QUERY.equals((Object)nodeType)) {
            contents.append(String.format("pivot %s %s%n", "bin/run-pivot", "/opt/imply/conf"));
        }
        if (ImplyNodeType.DATA.equals((Object)nodeType)) {
            this.appendDruidServiceToSupervise(contents, this.useIndexerInsteadOfMiddleManager(cluster) ? "indexer" : "middleManager");
        }
    }

    protected Map<String, String> getPlatformSpecificDruidProperties(String instanceType, ServiceType serviceType, ComparableVersion comparableVersion, ConfigRequestBody configRequestBody) {
        return ImmutableMap.of();
    }

    protected String appendPlatformSpecificJvmConfig(Cluster cluster, String instanceType, DruidConfigFile configFile, ConfigRequestBody configRequestBody) {
        if (!(cluster instanceof OnPremCluster)) {
            throw new ISE("Expecting object type [OnPremCluster] but found [%s]", new Object[]{cluster.getClass().getName()});
        }
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"-XX:MaxDirectMemorySize=100000m", (Object)"-Daws.region=us-east-1")).concat("\n");
    }

    protected void maybeAddImplyLicense(Properties properties, Cluster cluster, Account account, DruidConfigFile configFile) {
        if (ServiceType.COMMON != configFile.getServiceType()) {
            return;
        }
        byte[] implyLicense = this.maybeGenerateImplyLicense(account, cluster);
        if (implyLicense != null) {
            properties.setProperty("imply.license", new String(implyLicense, StandardCharsets.UTF_8));
        }
    }

    protected byte[] maybeGenerateImplyLicense(Account account, Cluster cluster) {
        if (this.managerConfig.getLicenseKey() != null && !this.managerConfig.getLicenseKey().isEmpty()) {
            return this.managerConfig.getLicenseKey().getBytes(StandardCharsets.UTF_8);
        }
        return super.maybeGenerateImplyLicense(account, cluster);
    }

    protected void addPlatformSpecificPivotConfiguration(Map<String, Object> configMap, Cluster cluster, Account account) {
        if (configMap == null || cluster == null) {
            return;
        }
        if (!(cluster instanceof OnPremCluster)) {
            throw new ISE("Expecting object type [OnPremCluster] but found [%s]", new Object[]{cluster.getClass().getName()});
        }
        OnPremCluster onPremCluster = (OnPremCluster)cluster;
        MetadataStorage metadataStorage = cluster.getMetadataStorage();
        if (metadataStorage == null) {
            throw new ISE("Cluster [metadataStorage] cannot be null or empty", new Object[0]);
        }
        configMap.put("zookeeperConnection", onPremCluster.getZkServerHosts());
        if (onPremCluster.getZooKeeper() instanceof ExternalZooKeeper && ((ExternalZooKeeper)onPremCluster.getZooKeeper()).getBasePath() != null) {
            configMap.put("zookeeperPath", String.format("/%s/pivot", StringUtils.stripLeadingAndTrailingSlashes((String)((ExternalZooKeeper)onPremCluster.getZooKeeper()).getBasePath())));
        }
        configMap.remove("sessionStore");
        configMap.computeIfAbsent("stateStore", k -> new HashMap());
        Map stateStore = (Map)configMap.get("stateStore");
        if (metadataStorage instanceof MySqlMetadataStorage || metadataStorage instanceof PostgreSqlMetadataStorage) {
            stateStore.put("type", metadataStorage instanceof MySqlMetadataStorage ? "mysql" : "pg");
            stateStore.computeIfAbsent("connection", k -> new HashMap());
            Map connection = (Map)stateStore.get("connection");
            connection.put("host", metadataStorage.getHost());
            connection.put("port", metadataStorage.getPort());
            connection.put("user", metadataStorage.getUser() != null ? metadataStorage.getUser() : "");
            connection.put("password", metadataStorage.getPassword() != null ? metadataStorage.getPassword() : "");
            connection.put("database", metadataStorage.getSchema());
            HashMap<String, String> ssl = new HashMap<String, String>();
            if (!Strings.isNullOrEmpty((String)metadataStorage.getTlsCert())) {
                ssl.put("ca", metadataStorage.getTlsCert());
            }
            if (!Strings.isNullOrEmpty((String)metadataStorage.getClientCert()) && !Strings.isNullOrEmpty((String)metadataStorage.getClientKey())) {
                ssl.put("cert", metadataStorage.getClientCert());
                ssl.put("key", metadataStorage.getClientKey());
            }
            if (ssl.size() > 0) {
                connection.put("ssl", ssl);
            }
        } else {
            throw new ISE("[%s] is not a supported Imply UI state store type", new Object[]{metadataStorage.getMetadataType()});
        }
        if (configMap.get("fixedConnections") == null || ((List)configMap.get("fixedConnections")).isEmpty()) {
            throw new ISE("Expected to find [fixedConnections] in Pivot configuration but it doesn't exist", new Object[0]);
        }
        Map fixedConnection = ((List)configMap.get("fixedConnections")).stream().filter(x -> "druid".equals(x.get("type"))).findFirst().orElse(null);
        if (fixedConnection == null) {
            throw new ISE("Expected to find 'druid' type in [fixedConnections] but it doesn't exist", new Object[0]);
        }
        if (this.applicationConfig.useAuthentication() && !this.applicationConfig.isKubernetesMode()) {
            configMap.put("userMode", "native-users");
        } else if (this.applicationConfig.isKubernetesMode() && cluster.getPivot() == null) {
            configMap.put("userMode", "header-user");
        }
    }

    protected byte[] generateTruststore(Cluster cluster, ConfigRequestBody configRequestBody, DruidConfigFile configFile) {
        if (cluster.getMetadataStorage() == null || Strings.isNullOrEmpty((String)cluster.getMetadataStorage().getTlsCert())) {
            return null;
        }
        try {
            return TLSUtils.generateClientTruststore((String)cluster.getMetadataStorage().getTlsCert(), (String)"metadata-store-ca-", (String)"implymanager");
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected byte[] generateKeystore(Cluster cluster, ConfigRequestBody configRequestBody, DruidConfigFile configFile) {
        if (cluster.getMetadataStorage() == null || !(cluster.getMetadataStorage() instanceof MySqlMetadataStorage)) {
            return null;
        }
        MySqlMetadataStorage metadataStore = (MySqlMetadataStorage)cluster.getMetadataStorage();
        if (Strings.isNullOrEmpty((String)metadataStore.getClientCert()) || Strings.isNullOrEmpty((String)metadataStore.getClientKey())) {
            return null;
        }
        try {
            return TLSUtils.generateClientKeystore((String)metadataStore.getClientCert(), (String)metadataStore.getClientKey(), (String)"metadata-store-client-", (String)"implymanager");
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected byte[] generateMetadataStoreClientCert(Cluster cluster) {
        if (cluster.getMetadataStorage() == null || !(cluster.getMetadataStorage() instanceof PostgreSqlMetadataStorage)) {
            return null;
        }
        PostgreSqlMetadataStorage metadataStore = (PostgreSqlMetadataStorage)cluster.getMetadataStorage();
        if (Strings.isNullOrEmpty((String)metadataStore.getClientCert()) || Strings.isNullOrEmpty((String)metadataStore.getClientKey())) {
            return null;
        }
        return cluster.getMetadataStorage().getClientCert().getBytes(StandardCharsets.UTF_8);
    }

    protected byte[] generateMetadataStoreClientKey(Cluster cluster) {
        if (cluster.getMetadataStorage() == null || !(cluster.getMetadataStorage() instanceof PostgreSqlMetadataStorage)) {
            return null;
        }
        PostgreSqlMetadataStorage metadataStore = (PostgreSqlMetadataStorage)cluster.getMetadataStorage();
        if (Strings.isNullOrEmpty((String)metadataStore.getClientCert()) || Strings.isNullOrEmpty((String)metadataStore.getClientKey())) {
            return null;
        }
        try {
            return TLSUtils.generateClientDERFromPEM((String)metadataStore.getClientKey());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean shouldSkipFile(DruidConfigFile file) {
        return !ImmutableSet.of((Object)Platform.ANY, (Object)Platform.ONPREM).contains((Object)file.getPlatform());
    }

    protected boolean areTlsAndAuthenticationEnabledByDefault() {
        return false;
    }

    protected void maybeAddSysMonitor(List<String> monitors, String sysMonitor, Cluster cluster, ConfigRequestBody configRequestBody) {
    }

    protected List<UserFile> rewritePaths(Cluster cluster, List<UserFile> original, String accountId, Boolean isTLSEnabled, String instanceType) {
        if (this.applicationConfig.isSkipRewriteUrlForGroveServer()) {
            return original;
        }
        String scheme = BooleanUtils.isTrue((Boolean)isTLSEnabled) ? "https" : "http";
        return original.stream().map(x -> {
            try {
                URI uri = new URI(x.getPath());
                String[] fragments = uri.getPath().split("/");
                String filename = fragments[fragments.length - 1];
                String repository = x.getPath().substring(0, x.getPath().lastIndexOf(filename)).replaceAll("/+$", "");
                String rewritten = "manager".equals(uri.getScheme()) ? String.format("%s://%s/%s%s", scheme, "@MANAGER_REPO_HOST", "repo/", filename) : String.format("%s://%s/%s%s?%s=%s", scheme, "@MANAGER_REPO_HOST", "repo/", filename, "repo", URLEncoder.encode(repository, StringUtils.UTF8_STRING));
                return new UserFile(rewritten, x.isClasspath(), x.isUnpack(), x.isExecutable(), x.isHadoopDependency(), x.isDruidExtension(), x.getMetadata());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (URISyntaxException e) {
                throw new IAE((Throwable)e, "Failed to parse [%s] as URI", new Object[]{x.getPath()});
            }
        }).collect(Collectors.toList());
    }

    private void addMetadataStorageProperties(Properties props, MetadataStorage metadataStorage) {
        props.setProperty("druid.metadata.storage.connector.connectURI", metadataStorage.getConnectURI());
        if (metadataStorage instanceof MySqlMetadataStorage || metadataStorage instanceof PostgreSqlMetadataStorage) {
            props.setProperty("druid.metadata.storage.connector.user", metadataStorage.getUser() == null ? "" : metadataStorage.getUser());
            props.setProperty("druid.metadata.storage.connector.password", metadataStorage.getPassword() == null ? "" : metadataStorage.getPassword());
            if (!Strings.isNullOrEmpty((String)metadataStorage.getTlsCert())) {
                if (metadataStorage instanceof MySqlMetadataStorage) {
                    props.setProperty("druid.metadata.mysql.ssl.useSSL", "true");
                    props.setProperty("druid.metadata.mysql.ssl.verifyServerCertificate", "true");
                    props.setProperty("druid.metadata.mysql.ssl.trustCertificateKeyStoreUrl", String.format("%s/%s", "/opt/imply/conf", "druid/_common/metadata-truststore.jks"));
                    props.setProperty("druid.metadata.mysql.ssl.trustCertificateKeyStorePassword", "implymanager");
                    if (!Strings.isNullOrEmpty((String)metadataStorage.getClientCert()) && !Strings.isNullOrEmpty((String)metadataStorage.getClientKey())) {
                        props.setProperty("druid.metadata.mysql.ssl.clientCertificateKeyStoreType", "JKS");
                        props.setProperty("druid.metadata.mysql.ssl.clientCertificateKeyStoreUrl", String.format("%s/%s", "/opt/imply/conf", "druid/_common/metadata-keystore.jks"));
                        props.setProperty("druid.metadata.mysql.ssl.clientCertificateKeyStorePassword", "implymanager");
                    }
                } else {
                    props.setProperty("druid.metadata.postgres.ssl.useSSL", "true");
                    props.setProperty("druid.metadata.postgres.ssl.sslMode", this.config.getMetadataStoreSslMode() != null ? this.config.getMetadataStoreSslMode() : "verify-ca");
                    props.setProperty("druid.metadata.postgres.ssl.sslRootCert", String.format("%s/%s", "/opt/imply/conf", "druid/_common/metadata-store.pem"));
                    if (!Strings.isNullOrEmpty((String)metadataStorage.getClientCert()) && !Strings.isNullOrEmpty((String)metadataStorage.getClientKey())) {
                        props.setProperty("druid.metadata.postgres.ssl.sslCert", String.format("%s/%s", "/opt/imply/conf", "druid/_common/metadata-store-client-cert.pem"));
                        props.setProperty("druid.metadata.postgres.ssl.sslKey", String.format("%s/%s", "/opt/imply/conf", "druid/_common/metadata-store-client-key.pk8"));
                    }
                }
            }
        }
    }

    protected void addPlatformSpecificDruidHealthProbes(ConfigRequestBody configRequestBody, Cluster cluster, HashMap<String, String> sharedHealthProbeParameters, List<HashMap<String, String>> healthProbes) {
        if (configRequestBody.getServiceTypes().contains(ImplyNodeType.DATA.getServiceType())) {
            HashMap<String, String> historicalHealthProbe = new HashMap<String, String>(sharedHealthProbeParameters);
            Integer historicalPort = cluster.isUseTls() != false ? 8283 : 8083;
            historicalHealthProbe.put("port", String.valueOf(historicalPort));
            HashMap<String, String> middleManagerHealthProbe = new HashMap<String, String>(sharedHealthProbeParameters);
            Integer middleManagerPort = cluster.isUseTls() != false ? 8291 : 8091;
            middleManagerHealthProbe.put("port", String.valueOf(middleManagerPort));
            healthProbes.addAll((Collection<HashMap<String, String>>)ImmutableList.of(historicalHealthProbe, middleManagerHealthProbe));
        }
    }

    @VisibleForTesting
    public List<HashMap<String, String>> generateDruidHealthProbes(ConfigRequestBody configRequestBody, Cluster cluster) {
        ArrayList<HashMap<String, String>> healthProbes = new ArrayList<HashMap<String, String>>();
        String http = cluster.isUseTls() != false ? "https" : "http";
        HashMap<String, String> healthProbe = new HashMap<String, String>();
        healthProbe.put("scheme", http);
        healthProbe.put("host", configRequestBody.getMyPrivateIpAddress());
        healthProbe.put("path", "/status/health");
        if (configRequestBody.getServiceTypes().contains(ImplyNodeType.MASTER.getServiceType())) {
            HashMap<String, String> coordinatorHealthProbe = new HashMap<String, String>(healthProbe);
            Integer coordinatorPort = cluster.isUseTls() != false ? 8281 : 8081;
            coordinatorHealthProbe.put("port", String.valueOf(coordinatorPort));
            healthProbes.add(coordinatorHealthProbe);
            HashMap<String, String> overlordHealthProbe = new HashMap<String, String>(healthProbe);
            Integer overlordPort = cluster.isUseTls() != false ? 8290 : 8090;
            overlordHealthProbe.put("port", String.valueOf(overlordPort));
            healthProbes.add(overlordHealthProbe);
        }
        if (configRequestBody.getServiceTypes().contains(ImplyNodeType.QUERY.getServiceType())) {
            HashMap<String, String> brokerHealthProbe = new HashMap<String, String>(healthProbe);
            Integer brokerHealthPort = cluster.isUseTls() != false ? 8282 : 8082;
            brokerHealthProbe.put("port", String.valueOf(brokerHealthPort));
            healthProbes.add(brokerHealthProbe);
            HashMap<String, String> routerHealthProbe = new HashMap<String, String>(healthProbe);
            Integer routerHealthPort = cluster.isUseTls() != false ? 9088 : 8888;
            routerHealthProbe.put("port", String.valueOf(routerHealthPort));
            healthProbes.add(routerHealthProbe);
        }
        if (configRequestBody.getServiceTypes().contains(ImplyNodeType.INGEST.getServiceType())) {
            HashMap<String, String> middleManagerHealthProbe = new HashMap<String, String>(healthProbe);
            Integer middleManagerPort = cluster.isUseTls() != false ? 8291 : 8091;
            middleManagerHealthProbe.put("port", String.valueOf(middleManagerPort));
            healthProbes.add(middleManagerHealthProbe);
        }
        this.addPlatformSpecificDruidHealthProbes(configRequestBody, cluster, healthProbe, healthProbes);
        return healthProbes;
    }
}

