/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.onprem.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.util.StringUtils;
import lombok.Generated;
import org.joda.time.Period;

public class OnPremManagerConfig {
    @JsonProperty
    private String groveServer = "localhost:9999";
    @JsonProperty
    private String agentEtcDirectory = "/etc";
    @JsonProperty
    private String groveServiceUser = "grove";
    @JsonProperty
    private String groveServiceGroup = "grove";
    @JsonProperty
    private String licenseKey;
    @JsonProperty
    private boolean useManagerHostPlaceholder = true;
    @JsonProperty
    private boolean skipClusterMetadataStoreCheck = false;
    @JsonProperty
    private boolean skipClusterZkCheck = false;
    @JsonProperty
    private boolean syslogEnabled = false;
    @JsonProperty
    private Period dataInstanceAvailableTimeout;

    public String getGroveServer() {
        return this.groveServer;
    }

    public String getAgentEtcDirectory() {
        return this.agentEtcDirectory;
    }

    public String getGroveServiceUser() {
        return this.groveServiceUser;
    }

    public String getGroveServiceGroup() {
        return this.groveServiceGroup;
    }

    public String getLicenseKey() {
        return StringUtils.stripLeadingAndTrailingChars((char)'\"', (String)this.licenseKey);
    }

    public boolean isUseManagerHostPlaceholder() {
        return this.useManagerHostPlaceholder;
    }

    public boolean isSkipClusterMetadataStoreCheck() {
        return this.skipClusterMetadataStoreCheck;
    }

    public boolean isSkipClusterZkCheck() {
        return this.skipClusterZkCheck;
    }

    public boolean isSyslogEnabled() {
        return this.syslogEnabled;
    }

    public Period getDataInstanceAvailableTimeout() {
        return this.dataInstanceAvailableTimeout;
    }

    @Generated
    private static Period $default$dataInstanceAvailableTimeout() {
        return new Period((Object)"PT30M");
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public OnPremManagerConfig() {
        this.dataInstanceAvailableTimeout = OnPremManagerConfig.$default$dataInstanceAvailableTimeout();
    }

    @Generated
    public OnPremManagerConfig(String groveServer, String agentEtcDirectory, String groveServiceUser, String groveServiceGroup, String licenseKey, boolean useManagerHostPlaceholder, boolean skipClusterMetadataStoreCheck, boolean skipClusterZkCheck, boolean syslogEnabled, Period dataInstanceAvailableTimeout) {
        this.groveServer = groveServer;
        this.agentEtcDirectory = agentEtcDirectory;
        this.groveServiceUser = groveServiceUser;
        this.groveServiceGroup = groveServiceGroup;
        this.licenseKey = licenseKey;
        this.useManagerHostPlaceholder = useManagerHostPlaceholder;
        this.skipClusterMetadataStoreCheck = skipClusterMetadataStoreCheck;
        this.skipClusterZkCheck = skipClusterZkCheck;
        this.syslogEnabled = syslogEnabled;
        this.dataInstanceAvailableTimeout = dataInstanceAvailableTimeout;
    }

    @Generated
    public static class Builder {
        @Generated
        private String groveServer;
        @Generated
        private String agentEtcDirectory;
        @Generated
        private String groveServiceUser;
        @Generated
        private String groveServiceGroup;
        @Generated
        private String licenseKey;
        @Generated
        private boolean useManagerHostPlaceholder;
        @Generated
        private boolean skipClusterMetadataStoreCheck;
        @Generated
        private boolean skipClusterZkCheck;
        @Generated
        private boolean syslogEnabled;
        @Generated
        private boolean dataInstanceAvailableTimeout$set;
        @Generated
        private Period dataInstanceAvailableTimeout$value;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder groveServer(String groveServer) {
            this.groveServer = groveServer;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder agentEtcDirectory(String agentEtcDirectory) {
            this.agentEtcDirectory = agentEtcDirectory;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder groveServiceUser(String groveServiceUser) {
            this.groveServiceUser = groveServiceUser;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder groveServiceGroup(String groveServiceGroup) {
            this.groveServiceGroup = groveServiceGroup;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder licenseKey(String licenseKey) {
            this.licenseKey = licenseKey;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder useManagerHostPlaceholder(boolean useManagerHostPlaceholder) {
            this.useManagerHostPlaceholder = useManagerHostPlaceholder;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder skipClusterMetadataStoreCheck(boolean skipClusterMetadataStoreCheck) {
            this.skipClusterMetadataStoreCheck = skipClusterMetadataStoreCheck;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder skipClusterZkCheck(boolean skipClusterZkCheck) {
            this.skipClusterZkCheck = skipClusterZkCheck;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder syslogEnabled(boolean syslogEnabled) {
            this.syslogEnabled = syslogEnabled;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder dataInstanceAvailableTimeout(Period dataInstanceAvailableTimeout) {
            this.dataInstanceAvailableTimeout$value = dataInstanceAvailableTimeout;
            this.dataInstanceAvailableTimeout$set = true;
            return this;
        }

        @Generated
        public OnPremManagerConfig build() {
            Period dataInstanceAvailableTimeout$value = this.dataInstanceAvailableTimeout$value;
            if (!this.dataInstanceAvailableTimeout$set) {
                dataInstanceAvailableTimeout$value = OnPremManagerConfig.$default$dataInstanceAvailableTimeout();
            }
            return new OnPremManagerConfig(this.groveServer, this.agentEtcDirectory, this.groveServiceUser, this.groveServiceGroup, this.licenseKey, this.useManagerHostPlaceholder, this.skipClusterMetadataStoreCheck, this.skipClusterZkCheck, this.syslogEnabled, dataInstanceAvailableTimeout$value);
        }

        @Generated
        public String toString() {
            return "OnPremManagerConfig.Builder(groveServer=" + this.groveServer + ", agentEtcDirectory=" + this.agentEtcDirectory + ", groveServiceUser=" + this.groveServiceUser + ", groveServiceGroup=" + this.groveServiceGroup + ", licenseKey=" + this.licenseKey + ", useManagerHostPlaceholder=" + this.useManagerHostPlaceholder + ", skipClusterMetadataStoreCheck=" + this.skipClusterMetadataStoreCheck + ", skipClusterZkCheck=" + this.skipClusterZkCheck + ", syslogEnabled=" + this.syslogEnabled + ", dataInstanceAvailableTimeout$value=" + String.valueOf(this.dataInstanceAvailableTimeout$value) + ")";
        }
    }
}

