import hashlib
import os

import yaml

from . import dev

def load_config(dev_mode=False, fail_on_not_found=True):
  config_path = os.environ.get("GROVE_CONFIG")
  if config_path is None:
    config_path = "/etc/grove.yaml"

  if dev_mode:
    return yaml.load(dev.mock_grove_yaml(), Loader=yaml.FullLoader)

  try:
    d, sha1 = load_yaml_file_with_sha1(config_path)
    return d
  except FileNotFoundError:
    if fail_on_not_found: raise
    return {}

def load_yaml_file_with_sha1(file_name):
  with open(file_name, 'rb') as f:
    contents = f.read()
    sha1 = hashlib.sha1(contents).hexdigest()
    d = yaml.load(contents, Loader=yaml.FullLoader)
    return d, sha1
