/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import io.imply.cloud.util.NRE;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import lombok.Generated;

@Provider
public class NREMapper
extends BaseExceptionMapper<NRE> {
    public NREMapper(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Response innerToResponse(NRE exception, String requestId) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(NRE exception) {
        return ImmutableMap.of((Object)"error", (Object)exception.getMessage());
    }

    private ErrorResponse getError(NRE exception) {
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.NOT_FOUND).message(exception.getMessage()).build());
    }

    @Generated
    public NREMapper() {
    }
}

