/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class JsonParseExceptionMapper
extends BaseExceptionMapper<JsonParseException> {
    @Override
    public Response innerToResponse(JsonParseException exception, String requestId) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(JsonParseException exception) {
        return exception.getMessage() == null ? null : ImmutableMap.of((Object)"error", (Object)this.getMessageFromException(exception));
    }

    private ErrorResponse getError(JsonParseException exception) {
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.BAD_ARGUMENT).message(this.getMessageFromException(exception)).build());
    }

    private String getMessageFromException(JsonParseException exception) {
        StringBuilder error = new StringBuilder();
        error.append("Unable to parse JSON");
        if (exception.getLocation() != null) {
            error.append(", error at (");
            exception.getLocation().appendOffsetDescription(error);
            error.append(")");
        }
        return error.toString();
    }
}

