/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.exception.AccessDeniedException;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.AccessDeniedExceptionMapper;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class JsonMappingExceptionMapper
extends BaseExceptionMapper<JsonMappingException> {
    @Override
    public Response innerToResponse(JsonMappingException exception, String requestId) {
        Throwable cause = exception.getCause();
        if (cause instanceof AccessDeniedException) {
            return new AccessDeniedExceptionMapper().innerToResponse((AccessDeniedException)exception.getCause(), requestId);
        }
        log.warn("JsonMappingException: %s", new Object[]{exception.getMessage()});
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError((Exception)exception))).build();
    }

    private Map<String, String> getLegacyError(JsonMappingException exception) {
        return exception.getMessage() == null ? null : ImmutableMap.of((Object)"error", (Object)exception.getMessage());
    }

    private ErrorResponse getError(Exception exception) {
        if (exception.getMessage() == null) {
            return null;
        }
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.BAD_ARGUMENT).message(exception.getMessage()).build());
    }
}

