/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.exception.ImplyViolationException;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.collections4.CollectionUtils;

@Provider
public class ImplyViolationExceptionMapper
extends BaseExceptionMapper<ImplyViolationException> {
    @Override
    protected Response innerToResponse(ImplyViolationException exception, String requestId) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(ImplyViolationException exception) {
        return ImmutableMap.of((Object)"error", (Object)exception.getMessage());
    }

    private ErrorResponse getError(ImplyViolationException exception) {
        Error.Builder error = Error.builder().code(ErrorCode.BAD_ARGUMENT).message("Request contains invalid arguments");
        exception.getConstraintViolations().forEach(violation -> error.detail(Error.builder().code(ErrorCode.BAD_ARGUMENT).message(violation.getMessage()).target(CollectionUtils.isNotEmpty((Collection)violation.getFieldNames()) ? (String)violation.getFieldNames().get(0) : null).build()));
        return ErrorResponse.of((Error)error.build());
    }
}

