/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import lombok.Generated;

@Provider
public class IllegalArgumentExceptionMapper
extends BaseExceptionMapper<IllegalArgumentException> {
    public IllegalArgumentExceptionMapper(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Response innerToResponse(IllegalArgumentException exception, String requestId) {
        log.info("IllegalArgumentException: %s", new Object[]{exception.getMessage()});
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(IllegalArgumentException exception) {
        return exception.getMessage() == null ? null : ImmutableMap.of((Object)"error", (Object)exception.getMessage());
    }

    private ErrorResponse getError(Exception exception) {
        if (exception.getMessage() == null) {
            return null;
        }
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.BAD_ARGUMENT).message(exception.getMessage()).build());
    }

    @Generated
    public IllegalArgumentExceptionMapper() {
    }
}

