/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import io.imply.cloud.server.jetty.mapper.ThrowableMapper;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadUtils;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;

public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    protected static final Logger log = new Logger(ThrowableMapper.class);
    @Context
    protected HttpServletResponse response;
    @Context
    protected UriInfo uriInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response toResponse(T exception) {
        String requestId = this.response != null ? this.response.getHeader("X-Request-ID") : null;
        String userId = this.response != null ? this.response.getHeader("X-User-ID") : null;
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(ThreadUtils.getExtendedThreadName((String)originalThreadName, (String)userId, (String)requestId));
        try {
            Response response = this.innerToResponse(exception, requestId);
            return response;
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    protected boolean useLegacyError() {
        return !this.uriInfo.getPath().startsWith("/api/v1/clusters") && !this.uriInfo.getPath().startsWith("/v1/");
    }

    protected abstract Response innerToResponse(T var1, String var2);
}

