/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.exception.AlreadyExistsException;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import lombok.Generated;

@Provider
public class AlreadyExistsExceptionMapper
extends BaseExceptionMapper<AlreadyExistsException> {
    public AlreadyExistsExceptionMapper(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Response innerToResponse(AlreadyExistsException exception, String requestId) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(AlreadyExistsException exception) {
        return ImmutableMap.of((Object)"error", (Object)exception.getMessage());
    }

    private ErrorResponse getError(AlreadyExistsException exception) {
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.ALREADY_EXISTS).message(exception.getMessage()).build());
    }

    @Generated
    public AlreadyExistsExceptionMapper() {
    }
}

