/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jetty9.InstrumentedConnectionFactory;
import com.codahale.metrics.jetty9.InstrumentedQueuedThreadPool;
import com.codahale.metrics.servlets.AdminServlet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.servlet.ServletModule;
import com.google.inject.spi.Message;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.guice.annotations.Self;
import io.imply.cloud.lifecycle.Lifecycle;
import io.imply.cloud.server.ApplicationNode;
import io.imply.cloud.server.jetty.JettyErrorHandler;
import io.imply.cloud.server.jetty.JettyMonitoringConnectionFactory;
import io.imply.cloud.server.jetty.JettyServerInitializer;
import io.imply.cloud.server.jetty.ServerConfig;
import io.imply.cloud.server.jetty.ServletFilterHolder;
import io.imply.cloud.server.jetty.StatusResource;
import io.imply.cloud.server.jetty.mapper.AccessDeniedExceptionMapper;
import io.imply.cloud.server.jetty.mapper.AlreadyExistsExceptionMapper;
import io.imply.cloud.server.jetty.mapper.BadGatewayExceptionMapper;
import io.imply.cloud.server.jetty.mapper.BadRequestExceptionMapper;
import io.imply.cloud.server.jetty.mapper.ClientErrorExceptionMapper;
import io.imply.cloud.server.jetty.mapper.DBIExceptionMapper;
import io.imply.cloud.server.jetty.mapper.ForbiddenExceptionMapper;
import io.imply.cloud.server.jetty.mapper.GatewayTimeoutExceptionMapper;
import io.imply.cloud.server.jetty.mapper.IllegalArgumentExceptionMapper;
import io.imply.cloud.server.jetty.mapper.IllegalStateExceptionMapper;
import io.imply.cloud.server.jetty.mapper.ImplyViolationExceptionMapper;
import io.imply.cloud.server.jetty.mapper.JsonMappingExceptionMapper;
import io.imply.cloud.server.jetty.mapper.JsonParseExceptionMapper;
import io.imply.cloud.server.jetty.mapper.NoResultsExceptionMapper;
import io.imply.cloud.server.jetty.mapper.NotFoundExceptionMapper;
import io.imply.cloud.server.jetty.mapper.NotModifiedExceptionMapper;
import io.imply.cloud.server.jetty.mapper.ProcessingExceptionMapper;
import io.imply.cloud.server.jetty.mapper.ResteasyViolationExceptionMapper;
import io.imply.cloud.server.jetty.mapper.ThrowableMapper;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;

public class JettyServerModule
extends ServletModule {
    private static final Logger log = new Logger(JettyServerModule.class);
    private static final AtomicInteger ACTIVE_CONNECTIONS = new AtomicInteger();

    protected void configureServlets() {
        Binder binder = this.binder();
        JsonConfigProvider.bind((Binder)binder, (String)"server.http", ServerConfig.class);
        binder.bind(HttpServletDispatcher.class).in(Scopes.SINGLETON);
        binder.bind(NotFoundExceptionMapper.class).in(Singleton.class);
        binder.bind(DBIExceptionMapper.class).in(Singleton.class);
        binder.bind(NoResultsExceptionMapper.class).in(Singleton.class);
        binder.bind(IllegalArgumentExceptionMapper.class).in(Singleton.class);
        binder.bind(IllegalStateExceptionMapper.class).in(Singleton.class);
        binder.bind(AccessDeniedExceptionMapper.class).in(Singleton.class);
        binder.bind(BadRequestExceptionMapper.class).in(Singleton.class);
        binder.bind(AlreadyExistsExceptionMapper.class).in(Singleton.class);
        binder.bind(JsonMappingExceptionMapper.class).in(Singleton.class);
        binder.bind(ThrowableMapper.class).in(Singleton.class);
        binder.bind(BadGatewayExceptionMapper.class).in(Singleton.class);
        binder.bind(GatewayTimeoutExceptionMapper.class).in(Singleton.class);
        binder.bind(ImplyViolationExceptionMapper.class).in(Singleton.class);
        binder.bind(NotModifiedExceptionMapper.class).in(Singleton.class);
        binder.bind(ResteasyViolationExceptionMapper.class).in(Singleton.class);
        binder.bind(ForbiddenExceptionMapper.class).in(Singleton.class);
        binder.bind(ClientErrorExceptionMapper.class).in(Singleton.class);
        binder.bind(JsonParseExceptionMapper.class).in(Singleton.class);
        binder.bind(ProcessingExceptionMapper.class).in(Singleton.class);
        binder.bind(AdminServlet.class).in(Singleton.class);
        this.serve("/stats*", new String[0]).with(AdminServlet.class);
        this.serve("/*", new String[0]).with(HttpServletDispatcher.class);
        binder.bind(StatusResource.class).in(LazySingleton.class);
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class);
    }

    @Provides
    @LazySingleton
    public Server getServer(Injector injector, Lifecycle lifecycle, @Self ApplicationNode node, ServerConfig config, HttpConfiguration httpConfig, MetricRegistry metricRegistry, ObjectMapper objectMapper) {
        Server server = JettyServerModule.makeJettyServer(node, httpConfig, config, metricRegistry, objectMapper);
        JettyServerModule.initializeServer(injector, lifecycle, server);
        return server;
    }

    @Provides
    @LazySingleton
    public HttpConfiguration getHttpConfiguration(ServerConfig config) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setRequestHeaderSize(config.getRequestHeaderSize());
        httpConfiguration.setResponseHeaderSize(config.getResponseHeaderSize());
        return httpConfiguration;
    }

    static Server makeJettyServer(ApplicationNode node, HttpConfiguration httpConfig, ServerConfig config, MetricRegistry metricRegistry, ObjectMapper objectMapper) {
        ServerConnector connector;
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool(metricRegistry, config.getNumThreads(), config.getNumThreads());
        threadPool.setDaemon(true);
        threadPool.setName("qtp-jetty");
        Server server = new Server((ThreadPool)threadPool);
        server.addBean((Object)new ScheduledExecutorScheduler("JettyScheduler", true), true);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        if (config.getKeyStorePath() != null) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(config.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
            connector = new ServerConnector(server, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{httpConnectionFactory}));
        } else {
            connector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
        }
        connector.setPort(node.getPort());
        connector.setIdleTimeout((long)Ints.checkedCast((long)config.getMaxIdleTime().toStandardDuration().getMillis()));
        connector.setAcceptorPriorityDelta(-1);
        ArrayList<JettyMonitoringConnectionFactory> monitoredConnFactories = new ArrayList<JettyMonitoringConnectionFactory>();
        for (ConnectionFactory cf : connector.getConnectionFactories()) {
            monitoredConnFactories.add(new JettyMonitoringConnectionFactory((ConnectionFactory)new InstrumentedConnectionFactory(cf, metricRegistry.timer(MetricRegistry.name(cf.getClass(), (String[])new String[]{"connections"}))), ACTIVE_CONNECTIONS));
        }
        connector.setConnectionFactories(monitoredConnFactories);
        server.setConnectors(new Connector[]{connector});
        server.setErrorHandler((ErrorHandler)new JettyErrorHandler(objectMapper));
        return server;
    }

    static void initializeServer(Injector injector, Lifecycle lifecycle, final Server server) {
        JettyServerInitializer initializer = (JettyServerInitializer)injector.getInstance(JettyServerInitializer.class);
        try {
            initializer.initialize(server, injector);
        }
        catch (ConfigurationException e) {
            throw new ProvisionException(((Message)Iterables.getFirst((Iterable)e.getErrorMessages(), null)).getMessage());
        }
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                server.start();
            }

            public void stop() {
                try {
                    server.stop();
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Unable to stop Jetty server.");
                }
            }
        });
    }
}

