/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlet.InstrumentedFilterContextListener;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import io.imply.cloud.server.jetty.JettyServerInitializer;
import io.imply.cloud.server.jetty.ServerConfig;
import java.util.EventListener;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.jboss.resteasy.plugins.guice.GuiceResteasyBootstrapServletContextListener;

public class JettyServerInitializerImpl
implements JettyServerInitializer {
    @Override
    public void initialize(Server server, final Injector injector) {
        final MetricRegistry metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
        ServletContextHandler root = new ServletContextHandler(1);
        root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        root.addFilter(InstrumentedFilter.class, "/*", null);
        root.addFilter(GuiceFilter.class, "/*", null);
        root.addEventListener((EventListener)injector.getInstance(GuiceResteasyBootstrapServletContextListener.class));
        root.addEventListener((EventListener)new HealthCheckServlet.ContextListener(){

            protected HealthCheckRegistry getHealthCheckRegistry() {
                return (HealthCheckRegistry)injector.getInstance(HealthCheckRegistry.class);
            }
        });
        root.addEventListener((EventListener)new MetricsServlet.ContextListener(){

            protected MetricRegistry getMetricRegistry() {
                return metricRegistry;
            }
        });
        root.addEventListener((EventListener)new InstrumentedFilterContextListener(){

            protected MetricRegistry getMetricRegistry() {
                return metricRegistry;
            }
        });
        SecurityHandler handler = this.getSecurityHandler(injector);
        if (handler != null) {
            root.setSecurityHandler(handler);
        }
        InstrumentedHandler instrumentedHandler = new InstrumentedHandler(metricRegistry);
        instrumentedHandler.setHandler((Handler)root);
        server.setHandler((Handler)instrumentedHandler);
    }

    protected SecurityHandler getSecurityHandler(Injector injector) {
        ServerConfig serverConfig = (ServerConfig)injector.getInstance(ServerConfig.class);
        if (serverConfig.getUsername() != null && serverConfig.getPassword() != null) {
            return JettyServerInitializerImpl.getBasicAuthSecurityHandler(serverConfig);
        }
        return null;
    }

    private static SecurityHandler getBasicAuthSecurityHandler(ServerConfig serverConfig) {
        String[] roles = new String[]{"user"};
        UserStore userStore = new UserStore();
        userStore.addUser(serverConfig.getUsername(), Credential.getCredential((String)serverConfig.getPassword()), roles);
        HashLoginService hashLoginService = new HashLoginService();
        hashLoginService.setUserStore(userStore);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(roles);
        constraint.setAuthenticate(serverConfig.getAuthenticate().booleanValue());
        ConstraintMapping statusMapping = new ConstraintMapping();
        statusMapping.setConstraint(new Constraint());
        statusMapping.setPathSpec("/status");
        ConstraintMapping authMapping = new ConstraintMapping();
        authMapping.setConstraint(constraint);
        authMapping.setPathSpec("/*");
        ConstraintSecurityHandler constraintSecurityHandler = new ConstraintSecurityHandler();
        constraintSecurityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        constraintSecurityHandler.addConstraintMapping(statusMapping);
        constraintSecurityHandler.addConstraintMapping(authMapping);
        constraintSecurityHandler.setLoginService((LoginService)hashLoginService);
        return constraintSecurityHandler;
    }
}

