/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class JettyErrorHandler
extends ErrorHandler {
    private final ObjectMapper objectMapper;

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request, HttpServletResponse response, int code, String message) throws IOException {
        response.setContentType(MimeTypes.Type.APPLICATION_JSON.asString());
        response.setStatus(code);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(code, null);
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)ErrorResponse.of((Error)Error.builder().code(ErrorCode.getByStatusCode((int)code)).message(reason).build())));
        baseRequest.setHandled(true);
    }

    @Inject
    @Generated
    public JettyErrorHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

