/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.guice;

import com.google.common.base.Throwables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.lifecycle.Lifecycle;
import io.imply.cloud.log.StartupLoggingConfig;
import io.imply.cloud.server.Initialization;
import io.imply.cloud.util.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public abstract class GuiceRunnable
implements Runnable {
    private final Logger log;
    private Injector baseInjector;

    public GuiceRunnable(Logger log) {
        this.log = log;
    }

    @Inject
    public void configure(Injector injector) {
        this.baseInjector = injector;
    }

    protected abstract List<? extends Module> getModules();

    public Injector makeInjector() {
        try {
            return Initialization.makeInjectorWithModules(this.baseInjector, this.getModules());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Lifecycle initLifecycle(Injector injector) {
        try {
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            StartupLoggingConfig startupLoggingConfig = (StartupLoggingConfig)injector.getInstance(StartupLoggingConfig.class);
            this.log.info("Starting up with processors[%,d], memory[%,d].", new Object[]{Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().totalMemory()});
            ApplicationConfig appConfig = (ApplicationConfig)injector.getInstance(ApplicationConfig.class);
            this.log.info("Service name: [%s] Platform: [%s]", new Object[]{appConfig.getServiceName(), appConfig.getPlatform()});
            if (startupLoggingConfig.isLogProperties()) {
                HashSet maskProperties = Sets.newHashSet((Iterable)startupLoggingConfig.getMaskProperties());
                Properties props = (Properties)injector.getInstance(Properties.class);
                for (String propertyName : Ordering.natural().sortedCopy(props.stringPropertyNames())) {
                    String property = props.getProperty(propertyName);
                    for (String masked : maskProperties) {
                        if (!propertyName.contains(masked)) continue;
                        property = "<masked>";
                        break;
                    }
                    this.log.info("* %s: %s", new Object[]{propertyName, property});
                }
            }
            try {
                lifecycle.start();
            }
            catch (Throwable t) {
                this.log.error(t, "Error when starting up.  Failing.");
                System.exit(1);
            }
            return lifecycle;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

