/*
 * Decompiled with CFR 0.152.
 */
package io.imply.telemetry;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class ClarityEmitterConfig {
    private static final long DEFAULT_FLUSH_MILLIS = 60000L;
    private static final int DEFAULT_FLUSH_COUNT = 500;
    private static final int DEFAULT_FLUSH_BUFFER_PERCENT_FULL = 25;
    private static final long DEFAULT_FLUSH_TIMEOUT = Long.MAX_VALUE;
    private static final int DEFAULT_MAX_BATCH_SIZE = 0x500000;
    private static final long DEFAULT_MAX_BUFFER_SIZE = 0x1400000L;
    private static final Compression DEFAULT_COMPRESSION = Compression.GZIP;
    @JsonProperty
    final long flushMillis;
    @JsonProperty
    final int flushCount;
    @JsonProperty
    final int flushBufferPercentFull;
    @JsonProperty
    final long flushTimeout;
    @JsonProperty
    final int maxBatchSize;
    @JsonProperty
    final long maxBufferSize;
    @JsonProperty
    final Compression compression;
    @JsonProperty
    final Map<String, Object> attributes;
    @JsonProperty
    final URL baseUrl;
    @JsonProperty
    final String username;
    @JsonProperty
    final String password;

    private ClarityEmitterConfig() {
        this.flushMillis = 60000L;
        this.flushCount = 500;
        this.flushBufferPercentFull = 25;
        this.flushTimeout = Long.MAX_VALUE;
        this.maxBatchSize = 0x500000;
        this.maxBufferSize = 0x1400000L;
        this.compression = DEFAULT_COMPRESSION;
        this.attributes = Collections.emptyMap();
        this.baseUrl = null;
        this.username = null;
        this.password = null;
    }

    private ClarityEmitterConfig(Long flushMillis, Integer flushCount, Integer flushBufferPercentFull, Long flushTimeout, Integer maxBatchSize, Long maxBufferSize, Compression compression, Map<String, Object> attributes, String baseUrl, String username, String password) {
        this.flushMillis = this.getSystemOrDefault(flushMillis, 60000L, "imply.telemetry.flushMillis");
        this.flushCount = this.getSystemOrDefault(flushCount, 500, "imply.telemetry.flushCount");
        this.flushBufferPercentFull = this.getSystemOrDefault(flushBufferPercentFull, 25, "imply.telemetry.flushBufferPercentFull");
        this.flushTimeout = this.getSystemOrDefault(flushTimeout, Long.MAX_VALUE, "imply.telemetry.flushTimeout");
        this.maxBatchSize = this.getSystemOrDefault(maxBatchSize, 0x500000, "imply.telemetry.maxBatchSize");
        this.maxBufferSize = this.getSystemOrDefault(maxBufferSize, 0x1400000L, "imply.telemetry.maxBufferSize");
        this.compression = this.getSystemOrDefault(compression, DEFAULT_COMPRESSION, "imply.telemetry.compression", Compression::valueOf);
        this.attributes = attributes;
        try {
            this.baseUrl = new URL(Objects.requireNonNull(this.getSystemOrDefault(baseUrl, "imply.telemetry.baseUrl"), "baseUrl must be configured, set via imply.telemetry.baseUrl or in builder"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("baseUrl must be a valid URL", e);
        }
        this.username = this.getSystemOrDefault(username, "imply.telemetry.username");
        this.password = this.getSystemOrDefault(password, "imply.telemetry.password");
        this.validate();
    }

    ClarityEmitterConfig validate() {
        if (this.flushMillis < 1L) {
            throw new IllegalArgumentException("flushMillis must be >= 1");
        }
        if (this.flushCount < 0) {
            throw new IllegalArgumentException("flushCount must be >= 0");
        }
        if (this.flushBufferPercentFull < 0 || this.flushBufferPercentFull > 100) {
            throw new IllegalArgumentException("flushBufferPercentFull must be between 0 and 100");
        }
        if (this.flushTimeout < 1L) {
            throw new IllegalArgumentException("flushTimeout must be >= 1");
        }
        if (this.maxBatchSize < 1047552) {
            throw new IllegalArgumentException(String.format("maxBatchSize must be >= %,d", 1047552));
        }
        if (this.maxBufferSize < (long)this.maxBatchSize) {
            throw new IllegalArgumentException("maxBufferSize must be greater than maxBatchSize");
        }
        Objects.requireNonNull(this.baseUrl, "baseUrl must be configured, set via imply.telemetry.baseUrl or in builder");
        Objects.requireNonNull(this.username, "username must be configured, set via imply.telemetry.username or in builder");
        Objects.requireNonNull(this.password, "password must be configured, set via imply.telemetry.password or in builder");
        return this;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.baseUrl == null && this.username == null && this.password == null;
    }

    private Long getSystemOrDefault(Long value, Long defaultValue, String propName) {
        return this.getSystemOrDefault(value, defaultValue, propName, Long::parseLong);
    }

    private Integer getSystemOrDefault(Integer value, Integer defaultValue, String propName) {
        return this.getSystemOrDefault(value, defaultValue, propName, Integer::parseInt);
    }

    private String getSystemOrDefault(String value, String propName) {
        return this.getSystemOrDefault(value, null, propName, Function.identity());
    }

    private <T> T getSystemOrDefault(T value, T defaultValue, String propName, Function<String, T> converter) {
        if (value != null) {
            return value;
        }
        String prop = System.getProperty(propName);
        if (prop != null) {
            return converter.apply(prop);
        }
        return defaultValue;
    }

    public static ClarityEmitterConfig defaultConfig() {
        return ClarityEmitterConfig.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Long flushMillis;
        private Integer flushCount;
        private Integer flushBufferPercentFull;
        private Long flushTimeout;
        private Integer maxBatchSize;
        private Long maxBufferSize;
        private Compression compression;
        private Map<String, Object> attributes;
        private String baseUrl;
        private String username;
        private String password;

        private Builder() {
            this.attributes = new HashMap<String, Object>();
        }

        private Builder(ClarityEmitterConfig config) {
            this.flushMillis = config.flushMillis;
            this.flushCount = config.flushCount;
            this.flushBufferPercentFull = config.flushBufferPercentFull;
            this.flushTimeout = config.flushTimeout;
            this.maxBatchSize = config.maxBatchSize;
            this.maxBufferSize = config.maxBufferSize;
            this.compression = config.compression;
            this.attributes = new HashMap<String, Object>(config.attributes);
            this.baseUrl = config.baseUrl.toString();
            this.username = config.username;
            this.password = config.password;
        }

        public Builder flushMillis(long flushMillis) {
            this.flushMillis = flushMillis;
            return this;
        }

        public Builder flushCount(int flushCount) {
            this.flushCount = flushCount;
            return this;
        }

        public Builder flushBufferPercentFull(int flushBufferPercentFull) {
            this.flushBufferPercentFull = flushBufferPercentFull;
            return this;
        }

        public Builder flushTimeout(long flushTimeout) {
            this.flushTimeout = flushTimeout;
            return this;
        }

        public Builder maxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder maxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Builder compression(Compression compression) {
            this.compression = compression;
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.attributes = new HashMap<String, Object>(attributes);
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public ClarityEmitterConfig build() {
            return new ClarityEmitterConfig(this.flushMillis, this.flushCount, this.flushBufferPercentFull, this.flushTimeout, this.maxBatchSize, this.maxBufferSize, this.compression, this.attributes, this.baseUrl, this.username, this.password);
        }
    }

    public static enum Compression {
        NONE,
        GZIP;

    }
}

