/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.validators;

import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.InnerError;
import io.imply.cloud.validators.ConstraintValidatorHelper;
import io.imply.cloud.validators.ProjectPlanName;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;

public class ProjectPlanNameValidator
implements ConstraintValidator<ProjectPlanName, CharSequence> {
    @Inject
    private RefreshableConstants refreshableConstants;

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || value.equals("custom")) {
            return true;
        }
        Set<String> keys = this.refreshableConstants.getProjectSizeMap().keySet();
        if (keys.contains(value)) {
            return true;
        }
        ConstraintValidatorHelper.setError(Error.builder().code(ErrorCode.BAD_ARGUMENT).message(String.format("invalid project plan [%s]", value)).innerError(InnerError.builder().code("InvalidProjectPlan").field("plans", keys).build()).build(), context);
        return false;
    }

    @Generated
    protected ProjectPlanNameValidator(RefreshableConstants refreshableConstants) {
        this.refreshableConstants = refreshableConstants;
    }

    @Inject
    @Generated
    public ProjectPlanNameValidator() {
    }
}

