/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.validators;

import com.google.inject.Inject;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.InnerError;
import io.imply.cloud.validators.ConstraintValidatorHelper;
import io.imply.cloud.validators.ImplyVersionFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;

public class ImplyVersionFormatValidator
implements ConstraintValidator<ImplyVersionFormat, CharSequence> {
    private static final Pattern IMPLY_VERSION_FORMAT = Pattern.compile("^(?<date>[0-9]+\\.[0-9]+).*$");

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Matcher versionMatcher = IMPLY_VERSION_FORMAT.matcher(value);
        if (versionMatcher.matches()) {
            return true;
        }
        ConstraintValidatorHelper.setError(Error.builder().code(ErrorCode.BAD_ARGUMENT).message(String.format("Imply Version must be formatted with the year and month eg:[2023.03*]", new Object[0])).innerError(InnerError.builder().code("InvalidVersion").field("version", (Object)value).build()).build(), context);
        return false;
    }

    @Inject
    @Generated
    public ImplyVersionFormatValidator() {
    }
}

