/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.validators;

import com.google.inject.Inject;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.InnerError;
import io.imply.cloud.util.ResourceValidationClient;
import io.imply.cloud.validators.ConstraintValidatorHelper;
import io.imply.cloud.validators.ImplyBundleExists;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;

public class ImplyBundleExistsValidator
implements ConstraintValidator<ImplyBundleExists, CharSequence> {
    @Inject
    private ResourceValidationClient client;

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || this.client == null) {
            return true;
        }
        if (this.client.bundleExists(value.toString())) {
            return true;
        }
        ConstraintValidatorHelper.setError(Error.builder().code(ErrorCode.BAD_ARGUMENT).message(String.format("invalid bundle id [%s]", value)).innerError(InnerError.builder().code("InvalidBundleId").field("bundleId", (Object)value).build()).build(), context);
        return false;
    }

    @Generated
    public ImplyBundleExistsValidator(ResourceValidationClient client) {
        this.client = client;
    }

    @Inject
    @Generated
    public ImplyBundleExistsValidator() {
    }
}

