/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.validators;

import com.google.inject.Inject;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.InnerError;
import io.imply.cloud.util.ResourceValidationClient;
import io.imply.cloud.validators.ConstraintValidatorHelper;
import io.imply.cloud.validators.DockerImageExists;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;

public class DockerImageExistsValidator
implements ConstraintValidator<DockerImageExists, CharSequence> {
    @Inject
    private ResourceValidationClient client;

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || this.client == null) {
            return true;
        }
        if (this.client.dockerImageExists(value.toString())) {
            return true;
        }
        ConstraintValidatorHelper.setError(Error.builder().code(ErrorCode.BAD_ARGUMENT).message(String.format("invalid docker image [%s]", value)).innerError(InnerError.builder().code("MissingDockerImage").field("dockerImage", (Object)value).build()).build(), context);
        return false;
    }

    @Generated
    public DockerImageExistsValidator(ResourceValidationClient client) {
        this.client = client;
    }

    @Inject
    @Generated
    public DockerImageExistsValidator() {
    }
}

