/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import io.imply.cloud.Constants;
import io.imply.cloud.util.ISE;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class StringUtils {
    @Deprecated
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String UTF8_STRING = StandardCharsets.UTF_8.toString();

    public static String fromUtf8(byte[] bytes) {
        try {
            return new String(bytes, UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromUtf8(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return StringUtils.fromUtf8(bytes);
    }

    public static String fromUtf8(ByteBuffer buffer) {
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    public static byte[] toUtf8(String string) {
        try {
            return string.getBytes(UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String safeFormat(String message, Object ... formatArgs) {
        if (formatArgs == null || formatArgs.length == 0) {
            return message;
        }
        try {
            return String.format(message, formatArgs);
        }
        catch (IllegalFormatException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static String sanitizeDomainName(String name) {
        if (name == null) {
            return null;
        }
        String sanitized = name.toLowerCase().replaceAll("[-_./]+", " ").replaceAll("[^a-zA-Z0-9\\s]", "").trim().replaceAll("\\s+", "-");
        if (!Constants.DOMAIN_PATTERN.matcher(sanitized).matches()) {
            throw new ISE("Sanitized domain name does not match regex: %s", Constants.DOMAIN_PATTERN.toString());
        }
        return sanitized;
    }

    public static String stripLeadingChar(char toRemove, String value) {
        if (value == null) {
            return value;
        }
        while (!value.isEmpty() && value.charAt(0) == toRemove) {
            value = value.substring(1);
        }
        return value;
    }

    public static String stripTrailingChar(char toRemove, String value) {
        if (value == null) {
            return value;
        }
        while (!value.isEmpty() && value.charAt(value.length() - 1) == toRemove) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String stripLeadingAndTrailingChars(char toRemove, String value) {
        return StringUtils.stripLeadingChar(toRemove, StringUtils.stripTrailingChar(toRemove, value));
    }

    public static String stripLeadingSlashes(String value) {
        return StringUtils.stripLeadingChar('/', value);
    }

    public static String stripTrailingSlashes(String value) {
        return StringUtils.stripTrailingChar('/', value);
    }

    public static String stripLeadingAndTrailingSlashes(String value) {
        return StringUtils.stripLeadingAndTrailingChars('/', value);
    }

    public static String joinWithOxfordComma(Collection<String> items, String conjunction) {
        Preconditions.checkNotNull((Object)conjunction);
        if (items == null) {
            return "";
        }
        Iterator<String> it = items.iterator();
        if (items.size() == 1) {
            return it.next();
        }
        if (items.size() == 2) {
            return String.format("%s %s %s", it.next(), conjunction, it.next());
        }
        return String.format("%s, %s %s", Joiner.on((String)", ").join(Iterators.limit(it, (int)(items.size() - 1))), conjunction, Iterators.getLast(it));
    }

    public static String joinWithOxfordComma(Collection<String> items) {
        return StringUtils.joinWithOxfordComma(items, "and");
    }

    public static String markdownBold(String item) {
        return String.format("**%s**", item);
    }

    public static List<String> markdownBold(Collection<String> items) {
        return items == null ? null : items.stream().map(StringUtils::markdownBold).collect(Collectors.toList());
    }
}

