/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import io.imply.cloud.util.ThreadLocalContext;
import java.nio.charset.StandardCharsets;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class RefreshableConstantsS3Updater
implements RefreshableConstantsUpdater {
    private static final Logger log = new Logger(RefreshableConstantsS3Updater.class);
    private final RefreshableConstantsConfig refreshableConstantsConfig;
    private final ApplicationConfig applicationConfig;
    private final RefreshableConstants refreshableConstants;

    @Inject
    public RefreshableConstantsS3Updater(RefreshableConstantsConfig refreshableConstantsConfig, ApplicationConfig applicationConfig, RefreshableConstants refreshableConstants) {
        this.refreshableConstantsConfig = refreshableConstantsConfig;
        this.applicationConfig = applicationConfig;
        this.refreshableConstants = refreshableConstants;
    }

    @Override
    public void seed() {
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(boolean failOnException) {
        log.info("Updating RefreshableConstants");
        try {
            ThreadLocalContext.setNoticeOrActionClass(this.getClass());
            S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)S3Client.builder().region(Region.of((String)this.refreshableConstantsConfig.getS3Region()));
            if (this.refreshableConstantsConfig.getAccessKey() != null && this.refreshableConstantsConfig.getSecretKey() != null) {
                s3ClientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.refreshableConstantsConfig.getAccessKey().getPassword(), (String)this.refreshableConstantsConfig.getSecretKey().getPassword())));
            }
            S3Client s3Client = (S3Client)s3ClientBuilder.build();
            UnaryOperator configSupplier = key -> {
                log.info("Fetching refreshable constant: s3://%s/%s", this.refreshableConstantsConfig.getS3Bucket(), key);
                return s3Client.getObjectAsBytes((GetObjectRequest)GetObjectRequest.builder().bucket(this.refreshableConstantsConfig.getS3Bucket()).key(key).build()).asString(StandardCharsets.UTF_8);
            };
            this.refreshableConstants.refresh(this.refreshableConstantsConfig, configSupplier, this.applicationConfig, failOnException);
        }
        finally {
            ThreadLocalContext.clear();
        }
    }
}

