/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import io.imply.cloud.util.ThreadLocalContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.http.HttpMethod;

public class RefreshableConstantsHttpUpdater
implements RefreshableConstantsUpdater {
    private static final Logger log = new Logger(RefreshableConstantsHttpUpdater.class);
    private final HttpClientProvider httpClientProvider;
    private final RefreshableConstantsConfig refreshableConstantsConfig;
    private final ApplicationConfig applicationConfig;
    private final RefreshableConstants refreshableConstants;

    @Inject
    public RefreshableConstantsHttpUpdater(HttpClientProvider httpClientProvider, RefreshableConstantsConfig refreshableConstantsConfig, ApplicationConfig applicationConfig, RefreshableConstants refreshableConstants) {
        this.httpClientProvider = httpClientProvider;
        this.refreshableConstantsConfig = refreshableConstantsConfig;
        this.applicationConfig = applicationConfig;
        this.refreshableConstants = refreshableConstants;
    }

    @Override
    public void seed() {
        this.refresh(true);
    }

    @Override
    public void refresh(boolean failOnException) {
        if (!this.refreshableConstants.isEmpty() && this.refreshableConstantsConfig.isSkipRefresh()) {
            return;
        }
        log.info("Updating RefreshableConstants");
        try {
            ThreadLocalContext.setNoticeOrActionClass(this.getClass());
            this.refreshableConstants.refresh(this.refreshableConstantsConfig, this::fetchConfigKey, this.applicationConfig, failOnException);
        }
        finally {
            ThreadLocalContext.clear();
        }
    }

    private String fetchConfigKey(String key) {
        return this.fetchUri(String.format("%s/%s", this.refreshableConstantsConfig.getHttpRepositoryHost(), key));
    }

    @VisibleForTesting
    String fetchUri(String uri) {
        log.info("Fetching refreshable constant: %s", uri);
        Request request = this.httpClientProvider.get(true).newRequest(uri).method(HttpMethod.GET).timeout((long)this.refreshableConstantsConfig.getHttpTimeout().intValue(), TimeUnit.SECONDS);
        if (this.refreshableConstantsConfig.getHttpQueryParams() != null) {
            for (Map.Entry<String, String> param : this.refreshableConstantsConfig.getHttpQueryParams().entrySet()) {
                request.param(param.getKey(), param.getValue());
            }
        }
        if (this.refreshableConstantsConfig.getUsername() != null && this.refreshableConstantsConfig.getPassword() != null) {
            BasicAuthentication.BasicResult auth = new BasicAuthentication.BasicResult(request.getURI(), this.refreshableConstantsConfig.getUsername(), this.refreshableConstantsConfig.getPassword());
            auth.apply(request);
        }
        try {
            ContentResponse response = request.send();
            if (response.getStatus() / 100 != 2) {
                throw new ISE("Status code [%d] calling GET %s", response.getStatus(), uri);
            }
            return response.getContentAsString();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

