/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.io.Files;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.util.RefreshableConstantsUpdater;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import lombok.Generated;

public class RefreshableConstantsFileUpdater
implements RefreshableConstantsUpdater {
    private final RefreshableConstantsConfig refreshableConstantsConfig;
    private final ApplicationConfig applicationConfig;
    private final RefreshableConstants refreshableConstants;

    @Override
    public void seed() {
        this.refreshableConstants.refresh(this.refreshableConstantsConfig, this::fetch, this.applicationConfig, true);
    }

    @Override
    public void refresh(boolean failOnException) {
    }

    private String fetch(String key) {
        Path path = Paths.get(this.refreshableConstantsConfig.getBasePath(), key);
        try {
            return Files.asCharSource((File)path.toFile(), (Charset)StandardCharsets.UTF_8).read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    @Generated
    public RefreshableConstantsFileUpdater(RefreshableConstantsConfig refreshableConstantsConfig, ApplicationConfig applicationConfig, RefreshableConstants refreshableConstants) {
        this.refreshableConstantsConfig = refreshableConstantsConfig;
        this.applicationConfig = applicationConfig;
        this.refreshableConstants = refreshableConstants;
    }
}

