/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class PropertiesHelper {
    public static String convertMapToPropertiesFileFormat(Map<String, Object> propertiesMap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Properties props = new Properties();
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue() instanceof String ? (String)entry.getValue() : entry.getValue().toString());
        }
        try {
            props.store(baos, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)baos).toString().replaceFirst("^#.*\n", "");
    }

    public static Map<String, String> convertPropertiesFileToMap(String data) {
        if (data == null || data.isEmpty()) {
            return ImmutableMap.of();
        }
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props.entrySet().stream().collect(Collectors.toMap(x -> x.getKey().toString(), x -> x.getValue().toString()));
    }

    public static String convertPropertiesToSortedPropertiesFileString(Properties props) throws IOException {
        byte[] contents;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            props.store(os, null);
            contents = os.toByteArray();
        }
        String stringContent = new String(contents, StandardCharsets.UTF_8);
        stringContent = stringContent.replaceFirst("^#.*\n", "");
        Object[] serializedProps = stringContent.split("\n");
        Arrays.sort(serializedProps);
        return String.join((CharSequence)"\n", (CharSequence[])serializedProps);
    }

    public static String convertPropertiesToSortedPropertiesFileString(Map<String, Object> propertiesMap) throws IOException {
        return PropertiesHelper.convertPropertiesToSortedPropertiesFileString(MapUtils.toProperties(propertiesMap));
    }
}

