/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapUtils {
    public static void deepMerge(Map original, Map newMap) {
        for (Map.Entry e : newMap.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (original.containsKey(key)) {
                Object originalValue = original.get(key);
                if (Objects.equal(originalValue, value)) continue;
                if (originalValue instanceof Set && value instanceof Set) {
                    HashSet set = new HashSet((Set)originalValue);
                    set.addAll((Set)value);
                    original.put(key, set);
                    continue;
                }
                if (originalValue instanceof Map && value instanceof Map) {
                    HashMap map = new HashMap((Map)originalValue);
                    map.putAll((Map)value);
                    original.put(key, map);
                    MapUtils.deepMerge((Map)original.get(key), (Map)value);
                    continue;
                }
            }
            original.put(key, value);
        }
    }

    public static Map<String, String> mergePropertyMap(Map<String, String> original, Map<String, String> newMap) {
        if (original == null) {
            return newMap;
        }
        if (newMap == null) {
            return original;
        }
        HashMap<String, String> mutableOriginal = new HashMap<String, String>(original);
        mutableOriginal.putAll(newMap);
        return mutableOriginal.entrySet().stream().filter(x -> x.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> first, Map<K, V> second) {
        HashMap<K, V> map = new HashMap<K, V>(first);
        map.putAll(second);
        return map;
    }
}

