/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import io.imply.cloud.util.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Logger {
    private static final String EMIT_KEY = "emitFlag";
    private static final String EMIT_VALUE = "+";
    private final org.slf4j.Logger log;

    public Logger(String name) {
        this.log = LoggerFactory.getLogger((String)name);
    }

    public Logger(Class<?> clazz) {
        this.log = LoggerFactory.getLogger(clazz);
    }

    public static Logger from(Class<?> clazz) {
        return new Logger(clazz);
    }

    public void trace(String message) {
        this.log.trace(message);
    }

    @FormatMethod
    public void trace(@FormatString String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(StringUtils.safeFormat(message, formatArgs));
        }
    }

    public void trace(Throwable t, String message) {
        this.log.trace(message, t);
    }

    @FormatMethod
    public void trace(Throwable t, @FormatString String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(StringUtils.safeFormat(message, formatArgs), t);
        }
    }

    public void debug(String message) {
        this.log.debug(message);
    }

    @FormatMethod
    public void debug(@FormatString String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(StringUtils.safeFormat(message, formatArgs));
        }
    }

    public void debug(Throwable t, String message) {
        this.log.debug(message, t);
    }

    @FormatMethod
    public void debug(Throwable t, @FormatString String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(StringUtils.safeFormat(message, formatArgs), t);
        }
    }

    public void info(String message) {
        this.log.info(message);
    }

    @FormatMethod
    public void info(@FormatString String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(StringUtils.safeFormat(message, formatArgs));
        }
    }

    public void info(Throwable t, String message) {
        this.log.info(message, t);
    }

    @FormatMethod
    public void info(Throwable t, @FormatString String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(StringUtils.safeFormat(message, formatArgs), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FormatMethod
    public void info(boolean emit, @FormatString String message, Object ... formatArgs) {
        if (emit) {
            try {
                MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
                this.info(message, formatArgs);
            }
            finally {
                MDC.remove((String)EMIT_KEY);
            }
        } else {
            this.info(message, formatArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FormatMethod
    public void info(boolean emit, Throwable t, @FormatString String message, Object ... formatArgs) {
        if (emit) {
            try {
                MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
                this.info(t, message, formatArgs);
            }
            finally {
                MDC.remove((String)EMIT_KEY);
            }
        } else {
            this.info(message, formatArgs);
        }
    }

    @Deprecated
    public void warn(String message, Throwable t) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.warn(message, t);
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    public void warn(String message) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.warn(message);
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    @FormatMethod
    public void warn(@FormatString String message, Object ... formatArgs) {
        if (this.log.isWarnEnabled()) {
            this.warn(StringUtils.safeFormat(message, formatArgs));
        }
    }

    public void warn(Throwable t, String message) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.warn(message, t);
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    @FormatMethod
    public void warn(Throwable t, @FormatString String message, Object ... formatArgs) {
        if (this.log.isWarnEnabled()) {
            this.warn(t, StringUtils.safeFormat(message, formatArgs));
        }
    }

    @Deprecated
    public void error(String message, Throwable t) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.error(message, t);
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    public void error(String message) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.error(message);
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    @FormatMethod
    public void error(@FormatString String message, Object ... formatArgs) {
        if (this.log.isErrorEnabled()) {
            this.error(StringUtils.safeFormat(message, formatArgs));
        }
    }

    public void error(Throwable t, String message) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.error(message, t);
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    @FormatMethod
    public void error(Throwable t, @FormatString String message, Object ... formatArgs) {
        if (this.log.isErrorEnabled()) {
            this.error(t, StringUtils.safeFormat(message, formatArgs));
        }
    }

    @FormatMethod
    public void wtf(@FormatString String message, Object ... formatArgs) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.error(StringUtils.safeFormat("WTF?!: " + message, formatArgs), (Throwable)new Exception());
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FormatMethod
    public void wtf(Throwable t, @FormatString String message, Object ... formatArgs) {
        try {
            MDC.put((String)EMIT_KEY, (String)EMIT_VALUE);
            this.log.error(StringUtils.safeFormat("WTF?!: " + message, formatArgs), t);
        }
        finally {
            MDC.remove((String)EMIT_KEY);
        }
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }
}

